/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.openide.awt.QuickSearch;
import org.openide.explorer.view.OutlineView;
import org.openide.explorer.view.QuickSearchTableFilter;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

class TableQuickSearchSupport
implements QuickSearch.Callback {
    private int quickSearchInitialRow = -1;
    private int quickSearchInitialColumn = -1;
    private int quickSearchLastRow = -1;
    private int quickSearchLastColumn = -1;
    private Point quickSearchLastPos = null;
    private String lastSearchText;
    private JTable table;
    private QuickSearchTableFilter quickSearchTableFilter;
    private QuickSearchSettings qss;

    TableQuickSearchSupport(JTable jTable, QuickSearchTableFilter quickSearchTableFilter, QuickSearchSettings quickSearchSettings) {
        this.table = jTable;
        this.quickSearchTableFilter = quickSearchTableFilter;
        this.qss = quickSearchSettings;
    }

    public void setQuickSearchTableFilter(QuickSearchTableFilter quickSearchTableFilter, boolean bl) {
        this.quickSearchTableFilter = quickSearchTableFilter;
    }

    public void quickSearchUpdate(String string) {
        this.lastSearchText = string;
        if (this.quickSearchInitialRow == -1) {
            this.quickSearchInitialRow = this.table.getSelectedRow();
            this.quickSearchInitialColumn = this.table.getSelectedColumn();
            if (this.quickSearchInitialRow == -1) {
                this.quickSearchInitialRow = 0;
            }
            if (this.quickSearchInitialColumn == -1) {
                this.quickSearchInitialColumn = 0;
            }
        }
        this.quickSearchLastRow = this.quickSearchInitialRow;
        this.quickSearchLastColumn = this.quickSearchInitialColumn;
        this.doSearch(string, true);
    }

    public void showNextSelection(boolean bl) {
        if (bl && ++this.quickSearchLastColumn >= this.table.getColumnCount()) {
            this.quickSearchLastColumn = 0;
            if (++this.quickSearchLastRow >= this.table.getRowCount()) {
                this.quickSearchLastRow = 0;
            }
        }
        this.doSearch(this.lastSearchText, bl);
    }

    public String findMaxPrefix(String string) {
        String string2 = this.qss.isMatchCase() ? string : string.toUpperCase();
        int n = 0;
        int n2 = this.table.getRowCount();
        int n3 = 0;
        int n4 = this.table.getColumnCount();
        String string3 = null;
        for (int i = n; i < n2; ++i) {
            for (int j = n3; j < n4; ++j) {
                String string4 = this.quickSearchTableFilter.getStringValueAt(i, j);
                String string5 = this.qss.isMatchCase() ? string4 : string4.toUpperCase();
                if (!string5.startsWith(string2)) continue;
                string3 = string3 == null ? string4 : QuickSearch.findMaxPrefix((String)string3, (String)string4, (!this.qss.isMatchCase() ? 1 : 0) != 0);
            }
        }
        if (string3 != null) {
            return string3;
        }
        return string;
    }

    public void quickSearchConfirmed() {
        if (this.quickSearchLastPos != null) {
            this.displaySearchResult(this.quickSearchLastPos.x, this.quickSearchLastPos.y);
        }
        this.quickSearchInitialRow = -1;
        this.quickSearchInitialColumn = -1;
    }

    public void quickSearchCanceled() {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component != null) {
            this.displaySearchResult(this.quickSearchInitialRow, this.quickSearchInitialColumn);
        }
        this.quickSearchInitialRow = -1;
        this.quickSearchInitialColumn = -1;
        this.quickSearchLastPos = null;
    }

    private void doSearch(String string, boolean bl) {
        if (!this.qss.isMatchCase()) {
            string = string.toUpperCase();
        }
        int n = this.table.getRowCount();
        int n2 = this.quickSearchLastRow;
        int n3 = this.quickSearchLastRow + n;
        boolean bl2 = true;
        Set<String> set = this.qss.getColumnsIgnoredToSearch();
        do {
            int n4;
            int n5 = this.quickSearchLastColumn;
            int n6 = bl ? this.table.getColumnCount() : 0;
            int n7 = n4 = bl ? n2 : n3 - 1;
            while (bl ? n4 < n3 : n4 >= n2) {
                int n8 = n5;
                while (bl ? n8 < n6 : n8 >= n6) {
                    String string2;
                    String string3 = this.table.getColumnName(n8);
                    if (!set.contains(string3) && (string2 = this.quickSearchTableFilter.getStringValueAt(n4 % n, n8)) != null) {
                        if (!this.qss.isMatchCase()) {
                            string2 = string2.toUpperCase();
                        }
                        if (bl2) {
                            if (string2.startsWith(string)) {
                                this.displaySearchResult(n4 % n, n8);
                                return;
                            }
                        } else if (string2.indexOf(string) >= 0) {
                            this.displaySearchResult(n4 % n, n8);
                            return;
                        }
                    }
                    n8 = bl ? ++n8 : --n8;
                }
                n5 = bl ? 0 : this.table.getColumnCount() - 1;
                n4 = bl ? ++n4 : --n4;
            }
        } while (!(bl2 = !bl2));
        this.quickSearchLastPos = null;
        this.table.getSelectionModel().clearSelection();
        this.table.getColumnModel().getSelectionModel().clearSelection();
        this.table.scrollRectToVisible(this.table.getCellRect(this.quickSearchInitialRow, this.quickSearchInitialColumn, true));
    }

    private void displaySearchResult(int n, int n2) {
        this.quickSearchLastRow = n;
        this.quickSearchLastColumn = n2;
        this.quickSearchLastPos = new Point(n, n2);
        this.table.getSelectionModel().setSelectionInterval(n, n);
        this.table.getColumnModel().getSelectionModel().setSelectionInterval(n2, n2);
        this.table.scrollRectToVisible(this.table.getCellRect(n, n2, true));
    }

    JMenu createSearchPopupMenu() {
        return new JMenu(){

            @Override
            public JPopupMenu getPopupMenu() {
                return TableQuickSearchSupport.getSearchPopupMenu(TableQuickSearchSupport.this.qss, TableQuickSearchSupport.this.table.getColumnModel(), new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TableQuickSearchSupport.this.doSearch(TableQuickSearchSupport.this.lastSearchText, true);
                    }
                });
            }
        };
    }

    static JPopupMenu getSearchPopupMenu(final QuickSearchSettings quickSearchSettings, TableColumnModel tableColumnModel, final ActionListener actionListener) {
        Serializable serializable;
        JPopupMenu jPopupMenu = new JPopupMenu();
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(NbBundle.getMessage(OutlineView.class, (String)"CTL_MatchCase"), quickSearchSettings.isMatchCase());
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JCheckBoxMenuItem jCheckBoxMenuItem2 = (JCheckBoxMenuItem)itemEvent.getItemSelectable();
                if (jCheckBoxMenuItem2 == jCheckBoxMenuItem) {
                    quickSearchSettings.setMatchCase(jCheckBoxMenuItem2.isSelected());
                } else {
                    String string = jCheckBoxMenuItem2.getText();
                    if (jCheckBoxMenuItem2.isSelected()) {
                        quickSearchSettings.addColumnToSearch(string);
                    } else {
                        quickSearchSettings.removeColumnFromSearch(string);
                    }
                }
                actionListener.actionPerformed(null);
            }
        };
        jCheckBoxMenuItem.addItemListener(itemListener);
        jPopupMenu.add(jCheckBoxMenuItem);
        jPopupMenu.addSeparator();
        Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
        if (enumeration.hasMoreElements()) {
            serializable = new JMenuItem(NbBundle.getMessage(OutlineView.class, (String)"CTL_ColumnsToSearch")){

                @Override
                public void processMouseEvent(MouseEvent mouseEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
                }

                @Override
                protected void processMouseEvent(MouseEvent mouseEvent) {
                }
            };
            ((Component)serializable).setFocusable(false);
            ((JMenuItem)serializable).setModel(new DummyButtonModel());
            jPopupMenu.add((JMenuItem)serializable);
        }
        while (enumeration.hasMoreElements()) {
            serializable = enumeration.nextElement();
            String string = ((TableColumn)serializable).getHeaderValue().toString();
            JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem(string, !quickSearchSettings.getColumnsIgnoredToSearch().contains(string));
            jCheckBoxMenuItem2.addItemListener(itemListener);
            jPopupMenu.add(jCheckBoxMenuItem2);
        }
        return jPopupMenu;
    }

    static final class DummyButtonModel
    implements ButtonModel {
        DummyButtonModel() {
        }

        @Override
        public boolean isArmed() {
            return false;
        }

        @Override
        public boolean isSelected() {
            return false;
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public boolean isPressed() {
            return false;
        }

        @Override
        public boolean isRollover() {
            return false;
        }

        @Override
        public void setArmed(boolean bl) {
        }

        @Override
        public void setSelected(boolean bl) {
        }

        @Override
        public void setEnabled(boolean bl) {
        }

        @Override
        public void setPressed(boolean bl) {
        }

        @Override
        public void setRollover(boolean bl) {
        }

        @Override
        public void setMnemonic(int n) {
        }

        @Override
        public int getMnemonic() {
            return 0;
        }

        @Override
        public void setActionCommand(String string) {
        }

        @Override
        public String getActionCommand() {
            return null;
        }

        @Override
        public void setGroup(ButtonGroup buttonGroup) {
        }

        @Override
        public void addActionListener(ActionListener actionListener) {
        }

        @Override
        public void removeActionListener(ActionListener actionListener) {
        }

        @Override
        public void addItemListener(ItemListener itemListener) {
        }

        @Override
        public void removeItemListener(ItemListener itemListener) {
        }

        @Override
        public void addChangeListener(ChangeListener changeListener) {
        }

        @Override
        public void removeChangeListener(ChangeListener changeListener) {
        }

        @Override
        public Object[] getSelectedObjects() {
            return new Object[0];
        }
    }

    static interface StringValuedTable {
        public String getStringValueAt(int var1, int var2);
    }

    static final class QuickSearchSettings {
        private boolean matchCase = NbPreferences.forModule(QuickSearchSettings.class).getBoolean("matchCase", false);
        private Set<String> columnsIgnoredToSearch = new HashSet<String>();

        QuickSearchSettings() {
        }

        public boolean isMatchCase() {
            return this.matchCase;
        }

        public void setMatchCase(boolean bl) {
            this.matchCase = bl;
            NbPreferences.forModule(QuickSearchSettings.class).putBoolean("matchCase", bl);
        }

        public Set<String> getColumnsIgnoredToSearch() {
            return this.columnsIgnoredToSearch;
        }

        public void addColumnToSearch(String string) {
            this.columnsIgnoredToSearch.remove(string);
        }

        public void removeColumnFromSearch(String string) {
            this.columnsIgnoredToSearch.add(string);
        }
    }
}

