#version 440

layout(location = 0) in vec4 qt_Vertex;
layout(location = 1) in vec2 qt_MultiTexCoord0;
layout(location = 0) out vec2 texCoord;
layout(location = 1) out vec2 fragCoord;

layout(std140, binding = 0) uniform buf {
    mat4 qt_Matrix;
    float qt_Opacity;
    float iTime;
    float cloudsPerspective;
    float cloudsXScale;
    float cloudsYScale;
    vec4 cloudsHorizonColor;
    float cloudsHorizonGlowSize;
    vec4 cloudsColor;
    vec4 cloudsSkyColor;
    float cloudsThickness;
    float cloudsBrightness;
    float cloudsSharpness;
    float cloudsMovementAngle;
    float cloudsSpeed;
    float cloudsXSpeed;
    float cloudsYSpeed;
};

out gl_PerVertex { vec4 gl_Position; };

layout(location = 2) out float glowFactor;
layout(location = 3) out float z;
layout(location = 4) out vec2 tc;
layout(location = 5) out vec2 thresholds;



void main() {
    texCoord = qt_MultiTexCoord0;
    fragCoord = qt_Vertex.xy;
    vec2 vertCoord = qt_Vertex.xy;
    {
        const float invY = 1. - texCoord.y;
        z = 1. / (1. - cloudsPerspective + cloudsPerspective * invY);

        tc = texCoord;

        tc.x -= 0.5;
        tc.x *= z * cloudsXScale;
        tc.y -= 0.5;
        tc.y *= z * cloudsYScale;

        tc.x += iTime * cloudsXSpeed;
        tc.y += iTime * cloudsYSpeed;

        thresholds.s = 1. - cloudsThickness;
        const float d = (1. - thresholds.s) * (5. - 5 * cloudsSharpness);
        thresholds.s -= cloudsThickness * d;
        thresholds.t = thresholds.s + d;

        glowFactor = min(1., invY+ 1. - cloudsHorizonGlowSize);
    }
    gl_Position = qt_Matrix * vec4(vertCoord, 0.0, 1.0);
}
