/*
 * Decompiled with CFR 0.152.
 */
package org.dvb.ui;

import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.RasterFormatException;
import org.dvb.ui.DVBGraphics;
import org.dvb.ui.DVBGraphicsImpl;
import org.dvb.ui.DVBRasterFormatException;

public class DVBBufferedImage
extends Image {
    public static final int TYPE_ADVANCED = 20;
    public static final int TYPE_BASE = 21;
    private int type = 21;
    private BufferedImage bufferedImage;

    public DVBBufferedImage(int width, int height) {
        this(width, height, 21);
    }

    public DVBBufferedImage(int width, int height, int type) {
        if (type != 21 && type != 20) {
            throw new IllegalArgumentException(this.err("Unknown image type " + type));
        }
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException(this.err("Invalid size:" + width + "x" + height));
        }
        this.type = type;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        this.bufferedImage = gc.createCompatibleImage(width, height);
        if (this.bufferedImage == null) {
            this.err("Error creating buffered image");
        }
    }

    private DVBBufferedImage(BufferedImage image, int type) {
        if (image == null) {
            throw new IllegalArgumentException(this.err("null image"));
        }
        this.type = type;
        this.bufferedImage = image;
    }

    public DVBGraphics createGraphics() {
        if (this.bufferedImage == null) {
            this.err("disposed");
            return null;
        }
        DVBGraphicsImpl gfx = new DVBGraphicsImpl(this.bufferedImage.createGraphics());
        gfx.type = this.type;
        return gfx;
    }

    public void dispose() {
        this.bufferedImage = null;
    }

    @Override
    public void flush() {
        if (this.bufferedImage != null) {
            this.bufferedImage.flush();
        }
    }

    @Override
    public Graphics getGraphics() {
        if (this.bufferedImage == null) {
            return null;
        }
        return this.bufferedImage.getGraphics();
    }

    public int getHeight() {
        if (this.bufferedImage == null) {
            return -1;
        }
        return this.bufferedImage.getHeight();
    }

    @Override
    public int getHeight(ImageObserver observer) {
        if (this.bufferedImage == null) {
            return -1;
        }
        return this.bufferedImage.getHeight(observer);
    }

    public Image getImage() {
        return this.bufferedImage;
    }

    @Override
    public Object getProperty(String name, ImageObserver observer) {
        if (this.bufferedImage == null) {
            return null;
        }
        return this.bufferedImage.getProperty(name, observer);
    }

    public int getRGB(int x, int y) {
        if (this.bufferedImage == null) {
            throw new ArrayIndexOutOfBoundsException(this.err("disposed"));
        }
        int width = this.bufferedImage.getWidth();
        int height = this.bufferedImage.getHeight();
        if (x < 0 || y < 0 || x >= width || y >= height) {
            throw new ArrayIndexOutOfBoundsException(this.err("getRGB out of bounds"));
        }
        return this.bufferedImage.getRGB(x, y);
    }

    public int[] getRGB(int startX, int startY, int w, int h, int[] rgbArray, int offset, int scansize) {
        if (this.bufferedImage == null) {
            throw new ArrayIndexOutOfBoundsException(this.err("disposed"));
        }
        int width = this.bufferedImage.getWidth();
        int height = this.bufferedImage.getHeight();
        if (startX < 0 || startY < 0 || startX + w > width || startY + h > height) {
            throw new ArrayIndexOutOfBoundsException(this.err("getRGB(array) out of bounds"));
        }
        return this.bufferedImage.getRGB(startX, startY, w, h, rgbArray, offset, scansize);
    }

    @Override
    public Image getScaledInstance(int width, int height, int hints) {
        if (this.bufferedImage == null) {
            return null;
        }
        return this.bufferedImage.getScaledInstance(width, height, hints);
    }

    @Override
    public ImageProducer getSource() {
        if (this.bufferedImage == null) {
            return null;
        }
        return this.bufferedImage.getSource();
    }

    public DVBBufferedImage getSubimage(int x, int y, int w, int h) throws DVBRasterFormatException {
        if (this.bufferedImage == null) {
            return null;
        }
        try {
            BufferedImage subImage = this.bufferedImage.getSubimage(x, y, w, h);
            return new DVBBufferedImage(subImage, this.type);
        }
        catch (RasterFormatException e) {
            throw new DVBRasterFormatException(this.err(e.getMessage()));
        }
    }

    public int getWidth() {
        if (this.bufferedImage == null) {
            return -1;
        }
        return this.bufferedImage.getWidth();
    }

    @Override
    public int getWidth(ImageObserver observer) {
        if (this.bufferedImage == null) {
            return -1;
        }
        return this.bufferedImage.getWidth(observer);
    }

    public void setRGB(int x, int y, int rgb) {
        if (this.bufferedImage == null) {
            throw new ArrayIndexOutOfBoundsException(this.err("disposed"));
        }
        this.bufferedImage.setRGB(x, y, rgb);
    }

    public void setRGB(int startX, int startY, int w, int h, int[] rgbArray, int offset, int scansize) {
        if (this.bufferedImage == null) {
            throw new ArrayIndexOutOfBoundsException(this.err("disposed"));
        }
        this.bufferedImage.setRGB(startX, startY, w, h, rgbArray, offset, scansize);
    }

    public String toString() {
        return this.getClass().getName() + "[img=" + this.bufferedImage + "]";
    }

    private String err(String msg) {
        System.err.println("DVBBufferedImage: " + msg);
        return msg;
    }
}

