/*
 * Decompiled with CFR 0.152.
 */
package mill.util;

import fansi.Attrs;
import fansi.Str$;
import java.io.Serializable;
import mill.moduledefs.Scaladoc;
import mill.util.AnsiNav$;
import mill.util.PromptLoggerUtil;
import mill.util.Util$;
import os.Path;
import os.read$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.AbstractIterable;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.math.Ordering$Boolean$;
import scala.math.PartialOrdering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class PromptLoggerUtil$ {
    public static final PromptLoggerUtil$ MODULE$ = new PromptLoggerUtil$();
    private static final int defaultTermWidth = 99;
    private static final int defaultTermHeight = 25;
    @Scaladoc(value="/**\n   * How often to update the multiline status prompt on the terminal.\n   * Too frequent is bad because it causes a lot of visual noise,\n   * but too infrequent results in latency. 10 times per second seems reasonable\n   */")
    private static final int promptUpdateIntervalMillis = 100;
    @Scaladoc(value="/**\n   * How often to update the multiline status prompt in non-interactive scenarios,\n   * e.g. background job logs or piped to a log file. Much less frequent than the\n   * interactive scenario because we cannot rely on ANSI codes to over-write the\n   * previous prompt, so we have to be a lot more conservative to avoid spamming\n   * the logs, but we still want to print it occasionally so people can debug stuck\n   * background or CI jobs and see what tasks it is running when stuck\n   */")
    private static final int nonInteractivePromptUpdateIntervalMillis = 60000;
    @Scaladoc(value="/**\n   * Add some extra latency delay to the process of removing an entry from the status\n   * prompt entirely, because removing an entry changes the height of the prompt, which\n   * is even more distracting than changing the contents of a line, so we want to minimize\n   * those occurrences even further.\n   */")
    private static final int statusRemovalHideDelayMillis = 250;
    @Scaladoc(value="/**\n   * How long to wait before actually removing the blank line left by a removed status\n   * and reducing the height of the prompt. Having the prompt change height is even more\n   * distracting than having entries in the prompt disappear, so give it a longer timeout\n   * so it happens less.\n   */")
    private static final int statusRemovalRemoveDelayMillis = 2000;
    @Scaladoc(value="/**\n   * Starting a line with `clearScreen` mucks up tab stops in iTerm, so make sure we navigate `up`\n   * and down via `\\n` to have a \"fresh\" line. This only should get called to clear the prompt, so\n   * the cursor is already at the left-most column, which '\\n' will not change.\n   */")
    private static final byte[] clearScreenToEndBytes = new StringBuilder(1).append(AnsiNav$.MODULE$.clearScreen(0)).append(AnsiNav$.MODULE$.up(1)).append("\n").toString().getBytes();
    private static final Ordering<Seq<String>> seqStringOrdering = new Ordering<Seq<String>>(){

        public Some tryCompare(Object x, Object y) {
            return Ordering.tryCompare$(this, x, y);
        }

        public boolean lteq(Object x, Object y) {
            return Ordering.lteq$(this, x, y);
        }

        public boolean gteq(Object x, Object y) {
            return Ordering.gteq$(this, x, y);
        }

        public boolean lt(Object x, Object y) {
            return Ordering.lt$(this, x, y);
        }

        public boolean gt(Object x, Object y) {
            return Ordering.gt$(this, x, y);
        }

        public boolean equiv(Object x, Object y) {
            return Ordering.equiv$(this, x, y);
        }

        public Object max(Object x, Object y) {
            return Ordering.max$(this, x, y);
        }

        public Object min(Object x, Object y) {
            return Ordering.min$(this, x, y);
        }

        public Ordering<Seq<String>> reverse() {
            return Ordering.reverse$(this);
        }

        public boolean isReverseOf(Ordering<?> other) {
            return Ordering.isReverseOf$(this, other);
        }

        public <U> Ordering<U> on(Function1<U, Seq<String>> f) {
            return Ordering.on$(this, f);
        }

        public Ordering<Seq<String>> orElse(Ordering<Seq<String>> other) {
            return Ordering.orElse$(this, other);
        }

        public <S> Ordering<Seq<String>> orElseBy(Function1<Seq<String>, S> f, Ordering<S> ord) {
            return Ordering.orElseBy$(this, f, ord);
        }

        public Ordering.OrderingOps mkOrderingOps(Object lhs) {
            return Ordering.mkOrderingOps$(this, lhs);
        }

        public int compare(Seq<String> xs, Seq<String> ys) {
            Iterator<Tuple2<A, String>> iter = xs.iterator().zip(ys);
            while (iter.nonEmpty()) {
                Tuple2<A, String> tuple2 = iter.next();
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String x = (String)tuple2._1();
                String y = tuple2._2();
                Tuple2<String, String> tuple22 = new Tuple2<String, String>(x, y);
                String x2 = tuple22._1();
                String y2 = tuple22._2();
                if (StringOps$.MODULE$.$greater$extension(Predef$.MODULE$.augmentString(x2), y2)) {
                    return 1;
                }
                if (!StringOps$.MODULE$.$greater$extension(Predef$.MODULE$.augmentString(y2), x2)) continue;
                return -1;
            }
            return xs.lengthCompare(ys);
        }
        {
            PartialOrdering.$init$(this);
            Ordering.$init$(this);
        }
    };

    public int defaultTermWidth() {
        return defaultTermWidth;
    }

    public int defaultTermHeight() {
        return defaultTermHeight;
    }

    public int promptUpdateIntervalMillis() {
        return promptUpdateIntervalMillis;
    }

    public int nonInteractivePromptUpdateIntervalMillis() {
        return nonInteractivePromptUpdateIntervalMillis;
    }

    public int statusRemovalHideDelayMillis() {
        return statusRemovalHideDelayMillis;
    }

    public int statusRemovalRemoveDelayMillis() {
        return statusRemovalRemoveDelayMillis;
    }

    public byte[] clearScreenToEndBytes() {
        return clearScreenToEndBytes;
    }

    public String spaceNonEmpty(String s) {
        if (s.isEmpty()) {
            return "";
        }
        return new StringBuilder(1).append(" ").append(s).toString();
    }

    public Option<Tuple2<Option<Object>, Option<Object>>> readTerminalDims(Path terminfoPath) {
        Option option;
        try {
            Option option2;
            Option option3;
            Option<Seq<String>> option4;
            String string = read$.MODULE$.apply(terminfoPath);
            if (string == null || (option4 = new StringContext(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s().unapplySeq(string)).isEmpty() || option4.get() == null || ((SeqOps)option4.get()).lengthCompare(2) != 0) {
                throw new MatchError((Object)string);
            }
            String termWidth0 = (String)((SeqOps)option4.get()).apply(0);
            String termHeight0 = (String)((SeqOps)option4.get()).apply(1);
            Tuple2<String, String> tuple2 = new Tuple2<String, String>(termWidth0, termHeight0);
            String termWidth02 = tuple2._1();
            String termHeight02 = tuple2._2();
            int n = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(termWidth02));
            switch (n) {
                case -1: 
                case 0: {
                    option3 = None$.MODULE$;
                    break;
                }
                default: {
                    option3 = new Some<Integer>(BoxesRunTime.boxToInteger(n));
                    break;
                }
            }
            int n2 = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(termHeight02));
            switch (n2) {
                case -1: 
                case 0: {
                    option2 = None$.MODULE$;
                    break;
                }
                default: {
                    option2 = new Some<Integer>(BoxesRunTime.boxToInteger(n2));
                    break;
                }
            }
            option = new Some<Tuple2<None$, None$>>(new Tuple2<None$, None$>((None$)option3, (None$)option2));
        }
        catch (Throwable e) {
            option = None$.MODULE$;
        }
        return option;
    }

    public List<String> renderPrompt(int consoleWidth, int consoleHeight, long now, long startTimeMillis, String headerPrefix, String titleText, Iterable<Tuple2<String, PromptLoggerUtil.Status>> statuses, boolean interactive, Attrs infoColor) {
        int maxWidth = consoleWidth - 1;
        int maxHeight = package$.MODULE$.max(1, consoleHeight / 3 - 1);
        String headerSuffix = Util$.MODULE$.renderSecondsSuffix(now - startTimeMillis);
        String header = this.renderHeader(headerPrefix, titleText, headerSuffix, maxWidth);
        List body0 = (List)((IterableOnceOps)((IterableOps)statuses.flatMap((Function1<Tuple2, Option> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                PromptLoggerUtil.Status status = (PromptLoggerUtil.Status)tuple2._2();
                if (status.prev().nonEmpty() && status.next().isEmpty() && status.beginTransitionTime() + (long)MODULE$.statusRemovalHideDelayMillis() < now && status.beginTransitionTime() > now - (long)MODULE$.statusRemovalRemoveDelayMillis()) {
                    return new Some<String>("");
                }
                Option<PromptLoggerUtil.StatusEntry> textOpt = status.beginTransitionTime() + (long)MODULE$.statusRemovalHideDelayMillis() < now ? status.next() : status.prev();
                return textOpt.map((Function1<PromptLoggerUtil.StatusEntry, String> & Serializable)t -> {
                    String seconds = Util$.MODULE$.renderSecondsSuffix(now - t.startTimeMillis());
                    String mainText = MODULE$.splitShorten(new StringBuilder(0).append(t.text()).append(seconds).toString(), maxWidth);
                    String detail = MODULE$.splitShorten(MODULE$.spaceNonEmpty(t.detail()), maxWidth - mainText.length());
                    return new StringBuilder(0).append(mainText).append(infoColor.apply(Str$.MODULE$.implicitApply(detail))).toString();
                });
            }
            throw new MatchError(tuple2);
        })).filter((Function1<String, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(PromptLoggerUtil$.$anonfun$renderPrompt$3(interactive, x$2)))).toList().sortBy((Function1<String, Object> & Serializable)x -> BoxesRunTime.boxToBoolean(x.isEmpty()), (Ordering)Ordering$Boolean$.MODULE$);
        int nonEmptyBodyCount = body0.count((Function1<String, Object> & Serializable)x$3 -> BoxesRunTime.boxToBoolean(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$3))));
        Object body = nonEmptyBodyCount <= maxHeight ? body0.take(maxHeight) : (List)((AbstractIterable)body0.take(maxHeight - 1)).$plus$plus(new $colon$colon<Nothing$>((Nothing$)((Object)new StringBuilder(21).append("... and ").append(nonEmptyBodyCount - maxHeight + 1).append(" more threads").toString()), Nil$.MODULE$));
        String string = header;
        return ((List)body).$colon$colon(string);
    }

    public String renderPromptWrapped(Seq<String> currentPromptLines, boolean interactive, boolean ending) {
        if (!interactive) {
            return new StringBuilder(1).append(currentPromptLines.mkString("\n")).append("\n").toString();
        }
        String backUp = ending ? "\n" : new StringBuilder(0).append(AnsiNav$.MODULE$.left(9999)).append(AnsiNav$.MODULE$.up(currentPromptLines.length() - 1)).toString();
        return new StringBuilder(0).append(((IterableOnceOps)currentPromptLines.map((Function1<String, String> & Serializable)x$4 -> new StringBuilder(0).append((String)x$4).append(AnsiNav$.MODULE$.clearLine(0)).toString())).mkString("\n")).append(AnsiNav$.MODULE$.clearScreen(0)).append(backUp).toString();
    }

    public String renderHeader(String headerPrefix0, String titleText0, String headerSuffix0, int maxWidth) {
        String headerPrefixStr = headerPrefix0.isEmpty() ? "" : new StringBuilder(1).append(headerPrefix0).append(" ").toString();
        String headerSuffixStr = headerSuffix0;
        String titleText = new StringBuilder(2).append(" ").append(titleText0).append(" ").toString();
        int dividerMaxLength = 30;
        int dividerMinLength = 15;
        int maxTitleLength = maxWidth - headerPrefixStr.length() - headerSuffixStr.length() - dividerMinLength * 2;
        String shortenedTitle = this.splitShorten(titleText, maxTitleLength);
        String rightDiv = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("="), package$.MODULE$.min(dividerMaxLength, (maxWidth - headerPrefixStr.length() - headerSuffixStr.length() - shortenedTitle.length()) / 2));
        String leftDiv = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("="), package$.MODULE$.min(dividerMaxLength, maxWidth - headerPrefixStr.length() - headerSuffixStr.length() - shortenedTitle.length() - rightDiv.length()));
        String headerString = new StringBuilder(0).append(headerPrefixStr).append(leftDiv).append(shortenedTitle).append(rightDiv).append(headerSuffixStr).toString();
        return this.splitShorten(headerString, maxWidth);
    }

    public String splitShorten(String s, int maxLength) {
        if (s.length() <= maxLength) {
            return s;
        }
        String ellipses = "...";
        int nonEllipsesLength = maxLength - ellipses.length();
        int halfWidth = nonEllipsesLength / 2;
        int halfWidth2 = nonEllipsesLength - halfWidth;
        return new StringBuilder(0).append(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(s), halfWidth2)).append(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(ellipses), maxLength)).append(StringOps$.MODULE$.takeRight$extension(Predef$.MODULE$.augmentString(s), halfWidth)).toString();
    }

    public int lastIndexOfNewline(byte[] b, int off, int len) {
        int index = off + len - 1;
        while (index >= off) {
            if (b[index] == 10) {
                return index;
            }
            --index;
        }
        return -1;
    }

    public Ordering<Seq<String>> seqStringOrdering() {
        return seqStringOrdering;
    }

    public static final /* synthetic */ boolean $anonfun$renderPrompt$3(boolean interactive$1, String x$2) {
        return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2)) || interactive$1;
    }

    private PromptLoggerUtil$() {
    }
}

