/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.metadata.filter;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.tika.config.Field;
import org.apache.tika.config.Initializable;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.filter.MetadataFilter;
import org.apache.tika.utils.StringUtils;

public class CaptureGroupMetadataFilter
extends MetadataFilter
implements Initializable {
    private String regexString;
    private Pattern regex;
    private String sourceField;
    private String targetField;

    @Override
    public void filter(Metadata metadata) throws TikaException {
        String val = metadata.get(this.sourceField);
        if (StringUtils.isBlank(val)) {
            return;
        }
        Matcher m = this.regex.matcher(val);
        if (m.find()) {
            metadata.set(this.targetField, m.group(1));
        }
    }

    @Field
    public void setRegex(String regex) {
        this.regexString = regex;
    }

    @Field
    public void setSourceField(String sourceField) {
        this.sourceField = sourceField;
    }

    @Field
    public void setTargetField(String targetField) {
        this.targetField = targetField;
    }

    public String getRegex() {
        return this.regexString;
    }

    public String getSourceField() {
        return this.sourceField;
    }

    public String getTargetField() {
        return this.targetField;
    }

    @Override
    public void initialize(Map<String, Param> params) throws TikaConfigException {
        try {
            this.regex = Pattern.compile(this.regexString);
        }
        catch (PatternSyntaxException e) {
            throw new TikaConfigException("Couldn't parse regex", e);
        }
    }

    @Override
    public void checkInitialization(InitializableProblemHandler problemHandler) throws TikaConfigException {
        if (StringUtils.isBlank(this.sourceField)) {
            throw new TikaConfigException("Must specify a 'sourceField'");
        }
        if (StringUtils.isBlank(this.targetField)) {
            throw new TikaConfigException("Must specify a 'targetField'");
        }
    }
}

