/*
 * Copyright (c) 2019, Alliance for Open Media. All rights reserved
 *
 * This source code is subject to the terms of the BSD 2 Clause License and
 * the Alliance for Open Media Patent License 1.0. If the BSD 2 Clause License
 * was not distributed with this source code in the LICENSE file, you can
 * obtain it at www.aomedia.org/license/software. If the Alliance for Open
 * Media Patent License 1.0 was not distributed with this source code in the
 * PATENTS file, you can obtain it at www.aomedia.org/license/patent.
 */

#ifndef AOM_AV1_ENCODER_MODE_PRUNE_MODEL_WEIGHTS_H_
#define AOM_AV1_ENCODER_MODE_PRUNE_MODEL_WEIGHTS_H_

#ifdef __cplusplus
extern "C" {
#endif

#define NUM_HIDDEN_LAYERS_12 1
#define NUM_FEATURES_12 6
#define NUM_LAYER_0_UNITS_12 24
#define NUM_LOGITS_12 2

static const float av1_intrap_hiddenlayer_0_kernel_12[] = {
  7.28372f,       -1.3333898f,    -1.3180022f,   -0.007156151f, -0.40799126f,
  -0.57538104f,   -31.81647f,     6.7057495f,    6.351472f,     -0.029544508f,
  0.026801195f,   1.12863f,       -0.70769817f,  -0.24183524f,  0.0649113f,
  -0.7189517f,    0.21791299f,    0.12840256f,   -0.56424767f,  0.16924907f,
  0.4605501f,     -0.170895f,     -0.60358995f,  -0.15383226f,  -4.0523643f,
  0.6961917f,     1.3100256f,     -0.4189354f,   0.37264112f,   -0.14555685f,
  10.628014f,     8.184437f,      8.941916f,     -0.011731001f, -0.45127156f,
  0.42704004f,    36.84277f,      8.988796f,     8.844238f,     0.00030091056f,
  -0.022038324f,  1.3566176f,     -8.863219f,    -0.84811693f,  -1.0908632f,
  0.00023130262f, -1.0698471f,    -6.755927f,    7.1711984f,    4.7216063f,
  3.5099216f,     -0.6650184f,    0.5935173f,    -0.6696286f,   11.8595295f,
  0.3001874f,     0.29822728f,    0.04319222f,   -1.203178f,    1.1210147f,
  0.035045594f,   -0.20559944f,   -0.015388541f, -0.7857941f,   -0.94100875f,
  -0.1278549f,    -19.22603f,     7.9466896f,    6.5048656f,    -0.22195444f,
  0.19061874f,    1.3927288f,     -8.896529f,    -0.48146892f,  -1.6098932f,
  -0.0030235797f, -0.6533787f,    -2.1333003f,   -22.256454f,   -4.934058f,
  -4.4707212f,    -0.015831878f,  -0.4243649f,   -2.776269f,    -0.23762038f,
  0.1820098f,     -0.51865315f,   -1.1893421f,   0.34969202f,   0.10636194f,
  14.545696f,     1.3849198f,     2.6815193f,    -0.5145498f,   0.45948258f,
  -0.8842355f,    -0.9111363f,    -0.39652422f,  0.077266276f,  -0.68084997f,
  0.4593515f,     -0.28872707f,   -6.936231f,    1.12253f,      1.7616503f,
  -0.014069137f,  -0.0052156276f, -4.5095444f,   6.2076726f,    -0.058755957f,
  -0.4675936f,    -0.13039507f,   0.12094394f,   -0.07285393f,  68.26125f,
  7.4893136f,     8.770954f,      0.020274093f,  -0.027877754f, 1.6579602f,
  -0.1825479f,    0.34832543f,    0.07472531f,   -0.44812247f,  -1.0941806f,
  -0.16749863f,   1.1394324f,     0.47983396f,   -0.99983627f,  -0.00064249727f,
  -1.3345739f,    -0.057157427f,  -18.14875f,    16.506035f,    15.539248f,
  0.013191509f,   -0.021674965f,  -25.006235f,   0.51220596f,   0.7334426f,
  0.81836903f,    -1.0443225f,    0.4459505f,    -1.2045046f
};

static const float av1_intrap_hiddenlayer_0_bias_12[] = {
  -4.154915f,   14.33833f,   0.0f,       0.0f,         2.0440118f, 12.40922f,
  -16.77514f,   0.5879813f,  3.2305415f, 0.8303539f,   0.0f,       14.488708f,
  2.94393f,     1.874383f,   0.0f,       -0.53140444f, 0.0f,       1.8456234f,
  -0.55427986f, -19.856262f, 0.0f,       0.17281002f,  48.31631f,  0.0f
};

static const float av1_intrap_logits_kernel_12[] = {
  0.26843873f,   -0.09576241f,  0.34427166f,  0.09914787f,  -0.10275399f,
  0.02999484f,   -0.1467772f,   0.11594324f,  0.29200763f,  0.0067976206f,
  0.050393578f,  -0.018694371f, 0.3333476f,   0.2127221f,   0.35128218f,
  0.19968672f,   0.08099991f,   0.084850654f, -0.16045967f, 0.30286232f,
  0.6164765f,    -0.27140254f,  0.08210814f,  0.34852806f,  0.25028184f,
  -0.12188078f,  0.16310331f,   0.31253803f,  -0.10792341f, 0.065858394f,
  -0.1349708f,   0.08948815f,   0.31905392f,  0.03680656f,  -0.05040944f,
  -0.051539157f, 0.3211852f,    0.2137136f,   0.45037416f,  0.22748767f,
  -0.10978614f,  0.06475646f,   -0.16954158f, 0.32831904f,  0.16479677f,
  -0.30020145f,  0.066221856f,  0.37213042f
};

static const float av1_intrap_logits_bias_12[] = { 0.95783f, -0.95823103f };

static const NN_CONFIG av1_intrap_nn_config = {
  NUM_FEATURES_12,
  NUM_LOGITS_12,
  NUM_HIDDEN_LAYERS_12,
  {
      NUM_LAYER_0_UNITS_12,
  },
  {
      av1_intrap_hiddenlayer_0_kernel_12,
      av1_intrap_logits_kernel_12,
  },
  {
      av1_intrap_hiddenlayer_0_bias_12,
      av1_intrap_logits_bias_12,
  },
};

#undef NUM_HIDDEN_LAYERS_12
#undef NUM_FEATURES_12
#undef NUM_LAYER_0_UNITS_12
#undef NUM_LOGITS_12

#define NUM_HIDDEN_LAYERS_15 1
#define NUM_FEATURES_15 6
#define NUM_LAYER_0_UNITS_15 24
#define NUM_LOGITS_15 2

static const float av1_intraph_hiddenlayer_0_kernel_15[] = {
  -0.77480125f,   0.3219551f,    -0.015702145f,   -0.5310235f,   0.5254026f,
  -1.1522819f,    2.682016f,     0.08001052f,     -0.2539285f,   0.04711023f,
  -0.81296307f,   0.2675382f,    0.1952474f,      -0.0664705f,   1.2989824f,
  -0.3150117f,    -0.8022715f,   0.045423955f,    -27.584324f,   -2.5608704f,
  -3.2280366f,    0.05272543f,   -0.47141576f,    -0.07644298f,  -53.77942f,
  -22.393923f,    -23.027853f,   -0.00015186476f, -0.010696465f, 2.7064638f,
  -22.776028f,    11.514891f,    11.138167f,      -0.001243723f, -0.4802433f,
  -8.758646f,     0.26398206f,   -0.23485385f,    0.27586034f,   -0.004954741f,
  -0.4935232f,    -0.017607696f, 69.56049f,       -1.1756641f,   -0.052366666f,
  -0.38052833f,   0.32474658f,   0.04634263f,     0.8583235f,    -0.528438f,
  -0.7868907f,    -0.4757781f,   0.4620985f,      -0.70621157f,  231.40195f,
  6.805205f,      9.420295f,     0.02585775f,     -0.03480937f,  1.3577378f,
  0.1758226f,     15.056758f,    14.437874f,      -0.1305005f,   0.115103304f,
  0.21297209f,    55.821743f,    -6.611156f,      -6.8552365f,   -0.011928095f,
  -0.2042175f,    1.2557873f,    -1.0722278f,     -0.2683614f,   0.48318478f,
  -0.73739994f,   0.54055226f,   -0.03224738f,    -0.06767959f,  -0.21015017f,
  0.29171246f,    -0.6937296f,   -1.2342545f,     -0.41278538f,  -37.9365f,
  17.68424f,      16.263042f,    -0.074828684f,   0.06607806f,   -0.16763286f,
  13.594707f,     0.6152676f,    -0.4371223f,     -0.8365592f,   0.8273623f,
  -1.2126317f,    0.1216157f,    -1.3002136f,     -0.18856938f,  -0.2589358f,
  -0.76897144f,   0.21777137f,   -122.25033f,     -0.23490006f,  -3.1238277f,
  -0.13916978f,   0.08576391f,   -1.7391548f,     -116.24812f,   14.906071f,
  13.468357f,     0.02332889f,   -0.034617376f,   -18.506111f,   0.7500542f,
  -1.1882535f,    0.40848416f,   -0.28434393f,    -0.71471655f,  -0.29188696f,
  -0.46588746f,   -0.17324813f,  -0.62460244f,    -1.1801276f,   0.28993344f,
  -0.22072886f,   129.2688f,     -0.33782578f,    -0.34836572f,  -0.034112718f,
  -0.023666814f,  -0.5865087f,   -33.484146f,     1.1431375f,    0.56056374f,
  -0.0049730353f, -0.24347587f,  -1.3003352f,     0.88973033f,   0.8499571f,
  -0.5678484f,    -0.39009875f,  -0.062105156f,   -0.13965102f
};

static const float av1_intraph_hiddenlayer_0_bias_15[] = {
  0.0f,       -0.2926711f, 0.0f,         -1.0303509f, -27.459345f,  12.412848f,
  0.0f,       -2.5971522f, -0.02733541f, -19.881912f, 14.391992f,   -8.249469f,
  0.0f,       0.0f,        13.676118f,   -0.6472994f, -0.07189449f, 1.1986839f,
  52.479107f, 0.0f,        0.0f,         -3.0187025f, 1.4435643f,   0.0f
};

static const float av1_intraph_logits_kernel_15[] = {
  0.05390722f,   -0.06859513f, 0.036842898f, 0.190772f,    0.13623567f,
  0.09321194f,   0.2314745f,   -0.13958375f, -0.3058229f,  -0.0104543045f,
  0.11336068f,   -0.276115f,   0.00470723f,  -0.49123898f, -0.15988174f,
  0.087681435f,  0.022517204f, 0.073877744f, 0.2968856f,   -0.1401399f,
  -0.38788354f,  -0.26005393f, -0.39564916f, -0.16195515f, 0.2680102f,
  -0.032179773f, -0.35758728f, 0.25819537f,  0.11468631f,  0.13573235f,
  -0.2672175f,   0.016490124f, 0.048118807f, 0.020319486f, 0.07892215f,
  -0.21821865f,  0.08434734f,  0.3129456f,   -0.18215221f, 0.08884877f,
  -0.35621428f,  0.11405768f,  0.27370325f,  0.14956686f,  0.01604587f,
  -0.18334487f,  -0.42385718f, -0.08033409f
};

static const float av1_intraph_logits_bias_15[] = { 0.83619016f, -0.8340626f };

static const NN_CONFIG av1_intrap_hd_nn_config = {
  NUM_FEATURES_15,
  NUM_LOGITS_15,
  NUM_HIDDEN_LAYERS_15,
  {
      NUM_LAYER_0_UNITS_15,
  },
  {
      av1_intraph_hiddenlayer_0_kernel_15,
      av1_intraph_logits_kernel_15,
  },
  {
      av1_intraph_hiddenlayer_0_bias_15,
      av1_intraph_logits_bias_15,
  },
};

#undef NUM_HIDDEN_LAYERS_15
#undef NUM_FEATURES_15
#undef NUM_LAYER_0_UNITS_15
#undef NUM_LOGITS_15

#ifdef __cplusplus
}  // extern "C"
#endif

#endif  // AOM_AV1_ENCODER_MODE_PRUNE_MODEL_WEIGHTS_H_
