# Recreating the module descriptions after a Qt major version change

The source tree contains .rst files containing the module description in
doc/extras (named for example "QtCore.rst"). They are extracted/adapted from
the C++ module descriptions. If there is no module description file, shiboken
will extract the module description from the webxml files generated by qdoc.
This ends up in the build directory under doc/rst/PySide6/<module>/index.rst.
It can be used as a starting point for a module description file. C++
specific information like build instructions should be removed.

The descriptions may link to tutorials which can be added to additionaldocs.lst
for webxml extraction.

# Maintaining additionaldocs.lst

The file is a list of additional documentation files. These are basically Qt
tutorials referenced by the documentation. They will receive some Python
adaption by shiboken/sphinx.

The list can be created by the below script and some hand-editing. It will find
almost all documents. Quite a number of them might be unreferenced, but there
is no good way of filtering for this.

    for F in *.webxml
    do
        echo "$F" | egrep '(-index)|(-module)|(-qmlmodule)\.webxml$' > /dev/null
        if [ $? -ne 0 ]
        then
            if fgrep '<para>' "$F" > /dev/null # Exclude reference only
            then
                egrep "(<class )|(<namespace )" $F > /dev/null || echo $F
            fi
        fi
    done
