/****************************************************************************
**
** Copyright (C) 2023 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt Creator.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
****************************************************************************/

import QtQuick
import QtQuick.Controls
import WelcomeScreen 1.0
import StudioControls 1.0 as StudioControls
import StudioTheme 1.0 as StudioTheme
import projectmodel 1.0
import UiTour

Item {
    id: tourDialog
    anchors.fill: parent
    anchors.topMargin: 100
    anchors.bottomMargin: 20
    anchors.leftMargin: 320
    anchors.rightMargin: 220

    width: 1920
    height: 1080

    signal tourClosed


    function startTour(url)
    {
        print("start: " + Qt.resolvedUrl(url))
        slidePlayer.visible = true
        slidePlayer.slideSource = Qt.resolvedUrl(url)

    }

    Rectangle {
        id: rectangle
        color: "#1c1c1c"
        radius: 12
        anchors.fill: parent

        CustomScrollView {
            id: scrollView
            anchors.fill: parent
            anchors.margins: 22

            GridView {
                id: gridView
                clip: true
                anchors.fill: parent
                rightMargin: -Constants.gridSpacing
                bottomMargin: -Constants.gridSpacing
                boundsBehavior: Flickable.StopAtBounds
                cellWidth: Constants.gridCellSize
                cellHeight: Constants.gridCellSize

                model: TourModel {
                }

                delegate: TourThumbnailDelegate {
                    id: thumbnailDelegate
                    Connections {
                        target: thumbnailDelegate
                        onClicked: {
                            tourDialog.startTour(qmlFileName)
                        }
                    }
                }
            }
        }
    }
    SlidePlayer {
        id: slidePlayer
        anchors.fill: parent
        anchors.leftMargin: -250
        anchors.rightMargin: - 20
        visible: false

    }

    TourDialogButton {
        id: closeButton
        x: 1872
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.rightMargin: 16
        anchors.topMargin: 16

        Connections {
            target: closeButton
            onButtonClicked: {
                slidePlayer.visible = false
                tourDialog.visible = false
                tourDialog.tourClosed()
            }
        }
    }

    TourDialogButton {
        id: resetButton
        y: -9
        anchors.left: slidePlayer.left
        anchors.top: parent.top
        dialogButtonText: StudioTheme.Constants.reload_medium
        anchors.leftMargin: 16
        anchors.topMargin: 16
        visible: slidePlayer.visible
        Connections {
            target: resetButton
            onButtonClicked: {
                slidePlayer.visible = false
                tourDialog.visible = true
            }
        }
    }
}


