

/****************************************************************************
**
** Copyright (C) 2023 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt Creator.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
****************************************************************************/
import QtQuick
import QtQuick.Controls
import WelcomeScreen 1.0
import StudioControls 1.0 as StudioControls
import projectmodel 1.0

Item {
    id: thumbnailDelegate
    width: Constants.thumbnailSize
    height: Constants.thumbnailSize
    state: "normal"
    clip: true
    signal clicked

    property bool complete: thumbnailDelegate.currentSlide === thumbnailDelegate.endSlide

    //needs to be set from the current slide show and user progress
    property int currentSlide: 0
    property int endSlide: 10

    Rectangle {
        id: rectangle
        radius: 12
        border.color: "#00ffffff"
        border.width: 2
        Text {
            id: titleCaption
            x: 10
            y: 5
            color: Constants.currentGlobalText
            font.pixelSize: 18
            text: title
        }

        Text {
            id: subtitleCaption
            x: 10
            y: 30
            color: Constants.currentGlobalText
            text: subtitle
            font.pixelSize: 12
        }

        MouseArea {
            id: mouseArea
            anchors.fill: parent
            hoverEnabled: true
            Connections {
                target: mouseArea
                onClicked: thumbnailDelegate.clicked()
            }
        }

        Image {
            id: ds
            anchors.verticalCenter: parent.verticalCenter
            source: "images/ds.png"
            anchors.horizontalCenter: parent.horizontalCenter
            fillMode: Image.PreserveAspectFit
        }

        // progress for each module needs to be set to and read from the backend somehow.
        MyProgressBar {
            id: progressBar
            y: 213
            height: 11
            visible: false
            anchors.left: parent.left
            anchors.right: parent.right
            anchors.bottom: parent.bottom
            currentSlide: thumbnailDelegate.currentSlide
            endSlide: thumbnailDelegate.endSlide
            anchors.rightMargin: 28
            anchors.leftMargin: 28
            anchors.bottomMargin: 16
        }

        Rectangle {
            id: complete
            visible: true
            color: "#57b9fc"

            radius: 12
            border.color: "#00000000"
            anchors.fill: parent

            Text {
                id: text1
                color: "#ffffff"
                text: qsTrId("Chapter Completed")
                anchors.verticalCenter: parent.verticalCenter
                font.pixelSize: 23
                anchors.horizontalCenter: parent.horizontalCenter
            }

            MyRestartButton {
                id: restart
                anchors.horizontalCenter: parent.horizontalCenter

                Connections {
                    target: restart
                    onRestart: thumbnailDelegate.currentSlide = 0
                }
            }
        }

        //color: "#3c3c3c"
        color: Constants.currentNormalThumbnailBackground
        anchors.fill: parent
    }
    states: [
        State {
            name: "normal"
            when: !mouseArea.containsMouse && !mouseArea.pressed
                  && !thumbnailDelegate.complete

            PropertyChanges {
                target: complete
                visible: false
            }

            PropertyChanges {
                target: progressBar
                visible: false
            }

            PropertyChanges {
                target: mouseArea
                enabled: true
            }
        },
        State {
            name: "Hovered"
            when: mouseArea.containsMouse && !mouseArea.pressed
                  && !thumbnailDelegate.complete

            PropertyChanges {
                target: rectangle
                //color: "#606060"
                color: Constants.currentHoverThumbnailBackground
                border.color: "#ffffff"
            }

            PropertyChanges {
                target: complete
                visible: false
            }

            PropertyChanges {
                target: progressBar
                visible: false
            }

            PropertyChanges {
                target: mouseArea
                enabled: true
            }
        },
        State {
            name: "pressed"
            when: mouseArea.pressed && !thumbnailDelegate.complete
            PropertyChanges {
                target: rectangle
                color: "#606060"
                border.color: "#57b9fc"
            }

            PropertyChanges {
                target: complete
                visible: false
            }

            PropertyChanges {
                target: progressBar
                visible: false
            }

            PropertyChanges {
                target: mouseArea
                enabled: true
            }
        },
        State {
            name: "complete"
            when: thumbnailDelegate.complete

            PropertyChanges {
                target: complete
                opacity: 0.75
                visible: true
            }

            PropertyChanges {
                target: progressBar
                visible: false
            }

            PropertyChanges {
                target: mouseArea
                enabled: false
            }
        }
    ]
}
