/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.devtools.jsdoc.checks;

import com.google.common.base.Preconditions;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AstUtil {
    private static final String PROTOTYPE_SUFFIX = ".prototype";

    static Node parentOfType(Node node, Token token) {
        Node node2 = node.getParent();
        return node2 == null || node2.getToken() != token ? null : node2;
    }

    static Node getFunctionNameNode(Node node) {
        Preconditions.checkState(node.isFunction());
        Node node2 = node.getParent();
        if (node2 != null) {
            switch (node2.getToken()) {
                case NAME: {
                    return node2;
                }
                case STRING_KEY: {
                    return node2;
                }
                case NUMBER: {
                    return node2;
                }
                case ASSIGN: {
                    Token token = node2.getFirstChild().getToken();
                    return token == Token.NAME || token == Token.GETPROP ? node2.getFirstChild() : null;
                }
                case VAR: {
                    return node2.getFirstChild();
                }
            }
            Node node3 = node.getFirstChild();
            return node3.getString().isEmpty() ? null : node3;
        }
        return null;
    }

    static String getTypeNameFromPrototype(String string) {
        return string.substring(0, string.length() - PROTOTYPE_SUFFIX.length());
    }

    static boolean isPrototypeName(String string) {
        return string.endsWith(PROTOTYPE_SUFFIX);
    }

    static Node getAssignedTypeNameNode(Node node) {
        Preconditions.checkState(node.isAssign() || node.isVar());
        Node node2 = node.getFirstChild();
        if (node2.getToken() != Token.GETPROP && node2.getToken() != Token.NAME) {
            return null;
        }
        return node2;
    }

    static List<Node> getArguments(Node node) {
        int n = node.getChildCount();
        if (n == 1) {
            return Collections.emptyList();
        }
        ArrayList<Node> arrayList = new ArrayList<Node>(n - 1);
        for (int i = 1; i < n; ++i) {
            arrayList.add(node.getChildAtIndex(i));
        }
        return arrayList;
    }

    static String getAnnotationTypeString(JSTypeExpression jSTypeExpression) {
        return jSTypeExpression.getRoot().getFirstChild().getString();
    }

    private AstUtil() {
    }
}

