/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.haha.guava.collect;

import com.squareup.haha.guava.collect.ImmutableBiMap;
import com.squareup.haha.guava.collect.ImmutableCollection;
import com.squareup.haha.guava.collect.ImmutableMapKeySet;
import com.squareup.haha.guava.collect.ImmutableMapValues;
import com.squareup.haha.guava.collect.ImmutableSet;
import com.squareup.haha.guava.collect.Maps;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class ImmutableMap<K, V>
implements Serializable,
Map<K, V> {
    private transient ImmutableSet<Map.Entry<K, V>> entrySet;
    private transient ImmutableSet<K> keySet;
    private transient ImmutableCollection<V> values;

    public static <K, V> ImmutableMap<K, V> of() {
        return ImmutableBiMap.of();
    }

    ImmutableMap() {
    }

    @Override
    @Deprecated
    public final V put(K k, V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void putAll(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        return ((ImmutableCollection)this.values()).contains(value);
    }

    @Override
    public abstract V get(@Nullable Object var1);

    @Override
    public ImmutableSet<Map.Entry<K, V>> entrySet() {
        ImmutableSet<Map.Entry<K, V>> result = this.entrySet;
        if (result == null) {
            this.entrySet = this.createEntrySet();
            return this.entrySet;
        }
        return result;
    }

    abstract ImmutableSet<Map.Entry<K, V>> createEntrySet();

    @Override
    public ImmutableSet<K> keySet() {
        ImmutableSet<K> result = this.keySet;
        if (result == null) {
            ImmutableMap immutableMap = this;
            this.keySet = new ImmutableMapKeySet(immutableMap);
            return this.keySet;
        }
        return result;
    }

    @Override
    public ImmutableCollection<V> values() {
        ImmutableCollection<V> result = this.values;
        if (result == null) {
            this.values = new ImmutableMapValues(this);
            return this.values;
        }
        return result;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        return Maps.equalsImpl(this, object);
    }

    abstract boolean isPartialView();

    @Override
    public int hashCode() {
        return ((ImmutableSet)this.entrySet()).hashCode();
    }

    public String toString() {
        return Maps.toStringImpl(this);
    }
}

