/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.builtin;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ResourceBundle;
import jsynoptic.base.ContextualActionProvider;
import jsynoptic.builtin.Abstract1DShape;
import jsynoptic.builtin.ui.PropertiesPanel2D;
import simtools.data.DataSource;
import simtools.data.DataSourceListener;
import simtools.data.DataSourcePool;
import simtools.data.UnsupportedOperation;
import simtools.diagram.Resizable;
import simtools.shapes.AbstractShape;
import simtools.ui.ColorMapper;
import simtools.ui.JPropertiesPanel;
import simtools.ui.ResourceFinder;

public abstract class Abstract2DShape
extends Abstract1DShape
implements Resizable,
DataSourceListener,
ContextualActionProvider {
    static final long serialVersionUID = -251037943033567016L;
    public static ResourceBundle resources = ResourceFinder.get(class$jsynoptic$builtin$Abstract2DShape == null ? (class$jsynoptic$builtin$Abstract2DShape = Abstract2DShape.class$("jsynoptic.builtin.Abstract2DShape")) : class$jsynoptic$builtin$Abstract2DShape);
    protected Color fillColor = null;
    protected transient Color fillDynamicColor = null;
    protected ColorMapper fillMapper;
    protected transient DataSource fillMapperSource;
    protected transient long fillMapperIndex;
    protected transient boolean dirtyFillColor = false;
    static /* synthetic */ Class class$jsynoptic$builtin$Abstract2DShape;

    public Abstract2DShape(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    protected AbstractShape cloneShape() {
        try {
            Abstract2DShape abstract2DShape = (Abstract2DShape)super.clone();
            if (abstract2DShape.fillMapperSource != null) {
                abstract2DShape.fillMapperSource.addListener(abstract2DShape);
                abstract2DShape.fillMapperSource.addEndNotificationListener(abstract2DShape);
            }
            return abstract2DShape;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void draw(Graphics2D graphics2D) {
        Color color;
        Color color2 = graphics2D.getColor();
        Color color3 = graphics2D.getBackground();
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, AbstractShape.ANTI_ALIASING ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        this.drawHook(graphics2D, false);
        this.fillHook(graphics2D);
        Color color4 = color = this.drawDynamicColor != null ? this.drawDynamicColor : this.drawColor;
        if (color != null) {
            graphics2D.setColor(color);
            Shape shape = this.getDelegateShape();
            graphics2D.draw(shape);
        }
        this.drawHook(graphics2D, true);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        graphics2D.setBackground(color3);
        graphics2D.setColor(color2);
    }

    protected void fillHook(Graphics2D graphics2D) {
        Color color;
        Color color2 = color = this.fillDynamicColor != null ? this.fillDynamicColor : this.fillColor;
        if (color != null) {
            graphics2D.setColor(color);
            Shape shape = this.getDelegateShape();
            graphics2D.fill(shape);
        }
    }

    public JPropertiesPanel createPanel() {
        return new PropertiesPanel2D();
    }

    public void notificationEnd(Object object) {
        if (this.dirtyFillColor) {
            this.dirtyFillColor = false;
            Color color = null;
            if (this.fillMapper != null) {
                color = (Color)this.fillMapper.getPaint(this.fillMapperSource, this.fillMapperIndex);
            }
            this.dirtyFillColor = color == null ? this.fillDynamicColor != null : !color.equals(this.fillDynamicColor);
            this.fillDynamicColor = color;
            this.dirty |= this.dirtyFillColor;
            this.dirtyFillColor = false;
        }
        super.notificationEnd(object);
    }

    public void DataSourceIndexRangeChanged(DataSource dataSource, long l, long l2) {
        if (dataSource.equals(this.fillMapperSource)) {
            this.fillMapperIndex = l2;
            this.dirtyFillColor = true;
        }
        super.DataSourceIndexRangeChanged(dataSource, l, l2);
    }

    public void DataSourceValueChanged(DataSource dataSource, long l, long l2) {
        if (dataSource.equals(this.fillMapperSource) && this.fillMapperIndex >= l && this.fillMapperIndex <= l2) {
            this.dirtyFillColor = true;
        }
        super.DataSourceValueChanged(dataSource, l, l2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        DataSourcePool.global.writeDataSource(objectOutputStream, this.fillMapperSource);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.fillMapperSource = DataSourcePool.global.readDataSource(objectInputStream);
        if (this.fillMapperSource != null) {
            try {
                this.fillMapperSource.addListener(this);
                this.fillMapperSource.addEndNotificationListener(this);
                this.fillMapperIndex = this.fillMapperSource.getLastIndex();
            }
            catch (UnsupportedOperation unsupportedOperation) {
                this.fillMapperIndex = 0L;
            }
        }
        this.fillDynamicColor = this.fillMapper != null ? (Color)this.fillMapper.getPaint(this.fillMapperSource, this.fillMapperIndex) : null;
    }

    public void setPropertyValue(String string, Object object) {
        super.setPropertyValue(string, object);
        if (string.equalsIgnoreCase("FILL_COLOR")) {
            this.fillColor = object instanceof Color ? (Color)object : null;
        } else if (string.equalsIgnoreCase("FILL_MAPPER")) {
            this.fillMapper = object instanceof ColorMapper ? (ColorMapper)object : null;
        } else if (string.equalsIgnoreCase("FILL_MAPPER_SOURCE")) {
            if (this.fillMapperSource != null) {
                this.fillMapperSource.removeListener(this);
                this.fillMapperSource.removeEndNotificationListener(this);
            }
            if (object instanceof DataSource) {
                this.fillMapperSource = (DataSource)object;
                try {
                    this.fillMapperIndex = this.fillMapperSource.getLastIndex();
                }
                catch (UnsupportedOperation unsupportedOperation) {
                    this.fillMapperIndex = 0L;
                }
                this.fillMapperSource.addListener(this);
                this.fillMapperSource.addEndNotificationListener(this);
            } else {
                this.fillMapperSource = null;
            }
            this.fillDynamicColor = null;
        }
    }

    public Object getPropertyValue(String string) {
        Object object = super.getPropertyValue(string);
        if (string.equalsIgnoreCase("FILL_COLOR")) {
            object = this.fillColor;
        } else if (string.equalsIgnoreCase("FILL_MAPPER")) {
            object = this.fillMapper;
        } else if (string.equalsIgnoreCase("FILL_MAPPER_SOURCE")) {
            object = this.fillMapperSource;
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

