/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.builtin;

import java.awt.Polygon;
import java.awt.Shape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import jsynoptic.builtin.Abstract2DShape;
import jsynoptic.builtin.LinesShape;
import jsynoptic.builtin.ui.PolygonPropertiesPanel;
import jsynoptic.ui.JSynoptic;
import simtools.shapes.AbstractShape;
import simtools.ui.JPropertiesPanel;
import simtools.ui.ResourceFinder;

public class PolygonShape
extends Abstract2DShape {
    static final long serialVersionUID = 6306591085331108840L;
    public static ResourceBundle resources = ResourceFinder.get(class$jsynoptic$builtin$PolygonShape == null ? (class$jsynoptic$builtin$PolygonShape = PolygonShape.class$("jsynoptic.builtin.PolygonShape")) : class$jsynoptic$builtin$PolygonShape);
    protected transient Polygon polygon;
    protected double[] x;
    protected double[] y;
    protected boolean regular;
    static /* synthetic */ Class class$jsynoptic$builtin$PolygonShape;

    PolygonShape(int n, int n2, int n3, int n4, double[] dArray, double[] dArray2, boolean bl, boolean bl2, double d) {
        super(n, n2, n3, n4);
        this.allowResize = bl;
        this.fixedRatio = bl2;
        this.ratio = d;
        this.x = dArray;
        this.y = dArray2;
        this.regular = false;
        this.updatePolygon();
    }

    public PolygonShape(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.setRegular(7);
        this.allowResize = true;
        this.fixedRatio = true;
        this.ratio = (double)this._w / (double)this._h;
    }

    protected Shape getDelegateShape() {
        return this.polygon;
    }

    public void setRegular(int n) {
        this.x = new double[n];
        this.y = new double[n];
        for (int i = 0; i < n; ++i) {
            this.x[i] = Math.cos(Math.PI * 2 * (double)i / (double)n);
            this.y[i] = Math.sin(Math.PI * 2 * (double)i / (double)n);
        }
        this.regular = true;
        this.updatePolygon();
    }

    protected void updatePolygon() {
        int n = Math.min(this.x.length, this.y.length);
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this._ox + this._x + (int)Math.round((this.x[i] + 1.0) * (double)(this._w - 1) / 2.0);
            nArray2[i] = this._oy + this._y - 1 - (int)Math.round((this.y[i] + 1.0) * (double)(this._h - 1) / 2.0);
        }
        this.polygon = new Polygon(nArray, nArray2, n);
    }

    public void translate(int n, int n2) {
        super.translate(n, n2);
        this.polygon.translate(n, n2);
    }

    public void setAnchor(int n, int n2) {
        this.polygon.translate(n - this._ox, n2 - this._oy);
        super.setAnchor(n, n2);
    }

    public void resize(int n, int n2) {
        super.resize(n, n2);
        this.updatePolygon();
    }

    public JPropertiesPanel createPanel() {
        return new PolygonPropertiesPanel();
    }

    public String[] getActions(double d, double d2, Object object, int n) {
        if (n == 3) {
            return null;
        }
        if (n == 4) {
            return null;
        }
        if (n == 5) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getActions(d, d2, object, n);
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        if (n == 1) {
            vector.add(resources.getString("ConvertToLines"));
        }
        return vector.toArray(new String[vector.size()]);
    }

    public boolean doAction(double d, double d2, Object object, String string) {
        if (string.equals(resources.getString("ConvertToLines"))) {
            LinesShape linesShape = new LinesShape(this._ox, this._oy, this._w, this._h, this.x, this.y, this.allowResize, this.fixedRatio, this.ratio);
            JSynoptic.gui.getActiveContainer().remove(this);
            JSynoptic.gui.getActiveContainer().add(linesShape);
            JSynoptic.gui.getActiveContainer().getComponent().getDiagramSelection().unselect();
            JSynoptic.gui.getActiveContainer().getComponent().repaint(this.getBounds());
            return true;
        }
        return super.doAction(d, d2, object, string);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.updatePolygon();
    }

    protected AbstractShape cloneShape() {
        PolygonShape polygonShape = (PolygonShape)super.cloneShape();
        polygonShape.updatePolygon();
        return polygonShape;
    }

    public Object getPropertyValue(String string) {
        Object object = super.getPropertyValue(string);
        if (string.equalsIgnoreCase("IS_REGULAR")) {
            object = new Boolean(this.regular);
        } else if (string.equalsIgnoreCase("ORDER")) {
            object = new Integer(this.x.length < 3 ? 3 : this.x.length);
        } else if (string.equalsIgnoreCase("POINTS")) {
            String string2 = "";
            for (int i = 0; i < this.x.length; ++i) {
                string2 = string2 + (this.polygon.xpoints[i] - this._ox - this._x);
                string2 = string2 + " ";
                string2 = string2 + (this._oy + this._y - 1 - this.polygon.ypoints[i]);
                string2 = string2 + "\n";
            }
            object = new String(string2);
        }
        return object;
    }

    public void setPropertyValue(String string, Object object) {
        int n = this.x.length;
        String string2 = "";
        for (int i = 0; i < this.x.length; ++i) {
            string2 = string2 + (this.polygon.xpoints[i] - this._ox - this._x);
            string2 = string2 + " ";
            string2 = string2 + (this._oy + this._y - 1 - this.polygon.ypoints[i]);
            string2 = string2 + "\n";
        }
        if (string.equalsIgnoreCase("IS_REGULAR")) {
            if (object instanceof Boolean) {
                this.regular = (Boolean)object;
            }
        } else if (string.equalsIgnoreCase("ORDER")) {
            if (object instanceof Integer) {
                n = (Integer)object;
            }
        } else if (string.equalsIgnoreCase("POINTS") && object instanceof String) {
            string2 = (String)object;
        }
        if (this.regular) {
            this.setRegular(n);
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ()[]{}'\"\n\t:;,/");
            boolean bl = true;
            Vector<Object> vector = new Vector<Object>();
            Vector<Object> vector2 = new Vector<Object>();
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (bl) {
                    vector.add(string3);
                } else {
                    vector2.add(string3);
                }
                bl = !bl;
            }
            int n2 = vector2.size();
            if (vector.size() != n2) {
                vector.remove(n2);
            }
            double d = Double.POSITIVE_INFINITY;
            double d2 = Double.NEGATIVE_INFINITY;
            double d3 = Double.POSITIVE_INFINITY;
            double d4 = Double.NEGATIVE_INFINITY;
            int n3 = 0;
            while (n3 < n2) {
                double d5;
                double d6;
                try {
                    d6 = Double.parseDouble((String)vector.get(n3));
                    d5 = Double.parseDouble((String)vector2.get(n3));
                }
                catch (NumberFormatException numberFormatException) {
                    vector.remove(n3);
                    vector2.remove(n3);
                    --n2;
                    continue;
                }
                vector.set(n3, new Double(d6));
                vector2.set(n3, new Double(d5));
                if (d6 < d) {
                    d = d6;
                }
                if (d5 < d3) {
                    d3 = d5;
                }
                if (d6 > d2) {
                    d2 = d6;
                }
                if (d5 > d4) {
                    d4 = d5;
                }
                ++n3;
            }
            double d7 = d2 - d;
            double d8 = d4 - d3;
            if (d7 == 0.0) {
                d7 = MIN_SIZE;
            }
            if (d8 == 0.0) {
                d8 = MIN_SIZE;
            }
            if (this.allowResize) {
                this._w = (int)d7;
                this._h = (int)d8;
                if (this._w < MIN_SIZE) {
                    this._w = MIN_SIZE;
                }
                if (this._h < MIN_SIZE) {
                    this._h = MIN_SIZE;
                }
            }
            this.x = new double[n2];
            this.y = new double[n2];
            for (int i = 0; i < n2; ++i) {
                this.x[i] = ((Double)vector.get(i) - d) * 2.0 / d7 - 1.0;
                this.y[i] = ((Double)vector2.get(i) - d3) * 2.0 / d8 - 1.0;
            }
            this.ratio = (double)this._w / (double)this._h;
            this.updatePolygon();
        }
        super.setPropertyValue(string, object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

