/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.servlet;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.servlet.ChartDeleter;

public class ServletUtilities {
    public static String saveChartAsPNG(JFreeChart jFreeChart, int n, int n2, HttpSession httpSession) throws IOException {
        return ServletUtilities.saveChartAsPNG(jFreeChart, n, n2, null, httpSession);
    }

    public static String saveChartAsPNG(JFreeChart jFreeChart, int n, int n2, ChartRenderingInfo chartRenderingInfo, HttpSession httpSession) throws IOException {
        ServletUtilities.createTempDir();
        File file = File.createTempFile("jfreechart-", ".png", new File(System.getProperty("java.io.tmpdir")));
        ChartUtilities.saveChartAsPNG(file, jFreeChart, n, n2, chartRenderingInfo);
        ServletUtilities.registerChartForDeletion(file, httpSession);
        return file.getName();
    }

    public static String saveChartAsJPEG(JFreeChart jFreeChart, int n, int n2, HttpSession httpSession) throws IOException {
        return ServletUtilities.saveChartAsJPEG(jFreeChart, n, n2, null, httpSession);
    }

    public static String saveChartAsJPEG(JFreeChart jFreeChart, int n, int n2, ChartRenderingInfo chartRenderingInfo, HttpSession httpSession) throws IOException {
        ServletUtilities.createTempDir();
        File file = File.createTempFile("jfreechart-", ".jpeg", new File(System.getProperty("java.io.tmpdir")));
        ChartUtilities.saveChartAsJPEG(file, jFreeChart, n, n2, chartRenderingInfo);
        ServletUtilities.registerChartForDeletion(file, httpSession);
        return file.getName();
    }

    protected static void createTempDir() {
        String string = System.getProperty("java.io.tmpdir");
        if (string == null) {
            throw new RuntimeException("Temporary directory system property (java.io.tmpdir) is null");
        }
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    protected static void registerChartForDeletion(File file, HttpSession httpSession) {
        if (httpSession != null) {
            ChartDeleter chartDeleter = (ChartDeleter)httpSession.getAttribute("JFreeChart_Deleter");
            if (chartDeleter == null) {
                chartDeleter = new ChartDeleter();
                httpSession.setAttribute("JFreeChart_Deleter", (Object)chartDeleter);
            }
            chartDeleter.addChart(file.getName());
        } else {
            System.out.println("Session is null - chart will not be deleted");
        }
    }

    public static void sendTempFile(String string, HttpServletResponse httpServletResponse) throws IOException, FileNotFoundException {
        File file = new File(System.getProperty("java.io.tmpdir"), string);
        ServletUtilities.sendTempFile(file, httpServletResponse);
    }

    public static void sendTempFile(File file, HttpServletResponse httpServletResponse) throws IOException, FileNotFoundException {
        String string = null;
        String string2 = file.getName();
        if (string2.length() > 5) {
            if (string2.substring(string2.length() - 5, string2.length()).equals(".jpeg")) {
                string = "image/jpeg";
            } else if (string2.substring(string2.length() - 4, string2.length()).equals(".png")) {
                string = "image/png";
            }
        }
        ServletUtilities.sendTempFile(file, httpServletResponse, string);
    }

    public static void sendTempFile(File file, HttpServletResponse httpServletResponse, String string) throws IOException, FileNotFoundException {
        BufferedOutputStream bufferedOutputStream;
        BufferedInputStream bufferedInputStream;
        if (file.exists()) {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            if (string != null) {
                httpServletResponse.setHeader("Content-Type", string);
            }
            httpServletResponse.setHeader("Content-Length", String.valueOf(file.length()));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
            httpServletResponse.setHeader("Last-Modified", simpleDateFormat.format(new Date(file.lastModified())));
            bufferedOutputStream = new BufferedOutputStream((OutputStream)httpServletResponse.getOutputStream());
            byte[] byArray = new byte[1024];
            boolean bl = false;
            while (!bl) {
                int n = bufferedInputStream.read(byArray);
                if (n == -1) {
                    bl = true;
                    continue;
                }
                bufferedOutputStream.write(byArray, 0, n);
            }
        } else {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        bufferedOutputStream.flush();
        bufferedInputStream.close();
        bufferedOutputStream.close();
    }

    public static String searchReplace(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n == -1) {
            return string;
        }
        String string4 = "";
        string4 = string4 + string.substring(0, n) + string3;
        if (n + string2.length() < string.length()) {
            string4 = string4 + ServletUtilities.searchReplace(string.substring(n + string2.length()), string2, string3);
        }
        return string4;
    }
}

