/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.plugins.jfreechart;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import jsynoptic.base.ContextualActionProvider;
import jsynoptic.plugins.jfreechart.CategoryClassifier;
import jsynoptic.plugins.jfreechart.ChartShape;
import jsynoptic.plugins.jfreechart.SourceCategoryDataset;
import jsynoptic.ui.JSynoptic;
import jsynoptic.ui.LongAction;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryLabelPosition;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.CategoryItemRenderer;
import org.jfree.chart.ui.ChartPropertyEditPanel;
import org.jfree.data.CategoryDataset;
import org.jfree.text.TextBlockAnchor;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.DataSourceCollection;
import simtools.data.DataSourceListener;
import simtools.data.DataSourcePool;
import simtools.shapes.AbstractShape;
import simtools.ui.ColorMapper;
import simtools.ui.DynamicColorChooser;
import simtools.ui.GenericMapper;
import simtools.ui.MapperListener;
import simtools.ui.ResourceFinder;
import simtools.ui.TextMapper;

public class BarChartShape
extends ChartShape
implements ContextualActionProvider,
DataSourceListener,
MapperListener {
    static final long serialVersionUID = -3848715079146141774L;
    public static ResourceBundle resources = ResourceFinder.get((Class)(class$jsynoptic$plugins$jfreechart$BarChartShape == null ? (class$jsynoptic$plugins$jfreechart$BarChartShape = BarChartShape.class$("jsynoptic.plugins.jfreechart.BarChartShape")) : class$jsynoptic$plugins$jfreechart$BarChartShape));
    protected Vector mappers;
    protected transient Vector mapperSources;
    static /* synthetic */ Class class$jsynoptic$plugins$jfreechart$BarChartShape;

    public BarChartShape(JFreeChart jFreeChart) {
        this(jFreeChart, 0, 0, 400, 300);
    }

    public BarChartShape(JFreeChart jFreeChart, int n, int n2, int n3, int n4) {
        super(jFreeChart, n, n2, n3, n4);
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        ValueAxis valueAxis = categoryPlot.getRangeAxis();
        valueAxis.setAutoRange(true);
        this.mapperSources = new Vector();
        this.mappers = new Vector();
    }

    public String[] getActions(double d, double d2, Object object, int n) {
        if (n == 3) {
            return null;
        }
        if (n == 4) {
            return null;
        }
        if (n == 5) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        vector.add(resources.getString("Properties..."));
        CategoryPlot categoryPlot = this.chart.getCategoryPlot();
        SourceCategoryDataset sourceCategoryDataset = (SourceCategoryDataset)categoryPlot.getDataset();
        if (object instanceof DataSource) {
            vector.add(resources.getString("AddSource"));
        } else if (object instanceof DataSourceCollection) {
            vector.add(resources.getString("SetSources"));
            vector.add(resources.getString("AddSources"));
        }
        return vector.toArray(new String[vector.size()]);
    }

    public boolean doAction(double d, double d2, Object object, String string) {
        int n;
        SourceCategoryDataset sourceCategoryDataset;
        CategoryPlot categoryPlot;
        if (string.equals(resources.getString("Properties..."))) {
            new LongAction(16L, null, this){

                protected void doAction() {
                    int n;
                    ChartPropertyEditPanel chartPropertyEditPanel = new ChartPropertyEditPanel(BarChartShape.this.chart);
                    JTabbedPane jTabbedPane = BarChartShape.this.findTab((Container)chartPropertyEditPanel);
                    PlotPanel plotPanel = null;
                    if (jTabbedPane != null) {
                        plotPanel = new PlotPanel();
                        jTabbedPane.add((Component)plotPanel, 0);
                    }
                    if ((n = JOptionPane.showConfirmDialog(null, chartPropertyEditPanel, resources.getString("ChartProperties"), 2, -1)) == 0) {
                        chartPropertyEditPanel.updateChartProperties(BarChartShape.this.chart);
                        if (plotPanel != null) {
                            plotPanel.updateChartProperties();
                        }
                    }
                    BarChartShape.this.notifyChange();
                }
            }.start();
            return true;
        }
        if (string.equals(resources.getString("AddSource"))) {
            try {
                categoryPlot = this.chart.getCategoryPlot();
                sourceCategoryDataset = (SourceCategoryDataset)categoryPlot.getDataset();
                sourceCategoryDataset.addSource((DataSource)object);
                this.mappers.add(null);
                this.mapperSources.add(null);
                this.notifyChange();
            }
            catch (ClassCastException classCastException) {
                JSynoptic.setStatus((String)resources.getString("ErrorWhileSettingDataSource"));
            }
        }
        if (string.equals(resources.getString("AddSources"))) {
            try {
                categoryPlot = this.chart.getCategoryPlot();
                sourceCategoryDataset = (SourceCategoryDataset)categoryPlot.getDataset();
                sourceCategoryDataset.addDataSourceCollection((DataSourceCollection)object);
                for (n = 0; n < ((DataSourceCollection)object).size(); ++n) {
                    this.mappers.add(null);
                    this.mapperSources.add(null);
                }
                this.notifyChange();
            }
            catch (ClassCastException classCastException) {
                JSynoptic.setStatus((String)resources.getString("ErrorWhileSettingDataSourceCollection"));
            }
        }
        if (string.equals(resources.getString("SetSources"))) {
            try {
                categoryPlot = this.chart.getCategoryPlot();
                sourceCategoryDataset = (SourceCategoryDataset)categoryPlot.getDataset();
                sourceCategoryDataset.setDataSourceCollection((DataSourceCollection)object);
                this.chart.setTitle(sourceCategoryDataset.getName());
                for (n = 0; n < this.mappers.size(); ++n) {
                    ColorMapper colorMapper;
                    DataSource dataSource = (DataSource)this.mapperSources.get(n);
                    if (dataSource != null) {
                        dataSource.removeListener((DataSourceListener)this);
                    }
                    if ((colorMapper = (ColorMapper)this.mappers.get(n)) == null) continue;
                    colorMapper.removeListener((MapperListener)this);
                }
                for (n = 0; n < ((DataSourceCollection)object).size(); ++n) {
                    this.mappers.add(null);
                    this.mapperSources.add(null);
                }
                this.notifyChange();
            }
            catch (ClassCastException classCastException) {
                JSynoptic.setStatus((String)resources.getString("ErrorWhileSettingDataSourceCollection"));
            }
        }
        return true;
    }

    public boolean canDoAction(double d, double d2, Object object, String string, int n) {
        return true;
    }

    public void mappingChanged(GenericMapper genericMapper) {
        this.notifyChange();
    }

    public void checkMapperChange(DataSource dataSource, long l) {
        CategoryPlot categoryPlot = this.chart.getCategoryPlot();
        CategoryItemRenderer categoryItemRenderer = categoryPlot.getRenderer();
        boolean bl = false;
        for (int i = 0; i < this.mapperSources.size(); ++i) {
            Paint paint;
            ColorMapper colorMapper;
            if (!dataSource.equals(this.mapperSources.get(i)) || (colorMapper = (ColorMapper)this.mappers.get(i)) == null) continue;
            Paint paint2 = bl ? null : categoryItemRenderer.getSeriesPaint(i);
            categoryItemRenderer.setSeriesPaint(i, colorMapper.getPaint(dataSource, l));
            if (bl || paint2.equals(paint = categoryItemRenderer.getSeriesPaint(i))) continue;
            bl = true;
        }
        if (bl) {
            this.notifyChange();
        }
    }

    public void DataSourceValueChanged(DataSource dataSource, long l, long l2) {
        this.checkMapperChange(dataSource, l2);
    }

    public void DataSourceIndexRangeChanged(DataSource dataSource, long l, long l2) {
        this.checkMapperChange(dataSource, l2);
    }

    public void DataSourceInfoChanged(DataSource dataSource, DataInfo dataInfo) {
    }

    public void DataSourceValueRangeChanged(DataSource dataSource) {
    }

    public void DataSourceOrderChanged(DataSource dataSource, int n) {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = this.mapperSources.size();
        objectOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            DataSourcePool.global.writeDataSource(objectOutputStream, (DataSource)this.mapperSources.get(i));
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.mapperSources = new Vector();
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            this.mapperSources.add(DataSourcePool.global.readDataSource(objectInputStream));
        }
    }

    protected AbstractShape cloneShape() {
        ChartShape chartShape = (ChartShape)super.cloneShape();
        CategoryPlot categoryPlot = this.chart.getCategoryPlot();
        SourceCategoryDataset sourceCategoryDataset = (SourceCategoryDataset)categoryPlot.getDataset();
        ((CategoryPlot)chartShape.chart.getPlot()).setDataset((CategoryDataset)sourceCategoryDataset.cloneSet());
        return chartShape;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class PlotPanel
    extends JPanel {
        protected JTextField tfTitle;
        protected JComboBox pcbxcurves;
        protected JComboBox cbxmapper;
        protected JButton pcurvecolor;
        protected JButton pcurvedelete;
        protected JButton editCategories;
        protected JButton beditmapper;
        protected JButton bnewmapper;
        protected JButton bdelmapper;
        protected JTextField pcbxeditortf;
        protected boolean peditLocked;
        protected CbxEntry pactiveEntry;
        protected JRadioButton hSeriesOrientation;
        protected JRadioButton vSeriesOrientation;
        protected JRadioButton hLabelOrientation;
        protected JRadioButton vLabelOrientation;
        protected TextMapper mapper;

        public PlotPanel() {
            this.setLayout(new BorderLayout());
            Box box = Box.createVerticalBox();
            this.setName(resources.getString("PlotProperties"));
            CategoryPlot categoryPlot = BarChartShape.this.chart.getCategoryPlot();
            SourceCategoryDataset sourceCategoryDataset = (SourceCategoryDataset)categoryPlot.getDataset();
            Box box2 = Box.createHorizontalBox();
            box2.add(new JLabel(resources.getString("PlotTitle:")));
            this.tfTitle = new JTextField();
            box2.add(this.tfTitle);
            this.tfTitle.setText(BarChartShape.this.chart.getTitle().getText());
            box.add(box2);
            box2 = Box.createVerticalBox();
            box2.setBorder(BorderFactory.createTitledBorder(resources.getString("Series")));
            Box box3 = Box.createHorizontalBox();
            this.pcbxcurves = new JComboBox();
            box3.add(this.pcbxcurves);
            this.pcurvecolor = new JButton("    ");
            box3.add(this.pcurvecolor);
            this.pcurvedelete = new JButton(resources.getString("Delete"));
            box3.add(this.pcurvedelete);
            box2.add(box3);
            box3 = Box.createHorizontalBox();
            box3.add(new JLabel(resources.getString("Orientation")));
            box3.add(Box.createHorizontalGlue());
            this.hSeriesOrientation = new JRadioButton(resources.getString("Horizontal"));
            box3.add(this.hSeriesOrientation);
            this.vSeriesOrientation = new JRadioButton(resources.getString("Vertical"));
            box3.add(this.vSeriesOrientation);
            this.hSeriesOrientation.setSelected(categoryPlot.getOrientation() == PlotOrientation.HORIZONTAL);
            this.vSeriesOrientation.setSelected(categoryPlot.getOrientation() == PlotOrientation.VERTICAL);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.hSeriesOrientation);
            buttonGroup.add(this.vSeriesOrientation);
            box2.add(box3);
            box.add(box2);
            this.pcbxcurves.setEditable(true);
            Color color = this.pcurvecolor.getBackground();
            this.pcurvecolor.setFocusPainted(false);
            CategoryItemRenderer categoryItemRenderer = categoryPlot.getRenderer();
            int n = sourceCategoryDataset.getRowCount();
            for (int i = 0; i < n; ++i) {
                DataSource dataSource = (DataSource)BarChartShape.this.mapperSources.get(i);
                if (dataSource == null) {
                    dataSource = sourceCategoryDataset.getSource(i);
                }
                this.pcbxcurves.addItem(new CbxEntry(i, sourceCategoryDataset.getName(i), (Color)categoryItemRenderer.getSeriesPaint(i), dataSource, (ColorMapper)BarChartShape.this.mappers.get(i)));
            }
            this.pcbxeditortf = (JTextField)this.pcbxcurves.getEditor().getEditorComponent();
            this.pupdateForEntry(this.pcbxcurves.getSelectedItem());
            this.pcbxcurves.addPopupMenuListener(new PopupMenuListener(this){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    this.this$1.peditLocked = true;
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    this.this$1.peditLocked = false;
                }

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    this.this$1.peditLocked = false;
                }
            });
            this.pcbxcurves.addItemListener(new ItemListener(this){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 2) {
                        this.this$1.pactiveEntry = null;
                    } else {
                        this.this$1.pupdateForEntry(itemEvent.getItem());
                    }
                }
            });
            this.pcbxeditortf.getDocument().addDocumentListener(new DocumentListener(this){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.updateName();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.updateName();
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.updateName();
                }

                public void updateName() {
                    if (this.this$1.peditLocked || this.this$1.pactiveEntry == null) {
                        return;
                    }
                    this.this$1.pactiveEntry.name = this.this$1.pcbxeditortf.getText();
                }
            });
            this.pcurvecolor.addActionListener(new ActionListener(this){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.this$1.pactiveEntry == null) {
                        return;
                    }
                    Color color = DynamicColorChooser.showDialog(null, (String)resources.getString("ChooseAColor"), null, (Color)this.this$1.pactiveEntry.color, (DataSource)this.this$1.pactiveEntry.source, (ColorMapper)this.this$1.pactiveEntry.mapper);
                    if (color == null) {
                        return;
                    }
                    this.this$1.pactiveEntry.color = color;
                    this.this$1.pactiveEntry.source = DynamicColorChooser.getSource();
                    this.this$1.pactiveEntry.mapper = DynamicColorChooser.getMapper();
                    this.this$1.pupdateForEntry(this.this$1.pactiveEntry);
                }
            });
            this.pcurvedelete.addActionListener(new ActionListener(this){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.this$1.pactiveEntry == null) {
                        return;
                    }
                    this.this$1.pcbxcurves.removeItem(this.this$1.pactiveEntry);
                }
            });
            box2 = Box.createVerticalBox();
            box2.setBorder(BorderFactory.createTitledBorder(resources.getString("Categories")));
            box3 = Box.createHorizontalBox();
            box3.add(new JLabel(resources.getString("LabelsOrientation")));
            box3.add(Box.createHorizontalGlue());
            this.hLabelOrientation = new JRadioButton(resources.getString("Horizontal"));
            box3.add(this.hLabelOrientation);
            this.vLabelOrientation = new JRadioButton(resources.getString("Vertical"));
            box3.add(this.vLabelOrientation);
            CategoryLabelPosition categoryLabelPosition = this.vSeriesOrientation.isSelected() ? categoryPlot.getDomainAxis().getCategoryLabelPositions().getLabelPosition(RectangleEdge.BOTTOM) : categoryPlot.getDomainAxis().getCategoryLabelPositions().getLabelPosition(RectangleEdge.LEFT);
            boolean bl = categoryLabelPosition.getAngle() != 0.0;
            this.hLabelOrientation.setSelected(!bl);
            this.vLabelOrientation.setSelected(bl);
            buttonGroup = new ButtonGroup();
            buttonGroup.add(this.hLabelOrientation);
            buttonGroup.add(this.vLabelOrientation);
            box2.add(box3);
            this.mapper = sourceCategoryDataset.getClassifier() == null ? null : sourceCategoryDataset.getClassifier().getMapper();
            box3 = Box.createHorizontalBox();
            box3.add(new JLabel(resources.getString("Mapper")));
            box3.add(Box.createHorizontalGlue());
            this.cbxmapper = new JComboBox();
            box3.add(this.cbxmapper);
            this.cbxmapper.addItem(resources.getString("=======NONE======="));
            int n2 = 0;
            if (TextMapper.textMappers != null) {
                for (int i = 0; i < TextMapper.textMappers.size(); ++i) {
                    TextMapper textMapper = (TextMapper)TextMapper.textMappers.get(i);
                    if (textMapper.equals((Object)this.mapper)) {
                        n2 = i + 1;
                    }
                    this.cbxmapper.addItem(textMapper);
                }
            }
            this.cbxmapper.setEditable(false);
            this.cbxmapper.setSelectedIndex(n2);
            box3.add(this.cbxmapper);
            this.beditmapper = new JButton(resources.getString("Edit"));
            box3.add(this.beditmapper);
            this.bnewmapper = new JButton(resources.getString("New"));
            box3.add(this.bnewmapper);
            this.bdelmapper = new JButton(resources.getString("Delete"));
            box3.add(this.bdelmapper);
            if (n2 == 0) {
                this.beditmapper.setEnabled(false);
                this.bdelmapper.setEnabled(false);
            }
            this.cbxmapper.setRenderer(new ListCellRenderer(this){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    String string = object.toString();
                    if (string.length() > 18) {
                        string = string.substring(0, 15) + "...";
                    }
                    return new JLabel(string);
                }
            });
            this.beditmapper.addActionListener(new ActionListener(this){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.this$1.mapper == null) {
                        return;
                    }
                    this.this$1.mapper.editDialog(null);
                    this.this$1.cbxmapper.repaint();
                }
            });
            this.bnewmapper.addActionListener(new ActionListener(this){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.mapper = TextMapper.createTextMapperDialog(null);
                    if (TextMapper.textMappers == null) {
                        TextMapper.textMappers = new Vector<E>();
                    }
                    TextMapper.textMappers.add(this.this$1.mapper);
                    this.this$1.cbxmapper.addItem(this.this$1.mapper);
                    this.this$1.cbxmapper.setSelectedItem(this.this$1.mapper);
                }
            });
            this.bdelmapper.addActionListener(new ActionListener(this){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.this$1.mapper == null) {
                        return;
                    }
                    if (TextMapper.textMappers != null) {
                        TextMapper.textMappers.remove(this.this$1.mapper);
                    }
                    this.this$1.cbxmapper.removeItem(this.this$1.mapper);
                    this.this$1.cbxmapper.setSelectedIndex(0);
                    this.this$1.mapper = null;
                    this.this$1.bdelmapper.setEnabled(false);
                    this.this$1.beditmapper.setEnabled(false);
                }
            });
            this.cbxmapper.addActionListener(new ActionListener(this){
                private final /* synthetic */ PlotPanel this$1;
                {
                    this.this$1 = plotPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = this.this$1.cbxmapper.getSelectedIndex();
                    if (n == 0) {
                        this.this$1.beditmapper.setEnabled(false);
                        this.this$1.bdelmapper.setEnabled(false);
                        this.this$1.mapper = null;
                    } else {
                        this.this$1.mapper = (TextMapper)this.this$1.cbxmapper.getItemAt(n);
                        this.this$1.beditmapper.setEnabled(true);
                        this.this$1.bdelmapper.setEnabled(true);
                    }
                }
            });
            box2.add(box3);
            box.add(box2);
            this.add((Component)box, "North");
        }

        protected void pupdateForEntry(Object object) {
            this.pactiveEntry = object instanceof CbxEntry ? (CbxEntry)object : null;
            if (this.pactiveEntry == null) {
                return;
            }
            this.pcurvecolor.setBackground(this.pactiveEntry.color);
        }

        protected void updateChartProperties() {
            CategoryItemRenderer categoryItemRenderer;
            CbxEntry cbxEntry;
            int n;
            BarChartShape.this.chart.setTitle(this.tfTitle.getText());
            CategoryPlot categoryPlot = BarChartShape.this.chart.getCategoryPlot();
            SourceCategoryDataset sourceCategoryDataset = (SourceCategoryDataset)categoryPlot.getDataset();
            int n2 = sourceCategoryDataset.getRowCount();
            if (n2 != this.pcbxcurves.getItemCount()) {
                boolean[] blArray = new boolean[n2];
                for (n = 0; n < this.pcbxcurves.getItemCount(); ++n) {
                    blArray[((CbxEntry)this.pcbxcurves.getItemAt((int)n)).datasetIndex] = true;
                }
                for (n = n2 - 1; n >= 0; --n) {
                    if (blArray[n]) continue;
                    cbxEntry = (GenericMapper)BarChartShape.this.mappers.remove(n);
                    if (cbxEntry != null) {
                        cbxEntry.removeListener(BarChartShape.this);
                    }
                    if ((categoryItemRenderer = (DataSource)BarChartShape.this.mapperSources.remove(n)) != null) {
                        categoryItemRenderer.removeListener((DataSourceListener)BarChartShape.this);
                    }
                    sourceCategoryDataset.removeSource(n);
                }
            }
            int n3 = this.pcbxcurves.getItemCount();
            for (n = 0; n < n3; ++n) {
                cbxEntry = (CbxEntry)this.pcbxcurves.getItemAt(n);
                sourceCategoryDataset.setName(n, cbxEntry.name);
                categoryItemRenderer = categoryPlot.getRenderer();
                DataSource dataSource = (DataSource)BarChartShape.this.mapperSources.get(n);
                if (cbxEntry.source == null && dataSource != null) {
                    dataSource.removeListener((DataSourceListener)BarChartShape.this);
                }
                BarChartShape.this.mapperSources.set(n, cbxEntry.source);
                if (cbxEntry.source != null) {
                    cbxEntry.source.addListener((DataSourceListener)BarChartShape.this);
                }
                ColorMapper colorMapper = (ColorMapper)BarChartShape.this.mappers.get(n);
                if (cbxEntry.mapper == null && colorMapper != null) {
                    colorMapper.removeListener((MapperListener)BarChartShape.this);
                }
                BarChartShape.this.mappers.set(n, cbxEntry.mapper);
                if (cbxEntry.mapper != null) {
                    cbxEntry.mapper.addListener((MapperListener)BarChartShape.this);
                }
                if (cbxEntry.mapper != null && cbxEntry.source != null) {
                    cbxEntry.mapper.setDefaultPaint((Paint)cbxEntry.color);
                    categoryItemRenderer.setSeriesPaint(n, cbxEntry.mapper.getPaint(cbxEntry.source));
                    continue;
                }
                categoryItemRenderer.setSeriesPaint(n, (Paint)cbxEntry.color);
            }
            categoryPlot.setOrientation(this.hSeriesOrientation.isSelected() ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL);
            CategoryLabelPosition categoryLabelPosition = this.vSeriesOrientation.isSelected() ? categoryPlot.getDomainAxis().getCategoryLabelPositions().getLabelPosition(RectangleEdge.BOTTOM) : categoryPlot.getDomainAxis().getCategoryLabelPositions().getLabelPosition(RectangleEdge.LEFT);
            categoryLabelPosition = new CategoryLabelPosition(categoryLabelPosition.getCategoryAnchor(), this.hSeriesOrientation.isSelected() ? (this.vLabelOrientation.isSelected() ? TextBlockAnchor.BOTTOM_CENTER : TextBlockAnchor.CENTER_RIGHT) : (this.vLabelOrientation.isSelected() ? TextBlockAnchor.CENTER_RIGHT : TextBlockAnchor.TOP_CENTER), this.hSeriesOrientation.isSelected() ? (this.vLabelOrientation.isSelected() ? TextAnchor.BOTTOM_CENTER : TextAnchor.CENTER_RIGHT) : (this.vLabelOrientation.isSelected() ? TextAnchor.CENTER_RIGHT : TextAnchor.TOP_CENTER), this.vLabelOrientation.isSelected() ? -1.5707963267948966 : 0.0);
            if (this.vSeriesOrientation.isSelected()) {
                categoryPlot.getDomainAxis().setCategoryLabelPositions(new CategoryLabelPositions(categoryPlot.getDomainAxis().getCategoryLabelPositions().getLabelPosition(RectangleEdge.TOP), categoryLabelPosition, categoryPlot.getDomainAxis().getCategoryLabelPositions().getLabelPosition(RectangleEdge.LEFT), categoryPlot.getDomainAxis().getCategoryLabelPositions().getLabelPosition(RectangleEdge.RIGHT)));
            } else {
                categoryPlot.getDomainAxis().setCategoryLabelPositions(new CategoryLabelPositions(categoryPlot.getDomainAxis().getCategoryLabelPositions().getLabelPosition(RectangleEdge.TOP), categoryPlot.getDomainAxis().getCategoryLabelPositions().getLabelPosition(RectangleEdge.BOTTOM), categoryLabelPosition, categoryPlot.getDomainAxis().getCategoryLabelPositions().getLabelPosition(RectangleEdge.RIGHT)));
            }
            if (this.mapper == null) {
                return;
            }
            if (sourceCategoryDataset.getClassifier() == null) {
                sourceCategoryDataset.setClassifier(new CategoryClassifier(this.mapper));
            } else {
                sourceCategoryDataset.getClassifier().setMapper(this.mapper);
            }
        }
    }

    protected static class CbxEntry {
        public int datasetIndex;
        public String name;
        public Color color;
        public DataSource source;
        public ColorMapper mapper;

        public CbxEntry(int n, String string, Color color, DataSource dataSource, ColorMapper colorMapper) {
            this.name = string;
            this.datasetIndex = n;
            this.color = color;
            this.source = dataSource;
            this.mapper = colorMapper;
        }

        public String toString() {
            return this.name;
        }
    }
}

