/* $Id: TspAggrSubSession.java,v 1.3 2005/04/15 03:59:45 sgalles Exp $
 * -----------------------------------------------------------------------
 * 
 * TSP Library - core components for a generic Transport Sampling Protocol.
 * 
 * Copyright (c) 2002 Yves DUFRENNE, Stephane GALLES, Eric NOULARD and Robert PAGNOT 
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * -----------------------------------------------------------------------
 * 
 * Project    : TSP
 * SubProject : jTSP
 * Maintainer : tsp@astrium-space.com
 * Component  : Consumer
 * 
 * -----------------------------------------------------------------------
 * 
 * Purpose   : 
 * 
 * -----------------------------------------------------------------------
 */
package tsp.consumer.util.aggregator;

import java.util.Map;

import tsp.core.consumer.simple.TspSimpleSession;
import tsp.core.consumer.simple.TspSimpleSessionImpl;

/**
 * @author steph
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
class TspAggrSubSession {
	private TspSimpleSession session;
	private String namespace;	
	private Map equivIndex;
	
	
	
	
	/**
	 * @param session
	 * @param name
	 */
	public TspAggrSubSession(TspSimpleSession session, String namespace) {
		super();
		this.session = session;
		this.namespace = namespace;		
	}
		
	/**
	 * @return Returns the name.
	 */
	public String getNamespace() {
		return namespace;
	}
	/**
	 * @return Returns the session.
	 */
	public TspSimpleSession getSession() {
		return session;
	}
	
	
	/**
	 * @return Returns the equivIndex.
	 */
	Map getEquivIndex() {
		return equivIndex;
	}
	/**
	 * @param equivIndex The equivIndex to set.
	 */
	void setEquivIndex(Map equivIndex) {
		this.equivIndex = equivIndex;
	}
	
		
}
