/* $Id: AggrSamplingConfig.java,v 1.3 2006/06/04 08:33:45 erk Exp $
 * -----------------------------------------------------------------------
 * 
 * TSP Library - core components for a generic Transport Sampling Protocol.
 * 
 * Copyright (c) 2002 Yves DUFRENNE, Stephane GALLES, Eric NOULARD and Robert PAGNOT 
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * -----------------------------------------------------------------------
 * 
 * Project    : TSP
 * SubProject : jTSP
 * Maintainer : tsp@astrium-space.com
 * Component  : Consumer
 * 
 * -----------------------------------------------------------------------
 * 
 * Purpose   : 
 * 
 * -----------------------------------------------------------------------
 */
package tsp.consumer.util.configuration.decorator;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import tsp.consumer.util.aggregator.NamespaceHelper;
import tsp.consumer.util.aggregator.TspAggrURL;
import tsp.consumer.util.configuration.SpecProvider;
import tsp.consumer.util.configuration.SpecSample;
import tsp.consumer.util.configuration.SpecSamplingConfig;
import tsp.core.common.url.TspMalformedURLException;
import tsp.core.common.url.TspURL;
import tsp.core.common.url.TspURLFactory;
import tsp.core.consumer.TspConsumerException;
import tsp.core.consumer.simple.TspSimpleSampleSymbolInfo;

public class AggrSamplingConfig {
	
	private SpecSamplingConfig config;
	
		public AggrSamplingConfig(SpecSamplingConfig config) {
		super();
		this.config = config;
	}
		
	public TspAggrURL[] getAllAggrURL() throws TspMalformedURLException, TspConsumerException{		
		List providers = config.getAllProviders();
		TspAggrURL[] urls = new TspAggrURL[providers.size()];
		Iterator it = providers.iterator();
		// use a set to ckech that the namespace are not duplicated
		Set set = new HashSet();
		int i = 0;
		while(it.hasNext() ){
			SpecProvider prov =  (SpecProvider)it.next();
			TspURL url = TspURLFactory.createWithDefaultSupport(prov.getUrl());
			urls[i++] = new TspAggrURL(url, prov.getName());
			set.add(prov.getName());
			if(set.size() != i) throw new TspConsumerException("namespace : '" + prov.getName() + "' is duplicated");
		}		
		return urls;		
	}
	
	public RenamedSimpleSampleSymbolInfo[] getAllRenamedSymbols() throws TspConsumerException {
		List samples = config.getAllSamples();
		RenamedSimpleSampleSymbolInfo[] renSamples = new RenamedSimpleSampleSymbolInfo[samples.size()];
		Iterator it = samples.iterator();
		int i = 0;
		//use a set to chech that the rename are not duplicated
		Set set = new HashSet();
		while(it.hasNext() ){
			SpecSample samp =  (SpecSample)it.next();			
			// TODO : manque la phase dans la conf XML
			TspSimpleSampleSymbolInfo si = new TspSimpleSampleSymbolInfo(samp.getName(), samp.getPeriod(), 0);
			// add the namespace in the symbol name
			si = NamespaceHelper.addNamespace(samp.getProvider().getName(), si); 
			// Use renamed symbol name if it exists
			String renamed = samp.getReNamed() != null ? samp.getReNamed() : si.getName();
			renSamples[i++] = new RenamedSimpleSampleSymbolInfo(si, renamed);
			set.add(renamed);
			if(set.size() != i) throw new TspConsumerException("Sample 'renamed' field duplicated: '" + samp.getReNamed() + "'");
		}
		return renSamples;
	}
		
}
