DEBUG_BYTES SET 0

  MAC DEBUG_BRK
    IF DEBUG
DEBUG_BYTES SET DEBUG_BYTES + 1
      brk                         ;
    ENDIF
  ENDM

  MAC NOP_IMM   ; skip 1 byte, 2 cycles
    .byte   $82
  ENDM

  MAC NOP_B     ; skip 1 byte, 3 cycles
    .byte   $04
  ENDM

  MAC NOP_W     ; skip 2 bytes, 4 cycles
    .byte   $0c
  ENDM

  MAC SLEEP
    LIST OFF
    IF {1} = 1
      ECHO "ERROR: SLEEP 1 not allowed !"
      END
    ENDIF
    IF {1} & 1
      LIST ON
      nop $00
      LIST OFF
      REPEAT ({1}-3)/2
        LIST ON
        nop
        LIST OFF
      REPEND
    ELSE
      REPEAT ({1})/2
        LIST ON
        nop
        LIST OFF
      REPEND
    ENDIF
    LIST ON
  ENDM

  MAC NEXT_PASS
    LIST OFF
   IFNCONST PASS
PASS SET 0
   ELSE
PASS SET PASS + 1
    ECHO "Pass:", [PASS]d
   ENDIF
_MAX_TMP SET 0
    LIST ON
  ENDM

  MAC _CHECKPAGE ; internal, do not use directly
   LIST OFF
   IF PASS > 0
    IF >{1} != >{2}
      LIST ON
      ECHO ""
     IF {3} != ""
      ECHO "ERROR: different pages! (", {3}, "=", {2}, ",", {1}, ")"
     ELSE
      ECHO "ERROR: different pages! (", {2}, ",", {1}, ")"
     ENDIF
      ECHO ""
      ERR
    ENDIF
   ENDIF
   LIST ON
  ENDM

  MAC CHECKPAGE_LBL
    LIST OFF
    _CHECKPAGE ., {1}, {2}
  ENDM

  MAC CHECKPAGE
    LIST OFF
    CHECKPAGE_LBL {1}, ""
  ENDM

  MAC CHECKPAGE_DATA_LBL
    LIST OFF
_ADDR SET . - 1 ; hack to convince DASM
    _CHECKPAGE _ADDR, {1}, {2}
  ENDM

  MAC CHECKPAGE_DATA
    LIST OFF
    CHECKPAGE_DATA_LBL {1}, ""
  ENDM

; *** Temporary RAM variables macros ***

  MAC START_TMP
   LIST OFF
; use default variable:
_ARGS SET {0}
   IF _ARGS = ""
_TMP_ORG SET tmpVars
   ELSE
_TMP_ORG SET _ARGS
   ENDIF

_END_TMP SET _TMP_ORG

  LIST ON
    SEG.U   TempVariables
    ORG     _TMP_ORG
  ENDM

  MAC CONT_TMP
    SEG.U   TempVariables
    ORG     _END_TMP
  ENDM

  MAC END_TMP
_END_TMP SET .
    IF . > tmpVars + NUM_TMPS
      ECHO "ERROR: too many tmpVars!", . - tmpVars + NUM_TMPS
      ERR
    ENDIF
    IF (. - tmpVars) > _MAX_TMP
_MAX_TMP SET (. - tmpVars)
      ECHO "_MAX_TMP:", [_MAX_TMP]d
    ENDIF
    SEG     Bank0
  ENDM


  MAC VERSION_STR
    .byte   ((VERSION & $f00) >> 8) + 48
    .byte   "."
    .byte   ((VERSION & $0f0) >> 4) + 48
    .byte   ((VERSION & $00f) >> 0) + 48
  ENDM

;---------------------------------------------------------------
; Free space macros
;---------------------------------------------------------------
ECHO_FREE SET 1     ; 1 = echo free space enabled
FREE_TOTAL SET 0    ; use only once

  MAC _OUT_FREE
FREE_GAP$ SET - .
    {1} {2}, {5}
FREE_GAP$  SET FREE_GAP$  + .
FREE_TOTAL SET FREE_TOTAL + FREE_GAP$
   IF ECHO_FREE && FREE_GAP$ > 0
    ECHO "@", ., ": Gap:", [FREE_GAP$]d, "; Total:", [FREE_TOTAL]d, ";", {3}, {2}, {4}
   ENDIF
  ENDM

  MAC OUT_FREE
    _OUT_FREE {0}, $aa  ; add $ff for ALIGN filler
  ENDM

  MAC ALIGN_FREE_LBL
    LIST OFF
    OUT_FREE ALIGN, {1}, "ALIGN", {2}
    LIST ON
  ENDM

  MAC ALIGN_FREE
    LIST OFF
    ALIGN_FREE_LBL {1}, ""
  ENDM

  MAC COND_ALIGN_FREE_LBL ; space required, alignment, "label"
    LIST OFF
   IF (>(. + {1} - 1)) > (>.)
    ALIGN_FREE_LBL {2}, {3}
   ENDIF
    LIST ON
  ENDM

  MAC COND_ALIGN_FREE ; space required, alignement
    LIST OFF
    COND_ALIGN_FREE_LBL {1}, {2}, ""
  ENDM

  MAC ORG_FREE_LBL
    LIST OFF
    OUT_FREE ORG, {1}, "ORG", {2}
    LIST ON
  ENDM

  MAC ORG_FREE
    LIST OFF
    ORG_FREE_LBL {1}, ""
  ENDM
