/*  TCTINY.C  -  Support macros/lib for building small apps using TurboC 3.
                 VERSION 1.03. 22.4.2025.

 (C) A.Millett 2012-2025. Released as free software under GNU GPL3 license. 
	(See: www.gnu.org/licenses/gpl-3.0.html )

to use, add: #include "tctiny.c"      in your code.

Usage:  TCTINY TC3PATH PROGNAME [TCOPTIONS..]     
ie: tctiny \m\tc3\bin progname

   Make a "tiny" COM prg, using TC3. Needs TURBO-C 3.0, MASM,EXE2BIN.

See TCTINY.TXT for more details,

*/


typedef unsigned char BYTE;  
typedef unsigned int WORD;
#define TRUE  1 
#define FALSE 0

	/* Macro wrappers for in-line asm routines */

#define IO_VIDEOMODE(x) { _AX = (x); asm int 10h;}
#define IO_GETKEY(x) { _DL = 0xff; _AH = 6; asm int 21h; x = (char) _AX; };
#define IO_TIMER ((int) *((int far *) 0x0000046c))
#define IO_TIMER_SECOND 18
/*#define IO_RAND  (io_rand = (io_rand * 14293) + 0x1113)			/* Cheap random func */
#define IO_RANDTIME  (io_rand = ((io_rand^IO_TIMER) * 24251) + 0x5173)		/* Cheap random func */
#define IO_RAND  (io_rand = (io_rand * 24251) + 0x5173)		/* Cheap random func */
#define IO_SRAND(s) {io_rand = s;}
#define IO_PUTS(str) { _DX = (int) (str); _AH = 9; asm int 21h; }
#define IO_WAITKEY(x) do { _DL = 0xff; _AH = 6; asm int 21h; x = (char) _AX; } while ((x)==0);
#define IO_OUTPORT(port,val) { _AL = val; _DX = port; asm out dx,al ; }

