
;	equates.inc - psx equates file

;	basic equates...
false		equ	0
true		equ	-1
kbyte		equ	1024
mbyte		equ	kbyte*1024

;	rom & ram addresses & sizes
external_rom	equ	$1f000000	; external cartridge port (parallel port)
rom			equ	$bfc00000	; psx rom address
ram			equ	$80000000	; psx main ram address
ram_length	equ	2*mbyte		; size of normal psx memory
os_space	equ	64*kbyte	; first 64k given to operating system
user_ram	equ	ram+os_space	; address of first place programs can go	

;	hardware...
hardware        equ     $1f800000	; base address of hardware
scratch		equ	hardware+$0000	; extra fast scratchpad memory
scratch_length	equ	1*kbyte		; size of scratchpad memory

spu_delay	equ	hardware+$1014
dv5_delay	equ	hardware+$1018
com_delay	equ	hardware+$1020

memcard		equ	hardware+$1040	; memory card base address
memcard_data	equ	memcard+$0	; memory card serial data
memcard_status	equ	memcard+$4	; memory card serial status
memcard_ctrl	equ	memcard+$a	; memory card serial control
memcard_baud	equ	memcard+$e	; memory card serial baud rate

serial			equ	hardware+$1050	; serial port base address
serial_data		equ	serial+$0	; serial port data
serial_status	equ	serial+$4	; serial port status
serial_ctrl		equ	serial+$a	; serial port control
serial_baud		equ	serial+$e	; serial port baud rate

ram_size		equ	hardware+$1060	; ram size (or type?), usually contains $b88

;	important interrupt information:
;		bits correspond to both interrupt_reg & interrupt_mask
;			bit 0:vertical blank interrupt
;			bit 4:root 0 interrupt
;			bit 5:root 1 interrupt
;			bit 6:root 2 interrupt
interrupt	equ	hardware+$1070	; interrupt base address
interrupt_reg	equ	interrupt+$0	; interrupt register
interrupt_mask	equ	interrupt+$4	; interrupt mask

dma0		equ	hardware+$1080	; dma 0 - mdec in
dma0_mem	equ	dma0+$0		; dma 0 memory address
dma0_size	equ	dma0+$4		; dma 0 size
dma0_ctrl	equ	dma0+$8		; dma 0 control

dma1		equ	hardware+$1090	; dma 1 - mdec out
dma1_mem	equ	dma1+$0		; dma 1 memory address
dma1_size	equ	dma1+$4		; dma 1 size
dma1_ctrl	equ	dma1+$8		; dma 1 control

dma2		equ	hardware+$10a0	; dma 2- gpu
dma2_mem	equ	dma2+$0		; dma 2 memory address
dma2_size	equ	dma2+$4		; dma 2 size
dma2_ctrl	equ	dma2+$8		; dma 2 control

dma3		equ	hardware+$10b0	; dma 3 - cdrom
dma3_mem	equ	dma3+$0		; dma 3 memory address
dma3_size	equ	dma3+$4		; dma 3 size
dma3_ctrl	equ	dma3+$8		; dma 3 control

;	important spu dma information:
;		pack samples:
;			byte 0:hi nibble=predictor number,lo nibble=shift factor
;			byte 1:flag
;				$02=something to do with repeat!
;				$03=sample end, restart at repeat point
;				$04=set repeat point
;				$06=repeat start
;				$07=sample end
;			bytes 2..15:packed sample data (28 samples at a time?)
;		transfer packed info:
;			set source address with spu_dma_mem
;			set destination/8 with spu_addr
;			size/64 into bits 16..31 of spu_dma_size
;			then set bit 24 of spu_dma_ctrl (cleared after transfer) 
dma4		equ	hardware+$10c0	; dma 4 - spu
dma4_mem	equ	dma4+$0		; dma 4 memory address
dma4_size	equ	dma4+$4		; dma 4 size
dma4_ctrl	equ	dma4+$8		; dma 4 control
spu_dma_mem	equ	dma4_mem
spu_dma_size	equ	dma4_size
spu_dma_ctrl	equ	dma4_ctrl

dma5		equ	hardware+$10d0	; dma 5 - ???
dma5_mem	equ	dma5+$0		; dma 5 memory address
dma5_size	equ	dma5+$4		; dma 5 size
dma5_ctrl	equ	dma5+$8		; dma 5 control

dma6		equ	hardware+$10e0	; dma 6 - memory
dma6_mem	equ	dma6+$0		; dma 6 memory address
dma6_size	equ	dma6+$4		; dma 6 size
dma6_ctrl	equ	dma6+$8		; dma 6 control

dma_pcr		equ	hardware+$10f0	; dma control register
dma_icr		equ	hardware+$10f4	; dma control register

;	important root counter (timer) information:
;		all root counters based on 33.872mhz clock frequency
;		rootX_count=current counting status (read)
;		rootX_mode:
;			bit 0:0=counting, 1=not counting
;			bit 3:0=timer loops?, 1=timer stops
;			bit 4:interrupt enable
;			bit 6:interrupt enable
;			bit 8:???
root0		equ	hardware+$1100	; root counter 0 base address
root0_count	equ	root0+$0	; current count
root0_mode	equ	root0+$4	; mode
root0_target	equ	root0+$8	; target count

root1		equ	hardware+$1110	; root counter 0 base address
root1_count	equ	root1+$0	; current count
root1_mode	equ	root1+$4	; mode
root1_target	equ	root1+$8	; target count

root2		equ	hardware+$1120	; root counter 0 base address
root2_count	equ	root2+$0	; current count
root2_mode	equ	root2+$4	; mode
root2_target	equ	root2+$8	; target count

cdrom		equ	hardware+$1800	; cdrom base address
cdrom_reg0	equ	cdrom+0
cdrom_reg1	equ	cdrom+1
cdrom_reg2	equ	cdrom+2
cdrom_reg3	equ	cdrom+3

gpu0		equ	hardware+$1810	; gpu register 0
gpu1		equ	hardware+$1814	; gpu register 1

mdec0		equ	hardware+$1820	; mdec register 0
mdec1		equ	hardware+$1824	; mdec register 1

spu		equ	hardware+$1c00	; spu base address
spu_voice	equ	spu+$000	; spu voice base address (24 voices of 16 bytes each from here)
;	offsets for the control of each voice
volume_l	equ	$0		; left volume (bit 14=sign, 0..13=volume)
volume_r	equ	$2		; right volume (bit 14=sign, 0..13=volume)
pitch		equ	$4		; pitch control
wave		equ	$6		; wave pattern address (address/8)
fx_adsr		equ	$8		; attack rate (bits 8..15) + delay rate (bits 4..7) + sustain level (bits 0..3)
fx_adsr2	equ	$a		; sustain rate (bits 6..15) + release rate (bits 0..5)
fx_volume	equ	$c		; adsr volume (0-$7fff, usually set to $7fff)
repeat		equ	$e		; current repeat address/8

spu_volume_l	equ	spu+$180	; spu main volume left
spu_volume_r	equ	spu+$182	; spu main volume right
spu_reverb_l	equ	spu+$184	; spu reverb depth left
spu_reverb_r	equ	spu+$186	; spu reverb depth right
spu_start_0	equ	spu+$188	; spu voices 0-15 on
spu_start_1	equ	spu+$18a	; spu voices 16-23 on
spu_stop_0	equ	spu+$18c	; spu voices 0-15 off
spu_stop_1	equ	spu+$18e	; spu voices 16-23 off
spu_fm_mode_0	equ	spu+$190	; spu voices 0-15 fm mode
spu_fm_mode_1	equ	spu+$192	; spu voices 16-23 fm mode
spu_noise_0	equ	spu+$194	; spu voices 0-15 use as noise generator
spu_noise_1	equ	spu+$196	; spu voices 16-23 use as noise generator
spu_reverb_0	equ	spu+$198	; spu voices 0-15 reverb mode
spu_reverb_1	equ	spu+$19a	; spu voices 16-23 reverb mode
spu_active_0	equ	spu+$19c	; spu voices 0-15 read active status
spu_active_1	equ	spu+$19e	; spu voices 15-23 read active status

spu_addr	equ	spu+$1a6	; spu address to transfer to/from

spu_ctrl0	equ	spu+$1aa	; spu control 0 (bit 14=mute, 8..13=noise freq, 7=reverb on, 4..5=??:w non-dma:w dma:r dma) 
spu_ctrl1	equ	spu+$1ac	; spu control 1
spu_status	equ	spu+$1ae	; spu status (bit 10)
spu_cd_volume_l	equ	spu+$1b0	; spu cd main volume left
spu_cd_volume_r	equ	spu+$1b2	; spu cd main volume right
spu_reverb_data	equ	spu+$1c0	; spu reverb configuration data to spu+$1ff
spu_factor_l	equ	spu+$1fc	; ???
spu_factor_r	equ	spu+$1fe	; ???
  
int_2000	equ	hardware+$2030	; ???
dip_switches	equ	hardware+$2040	; dip switches on developement machines?

;	gpu equates...
clut4		equ	0		; tpage	clut equates
clut8		equ	1
direct16	equ	3

trans0		equ	0		; tpage	transparency equates
trans1		equ	1
trans2		equ	2
trans3		equ	3

;	system call equates...



;PSX System Calls
;NOTE: Some syscalls maybe wrong, as i dont have a psx to test them out. But from 
;what i've been exploring, they seem to be what i state. 
;
;1st column - Address to call 
;2nd column - Value of $t1 when calling 
;3rd column - Name of the function 
;
;Arguments whenever needed are passed by $a0,1,2,3 and at $sp+0x10 when more 
;than 4 arguments. 
;
;0x00a0 - 0x0000 - int open(char *name , int mode)
;0x00a0 - 0x0001 - int lseek(int fd , int offset , int whence)
;0x00a0 - 0x0002 - int read(int fd , char *buf , int nbytes)
;0x00a0 - 0x0003 - int write(int fd , char *buf , int nbytes)
;0x00a0 - 0x0004 - close(int fd)
;0x00a0 - 0x0005 - int ioctl(int fd , int cmd , int arg)
;0x00a0 - 0x0006 - exit()
;0x00a0 - 0x0007 - sys_b0_39()
;0x00a0 - 0x0008 - char getc(int fd)
;0x00a0 - 0x0009 - putc(char c , int fd)
;0x00a0 - 0x000a - todigit
;0x00a0 - 0x000b - double atof(char *s)
;0x00a0 - 0x000c - long strtoul(char *s , char **ptr , int base)
;0x00a0 - 0x000d - unsigned long strtol(char *s , char **ptr , int base)
;0x00a0 - 0x000e - int abs(int val)
;0x00a0 - 0x000f - long labs(long lval)
;0x00a0 - 0x0010 - long atoi(char *s)
;0x00a0 - 0x0011 - int atol(char *s)
;0x00a0 - 0x0012 - atob
;0x00a0 - 0x0013 - int setjmp(jmp_buf *ctx)
;0x00a0 - 0x0014 - longjmp(jmp_buf *ctx , int value)
;0x00a0 - 0x0015 - char *strcat(char *dst , char *src)
;0x00a0 - 0x0016 - char *strncat(char *dst , char *src , int n)
;0x00a0 - 0x0017 - int strcmp(char *dst , char *src)
;0x00a0 - 0x0018 - int strncmp(char *dst , char *src , int n)
;0x00a0 - 0x0019 - char *strcpy(char *dst , char *src)
;0x00a0 - 0x001a - char *strncpy(char *dst , char *src , int n))
;0x00a0 - 0x001b - int strlen(char *s)
;0x00a0 - 0x001c - int index(char *s , int c)
;0x00a0 - 0x001d - int rindex(char *s , int c)
;0x00a0 - 0x001e - char *strchr(char *c , int c)
;0x00a0 - 0x001f - char *strrchr(char *c , int c)
;0x00a0 - 0x0020 - char *strpbrk(char *dst , *src)
;0x00a0 - 0x0021 - int strspn(char *s , char *set)
;0x00a0 - 0x0022 - int strcspn(char *s , char *set)
;0x00a0 - 0x0023 - strtok(char *s , char *set)
;0x00a0 - 0x0024 - strstr(char *s , char *set)
;0x00a0 - 0x0025 - int toupper(int c)
;0x00a0 - 0x0026 - int tolower(int c)
;0x00a0 - 0x0027 - void bcopy(void *src , void *dst , int len)
;0x00a0 - 0x0028 - void bzero(void *ptr , int len)
;0x00a0 - 0x0029 - int bcmp(void *ptr1 , void *ptr2 , int len)
;0x00a0 - 0x002a - memcpy(void *dst , void *src , int n)
;0x00a0 - 0x002b - memset(void *dst , char c , int n)
;0x00a0 - 0x002c - memmove(void *dst , void *src , int n)
;0x00a0 - 0x002d - memcmp(void *dst , void *src , int n)
;0x00a0 - 0x002e - memchr(void *s , int c , int n)
;0x00a0 - 0x002f - int rand()
;0x00a0 - 0x0030 - void srand(unsigned int seed)
;0x00a0 - 0x0031 - void qsort(void *base , int nel , int width , int (*cmp)*void *,void *))
;0x00a0 - 0x0032 - double strtod(char *s , char *endptr)
;0x00a0 - 0x0033 - void *malloc(int size)
;0x00a0 - 0x0034 - free(void *buf)
;0x00a0 - 0x0035 - void *lsearch(void *key , void *base , int belp , int width , int (*cmp)(void * , void *))
;0x00a0 - 0x0036 - void *bsearch( void *key , void *base , int nel , int size , int (*cmp)(void * , void *))
;0x00a0 - 0x0037 - void *calloc(int size , int n)
;0x00a0 - 0x0038 - void *realloc(void *buf , int n)
;0x00a0 - 0x0039 - InitHeap(void *block , int n)
;0x00a0 - 0x003a - _exit()
;0x00a0 - 0x003b - char getchar(int fd) 
;0x00a0 - 0x003c - putchar(char c , int fd)
;0x00a0 - 0x003d - char *gets(char *s)
;0x00a0 - 0x003e - puts(char *s)
;0x00a0 - 0x003f - printf(char *fmt , ...)
;0x00a0 - 0x0041 - LoadTest(char *name , XF_HDR *header)
;0x00a0 - 0x0042 - Load(char *name , XF_HDR *header)
;0x00a0 - 0x0043 - Exec(struct EXEC *header , int argc , char **argc)
;0x00a0 - 0x0044 - FlushCache()
;0x00a0 - 0x0045 - void InstallInterruptHandler()
;0x00a0 - 0x0046 - GPU_dw
;0x00a0 - 0x0048 - int SetGPUStatus(int status)
;0x00a0 - 0x0049 - GPU_cw
;0x00a0 - 0x004a - GPU_cwb (not sure)
;0x00a0 - 0x004d - int GetGPUStatus()
;0x00a0 - 0x0049 - GPU_sync
;0x00a0 - 0x0051 - LoadExec(char *name , int , int)
;0x00x0 - 0x0052 - GetSysSp()
;0x00a0 - 0x0054 - _96_init()
;0x00a0 - 0x0055 - _bu_init()
;0x00a0 - 0x0056 - _96_remove()
;0x00a0 - 0x0057 - return 0 (it only does this)
;0x00a0 - 0x0058 - return 0 (it only does this)
;0x00a0 - 0x0059 - return 0 (it only does this)
;0x00a0 - 0x005a - return 0 (it only does this)
;0x00a0 - 0x005b - dev_tty_init
;0x00a0 - 0x005c - dev_tty_open
;0x00a0 - 0x005e - dev_tty_ioctl
;0x00a0 - 0x005f - dev_cd_open
;0x00a0 - 0x0060 - dev_cd_read
;0x00a0 - 0x0061 - dev_cd_close
;0x00a0 - 0x0062 - dev_cd_firstfile
;0x00a0 - 0x0063 - dev_cd_nextfile
;0x00a0 - 0x0064 - dev_cd_chdir
;0x00a0 - 0x0065 - dev_card_open
;0x00a0 - 0x0066 - dev_card_read
;0x00a0 - 0x0067 - dev_card_write
;0x00a0 - 0x0068 - dev_card_close
;0x00a0 - 0x0069 - dev_card_firstfile
;0x00a0 - 0x006a - dev_card_nextfile
;0x00a0 - 0x006b - dev_card_erase
;0x00a0 - 0x006c - dev_card_undelete
;0x00a0 - 0x006d - dev_card_format
;0x00a0 - 0x006e - dev_card_rename
;0x00a0 - 0x0070 - _bu_init
;0x00a0 - 0x0071 - _96_init
;0x00a0 - 0x0072 - _96_remove
;0x00a0 - 0x0078 - _96_CdSeekL
;0x00a0 - 0x007c - _96_CdGetStatus
;0x00a0 - 0x007e - _96_CdRead
;0x00a0 - 0x0085 - _96_CdStop
;0x00a0 - 0x0096 - AddCDROMDevice()
;0x00a0 - 0x0097 - AddMemCardDevice()
;0x00a0 - 0x0098 - DisableKernelIORedirection()
;0x00a0 - 0x0099 - EnableKernelIORedirection()
;0x00a0 - 0x009c - GetConf(int Event , int TCB , int Stack)
;0x00a0 - 0x009d - GetConf(int *Event , int *TCB , int *Stack)
;0x00a0 - 0x009f - SetMem(int size)
;0x00a0 - 0x00a0 - _boot
;0x00a0 - 0x00a1 - SystemError
;0x00a0 - 0x00a2 - EnqueueCdIntr
;0x00a0 - 0x00a3 - DequeueCdIntr
;0x00a0 - 0x00a5 - ReadSector(count,sector,buffer)
;0x00a0 - 0x00a6 - get_cd_status ??
;0x00a0 - 0x00a7 - bufs_cb_0
;0x00a0 - 0x00a8 - bufs_cb_1
;0x00a0 - 0x00a9 - bufs_cb_2
;0x00a0 - 0x00aa - bufs_cb_3
;0x00a0 - 0x00ab - _card_info
;0x00a0 - 0x00ac - _card_load
;0x00a0 - 0x00ad - _card_auto
;0x00a0 - 0x00ae - bufs_cb_4
;0x00a0 - 0x00b2 - do_a_long_jmp()
;0x00a0 - 0x00b4 - (sub_function)
;		  0 - u_long GetKernelDate (date is in 0xYYYYMMDD BCD format)
;		  1 - u_long GetKernel???? (returns 3 on cex1000 and cex3000)
;		  2 - char *GetKernelRomVersion()
;		  3 - ?
;		  4 - ?
;		  5 - u_long GetRamSize() (in bytes)
;		  6 -> F - ??
;
;0x00b0 - 0x0000 - SysMalloc (to malloc kernel memory)
;0x00b0 - 0x0007 - DeliverEvent(class , event)
;0x00b0 - 0x0008 - OpenEvent(class , spec , mode , func) (source code is corrected)
;0x00b0 - 0x0009 - CloseEvent(event)
;0x00b0 - 0x000a - WaitEvent(event)
;0x00b0 - 0x000b - TestEvent(event)
;0x00b0 - 0x000c - EnableEvent(event)
;0x00b0 - 0x000d - DisableEvent(event)
;0x00b0 - 0x000e - OpenTh
;0x00b0 - 0x000f - CloseTh
;0x00b0 - 0x0010 - ChangeTh
;0x00b0 - 0x0012 - InitPad
;0x00b0 - 0x0013 - StartPad
;0x00b0 - 0x0014 - StopPAD
;0x00b0 - 0x0015 - PAD_init
;0x00b0 - 0x0016 - u_long PAD_dr()
;0x00b0 - 0x0017 - ReturnFromException
;0x00b0 - 0x0018 - ResetEntryInt
;0x00b0 - 0x0019 - HookEntryInt
;0x00b0 - 0x0020 - UnDeliverEvent(class , event)
;0x00b0 - 0x0032 - int open(char *name,int access)
;0x00b0 - 0x0033 - int lseek(int fd,long pos,int seektype)
;0x00b0 - 0x0034 - int read(int fd,void *buf,int nbytes)
;0x00b0 - 0x0035 - int write(int fd,void *buf,int nbytes)
;0x00b0 - 0x0036 - close(int fd)
;0x00b0 - 0x0037 - int ioctl(int fd , int cmd , int arg)
;0x00b0 - 0x0038 - exit(int exitcode)
;0x00b0 - 0x003a - char getc(int fd)
;0x00b0 - 0x003b - putc(int fd,char ch)
;0x00b0 - 0x003c - char getchar()
;0x00b0 - 0x003d - putchar(char ch)
;0x00b0 - 0x003e - char *gets(char *s)
;0x00b0 - 0x003f - puts(char *s)
;0x00b0 - 0x0040 - cd
;0x00b0 - 0x0041 - format
;0x00b0 - 0x0042 - firstfile
;0x00b0 - 0x0043 - nextfile
;0x00b0 - 0x0044 - rename
;0x00b0 - 0x0045 - delete
;0x00b0 - 0x0046 - undelete
;0x00b0 - 0x0047 - AddDevice (used by AddXXXDevice)
;0x00b0 - 0x0048 - RemoveDevice
;0x00b0 - 0x0049 - PrintInstalledDevices
;0x00b0 - 0x004a - InitCARD
;0x00b0 - 0x004b - StartCARD
;0x00b0 - 0x004c - StopCARD
;0x00b0 - 0x004e - _card_write
;0x00b0 - 0x004f - _card_read
;0x00b0 - 0x0050 - _new_card
;0x00b0 - 0x0051 - Krom2RawAdd
;0x00b0 - 0x0054 - long _get_errno(void)
;0x00b0 - 0x0055 - long _get_error(long fd)
;0x00b0 - 0x0056 - GetC0Table
;0x00b0 - 0x0057 - GetB0Table
;0x00b0 - 0x0058 - _card_chan
;0x00b0 - 0x005b - ChangeClearPad(int)
;0x00b0 - 0x005c - _card_status
;0x00b0 - 0x005d - _card_wait
;
;0x00c0 - 0x0000 - InitRCnt
;0x00c0 - 0x0001 - InitException
;0x00c0 - 0x0002 - SysEnqIntRP(int index , long *queue)
;0x00c0 - 0x0003 - SysDeqIntRP(int index , long *queue)
;0x00c0 - 0x0004 - get_free_EvCB_slot()
;0x00c0 - 0x0005 - get_free_TCB_slot()
;0x00c0 - 0x0006 - ExceptionHandler
;0x00c0 - 0x0007 - InstallExceptionHandlers
;0x00c0 - 0x0008 - SysInitMemory
;0x00c0 - 0x0009 - SysInitKMem
;0x00c0 - 0x000a - ChangeClearRCnt
;0x00c0 - 0x000b - SystemError ???
;0x00c0 - 0x000c - InitDefInt
;0x00c0 - 0x0012 - InstallDevices
;0x00c0 - 0x0013 - FlushStdInOutPut
;0x00c0 - 0x0014 - return 0
;0x00c0 - 0x0015 - _cdevinput
;0x00c0 - 0x0016 - _cdevscan
;0x00c0 - 0x0017 - char _circgetc(struct device_buf *circ)
;0x00c0 - 0x0018 - _circputc(char c , struct device_buf *circ)
;0x00c0 - 0x0019 - ioabort(char *str)
;0x00c0 - 0x001b - KernelRedirect(int flag)
;0x00c0 - 0x001c - PatchA0Table
;
;
;There are 3 more i know that arent called the same way as above: 
;
;MiPS R3000: 
;
;Exception() { 
;li $a0,0 
;syscall 
;} 
;
;EnterCriticalSection() { 
;li $a0,1 
;syscall 
;} 
;
;ExitCriticalSection() { 
;li $a0,2 
;syscall 
;} 
