;	macros.inc - psx macros file

;	psx header block macro...
header		macro	progstart,proglength,progstack
		org	progstart-$800
		db	"PS-X EXE",0,0,0,0,0,0,0,0
		dw	progstart,0,progstart,proglength
		dw	0,0,0,0
		dw	progstack,0,0,0
		dcb	$800-$40,0
		endm

; *	 Name	  |Shade  |Vertex |Texture| Function
; *	 ---------+-------+-------+-------+-------+------------------------
; *  $20 POLY_F3  |Flat	  |   3	  |OFF	  | Flat Triangle
; *  $24 POLY_FT3 |Flat	  |   3	  |ON	  | Flat Textured Triangle
; *  $30 POLY_G3  |Gouraud|   3	  |OFF	  | Gouraud Triangle
; *  $34 POLY_GT3 |Gouraud|   3	  |ON	  | Gouraud Textured Triangle
; *  $28 POLY_F4  |Flat	  |   4	  |OFF	  | Flat Quadrangle
; *  $2c POLY_FT4 |Flat	  |   4	  |ON	  | Flat Textured Quadrangle
; *  $38 POLY_G4  |Gouraud|   4	  |OFF	  | Gouraud Quadrangle
; *  $3c POLY_GT4 |Gouraud|   4	  |ON	  | Gouraud Textured Quadrangle
; *	 ---------+-------+-------+-------+------------------------
; *  $40 LINE_F2  |Flat	  |   2	  | -	  | unconnected	Flat Line 
; *  $50 LINE_G2  |Gouraud|   2	  | -	  | unconnected	Gouraud	Line 
; *  $48 LINE_F3  |Flat	  |   3	  | -	  | 3-connected	Flat Line
; *  $58 LINE_G3  |Gouraud|   3	  | -	  | 3-connected	Gouraud	Line
; *  $4c LINE_F4  |Flat	  |   4	  | -	  | 4-connected	Flat Line
; *  $5c LINE_G4  |Gouraud|   4	  | -	  | 4-connected	Gouraud	Line
; *	 ---------+-------+-------+-------+------------------------
; *  $64 SPRT	  |Flat	  |   1	  |ON	  | free size Sprite
; *  $6c SPRT_16  |Flat	  |   1	  |ON	  | 16x16 Sprite
; *  $74 SPRT_8	  |Flat	  |   1	  |ON	  | 8x8	Sprite
; *	 ---------+-------+-------+-------+------------------------
; *  $60 TILE	  |Flat	  |   1	  |OFF	  | free size Sprite
; *  $78 TILE_16  |Flat	  |   1	  |OFF	  | 16x16 Sprite
; *  $70 TILE_8	  |Flat	  |   1	  |OFF	  | 8x8	Sprite
; *  $68 TILE_1	  |Flat	  |   1	  |OFF	  | 1x1	Sprite
; *	 ---------+-------+-------+-------+------------------------
; *	 DR_TWIN  | 3	  |   -	  |   -	  | -	  | Texture Window
; *	 DR_AREA  | 3	  |   -	  |   -	  | -	  | Drawing Area
; *	 DR_OFFSET| 3	  |   -	  |   -	  | -	  | Drawing Offset
; *	 DR_MODE  | 3	  |   -	  |   -	  | -	  | Drawing Mode
; *	 DR_ENV	  |16	  |   -	  |   -	  | -	  | Drawing Environment
; *	 DR_MOVE  | 6	  |   -	  |   -	  | -	  | MoveImage
; *	 DR_LOAD  |17	  |   -	  |   -	  | -	  | LoadImage
; *  $E1 DR_TPAGE |   -	  |   -	  |   -	  | Drawing TPage
; *	 DR_STP	  | 3	  |   -	  |   -	  | -	  | Drawing STP
; *  $01 DR_FLUSH |   -	  |   -	  |   -	  | Cache flush!
; *  $02 DR_BLOCK | Flat  |   -	  |   -	  | Block fill with colour!
; *
; *	 *1: in	long-word
; *
; * Texture Attributes:
; *	 abr: ambient rate
; *		 abr	 0	 1	 2	 3
; *		 -------------------------------------
; *		 Front	 0.5	 1.0	 0.5	 -1.0
; *		 Back	 0.5	 1.0	 1.0	  1.0
; *
; *	 tp: texture mode
; *		  tp	 0	 1	 2 
; *		  -----------------------------
; *		  depth	 4bit	 8bit	 16bit
; *		  color	 CLUT	 CLUT	 DIRECT

;	gpu macros...
dr_flush	macro	next
		dw	(next&$00ffffff)!(1<<24)
		db	0,0,0,$01
		endm

dr_block	macro	next,r,g,b,x,y,w,h
		dw	(next&$00ffffff)!(3<<24)
		db	r,g,b,$02
		dh	x,y,w,h
		endm

dr_tpage	macro	next,clut,trans,x,y
		dw	(next&$00ffffff)!(1<<24)
		dw	($e1<<24)!((clut&3)<<7)!((trans&3)<<5)!((x>>6)&$f)!(((y>>8)&1)<<4)!(((y>>9)&1)<<$b)
		endm

poly_f3		macro	next,r,g,b,x0,y0,x1,y1,x2,y2
		dw	(next&$00ffffff)!(4<<24)
		db	r,g,b,$20
		dh	x0,y0,x1,y1,x2,y2
		endm

poly_f4		macro	next,r,g,b,x0,y0,x1,y1,x2,y2,x3,y3
		dw	(next&$00ffffff)!(5<<24)
		db	r,g,b,$28
		dh	x0,y0,x1,y1,x2,y2,x3,y3
		endm

poly_g3		macro	next,r0,g0,b0,x0,y0,r1,g1,b1,x1,y1,r2,g2,b2,x2,y2
		dw	(next&$00ffffff)!(6<<24)
		db	r0,g0,b0,$30
		dh	x0,y0
		db	r1,g1,b1,0
		dh	x1,y1
		db	r2,g2,b2,0
		dh	x2,y2
		endm

poly_g4		macro	next,r0,g0,b0,x0,y0,r1,g1,b1,x1,y1,r2,g2,b2,x2,y2,r3,b3,g3,x3,y3
		dw	(next&$00ffffff)!(8<<24)
		db	r0,g0,b0,$38
		dh	x0,y0
		db	r1,g1,b1,0
		dh	x1,y1
		db	r2,g2,b2,0
		dh	x2,y2
		db	r3,g3,b3,0
		dh	x3,y3
		endm

poly_ft3	macro	next,r,g,b,x0,y0,u0,v0,x1,y1,u1,v1,x2,y2,u2,v2,cx,cy,clut,trans,x,y
		dw	(next&$00ffffff)!(7<<24)
		db	r,g,b,$24
		dh	x0,y0
		db	u0,v0
		dh	((cx&$3ff)>>4)!((cy&$3ff)<<6)
		dh	x1,y1
		db	u1,v1
		dh	((clut&3)<<7)!((trans&3)<<5)!((x>>6)&$f)!(((y>>8)&1)<<4)!(((y>>9)&1)<<$b)
		dh	x2,y2
		db	u2,v2
		dh	0
		endm

poly_ft4	macro	next,r,g,b,x0,y0,u0,v0,x1,y1,u1,v1,x2,y2,u2,v2,x3,y3,u3,v3,cx,cy,clut,trans,x,y
		dw	(next&$00ffffff)!(9<<24)
		db	r,g,b,$2c
		dh	x0,y0
		db	u0,v0
		dh	((cx&$3ff)>>4)!((cy&$3ff)<<6)
		dh	x1,y1
		db	u1,v1
		dh	((clut&3)<<7)!((trans&3)<<5)!((x>>6)&$f)!(((y>>8)&1)<<4)!(((y>>9)&1)<<$b)
		dh	x2,y2
		db	u2,v2
		dh	0
		dh	x3,y3
		db	u3,v3
		dh	0
		endm

poly_gt3	macro	next,r0,g0,b0,x0,y0,u0,v0,r1,g1,b1,x1,y1,u1,v1,r2,g2,b2,x2,y2,u2,v2,cx,cy,clut,trans,x,y
		dw	(next&$00ffffff)!(9<<24)
		db	r0,g0,b0,$34
		dh	x0,y0
		db	u0,v0
		dh	((cx&$3ff)>>4)!((cy&$3ff)<<6)
		db	r1,g1,b1,0
		dh	x1,y1
		db	u1,v1
		dh	((clut&3)<<7)!((trans&3)<<5)!((x>>6)&$f)!(((y>>8)&1)<<4)!(((y>>9)&1)<<$b)
		db	r2,g2,b2,0
		dh	x2,y2
		db	u2,v2
		dh	0
		endm

poly_gt4	macro	next,r0,g0,b0,x0,y0,u0,v0,r1,g1,b1,x1,y1,u1,v1,r2,g2,b2,x2,y2,u2,v2,r3,g3,b3,x3,y3,u3,v3,cx,cy,clut,trans,x,y
		dw	(next&$00ffffff)!(12<<24)
		db	r0,g0,b0,$3c
		dh	x0,y0
		db	u0,v0
		dh	((cx&$3ff)>>4)!((cy&$3ff)<<6)
		db	r1,g1,b1,0
		dh	x1,y1
		db	u1,v1
		dh	((clut&3)<<7)!((trans&3)<<5)!((x>>6)&$f)!(((y>>8)&1)<<4)!(((y>>9)&1)<<$b)
		db	r2,g2,b2,0
		dh	x2,y2
		db	u2,v2
		dh	0   
		db	r3,g3,b3,0
		dh	x3,y3
		db	u3,v3
		dh	0
		endm

line_f2		macro	next,r,g,b,x0,y0,x1,y1
		dw	(next&$00ffffff)!(3<<24)
		db	r,g,b,$40
		dh	x0,y0,x1,y1
		endm

line_f3		macro	next,r,g,b,x0,y0,x1,y1,x2,y2
		dw	(next&$00ffffff)!(4<<24)
		db	r,g,b,$48
		dh	x0,y0,x1,y1,x2,y2
		endm

line_f4		macro	next,r,g,b,x0,y0,x1,y1,x2,y2,x3,y3
		dw	(next&$00ffffff)!(5<<24)
		db	r,g,b,$4c
		dh	x0,y0,x1,y1,x2,y2,x3,y3
		endm

line_g2		macro	next,r0,g0,b0,x0,y0,r1,g1,b1,x1,y1
		dw	(next&$00ffffff)!(4<<24)
		db	r0,g0,b0,$50
		dh	x0,y0
		db	r1,g1,b1,0
		dh	x1,y1
		endm

line_g3		macro	next,r0,g0,b0,x0,y0,r1,g1,b1,x1,y1,r2,g2,b2,x2,y2
		dw	(next&$00ffffff)!(6<<24)
		db	r0,g0,b0,$58
		dh	x0,y0
		db	r1,g1,b1,0
		dh	x1,y1
		db	r2,g2,b2,0
		dh	x2,y2
		endm

line_g4		macro	next,r0,g0,b0,x0,y0,r1,g1,b1,x1,y1,r2,g2,b2,x2,y2,r3,g3,b3,x3,y3
		dw	(next&$00ffffff)!(8<<24)
		db	r0,g0,b0,$5c
		dh	x0,y0
		db	r1,g1,b1,0
		dh	x1,y1
		db	r2,g2,b2,0
		dh	x2,y2
		db	r3,g3,b3,0
		dh	x3,y3
		endm

sprt		macro	next,r,g,b,x,y,w,h,u,v,cx,cy
		dw	(next&$00ffffff)!(4<<24)
		db	r,g,b,$64
		dh	x,y
		db	u,v
		dh	((cx&$3ff)>>4)!((cy&$3ff)<<6)
		dh	w,h
		endm

sprt_16		macro	next,r,g,b,x,y,u,v,cx,cy
		dw	(next&$00ffffff)!(3<<24)
		db	r,g,b,$6c
		dh	x,y
		db	u,v
		dh	((cx&$3ff)>>4)!((cy&$3ff)<<6)
		endm

sprt_8		macro	next,r,g,b,x,y,u,v,cx,cy
		dw	(next&$00ffffff)!(3<<24)
		db	r,g,b,$74
		dh	x,y
		db	u,v
		dh	((cx&$3ff)>>4)!((cy&$3ff)<<6)
		endm

tile		macro	next,r,g,b,x,y,w,h
		dw	(next&$00ffffff)!(3<<24)
		db	r,g,b,$60
		dh	x,y
		dh	w,h
		endm

tile_16		macro	next,r,g,b,x,y
		dw	(next&$00ffffff)!(2<<24)
		db	r,g,b,$78
		dh	x,y
		endm

tile_8		macro	next,r,g,b,x,y
		dw	(next&$00ffffff)!(2<<24)
		db	r,g,b,$70
		dh	x,y
		endm

tile_1		macro	next,r,g,b,x,y
		dw	(next&$00ffffff)!(2<<24)
		db	r,g,b,$68
		dh	x,y
		endm


;/*
; *  Special Primitive Definitions
; */
;typedef struct	{
;	 u_long	 tag;
;	 u_long	 code[2];
;} DR_MODE;				 /* Drawing Mode */
;
;typedef struct	{
;	 u_long	 tag;
;	 u_long	 code[2];
;} DR_TWIN;				 /* Texture Window */
;		
;typedef struct	{
;	 u_long	 tag;
;	 u_long	 code[2];
;} DR_AREA;				 /* Drawing Area */
;		
;typedef struct	{
;	 u_long	 tag;
;	 u_long	 code[2];
;} DR_OFFSET;				 /* Drawing Offset */
;		
;typedef struct	{			 /* MoveImage */
;	 u_long	 tag;
;	 u_long	 code[5];
;} DR_MOVE;
;
;typedef struct	{			 /* LoadImage */
;	 u_long	 tag;
;	 u_long	 code[3];
;	 u_long	 p[13];
;} DR_LOAD;
;
;typedef struct	{
;	 u_long	 tag;
;	 u_long	 code[1];
;} DR_TPAGE;				 /* Drawing TPage */
;
;typedef struct	{
;	 u_long	 tag;
;	 u_long	 code[2];
;} DR_STP;				 /* Drawing STP	*/



;typedef struct	{
;	 short x, y;		 /* offset point on VRAM */
;	 short w, h;		 /* width and height */
;} RECT;
;
;typedef struct	{
;	 int x,	y;		 /* offset point on VRAM */
;	 int w,	h;		 /* width and height */
;} RECT32;
;
;/*
; * Environment	
; */
;typedef struct	{
;	 u_long	 tag;
;	 u_long	 code[15];
;} DR_ENV;				 /* Packed Drawing Environment */
;		
;typedef struct	{
;	 RECT	 clip;		 /* clip area */
;	 short	 ofs[2];	 /* drawing offset */
;	 RECT	 tw;		 /* texture window */
;	 u_short tpage;		 /* texture page */ 
;	 u_char	 dtd;		 /* dither flag	(0:off,	1:on) */
;	 u_char	 dfe;		 /* flag to draw on display area (0:off	1:on) */
;	 u_char	 isbg;		 /* enable to auto-clear */
;	 u_char	 r0, g0, b0;	 /* initial background color */
;	 DR_ENV	 dr_env;	 /* reserved */
;} DRAWENV;
;		
;typedef struct	{
;	 RECT	 disp;		 /* display area */
;	 RECT	 screen;	 /* display start point	*/
;	 u_char	 isinter;	 /* interlace 0: off 1:	on */
;	 u_char	 isrgb24;	 /* RGB24 bit mode */
;	 u_char	 pad0, pad1;	 /* reserved */
;} DISPENV;
;
;/*
; * Polygon Primitive Definitions
; */
;typedef struct	{
;	 unsigned	 addr: 24;
;	 unsigned	 len:	8;
;	 u_char		 r0, g0, b0, code;
;} P_TAG;
; 
;typedef struct	{
;	 u_char	 r0, g0, b0, code;
;} P_CODE;
; 

