' BWSB sound includes
'$INCLUDE: 'BWSB.BI'
'$INCLUDE: 'GDMTYPE.BI'

' Subroutine declarations
DECLARE SUB pal (act$)
DECLARE SUB gifload (bsvfile$)
DECLARE SUB waitformusic (order%, pattern%, row%)
DECLARE SUB TrueBlack ()
DECLARE SUB ClearScr ()
DECLARE SUB MetalPal ()
DECLARE SUB UpdateSine (SineRoll&)
DECLARE SUB ScreenMod (act$)

' 3D stuff, shamelessly stolen from:
' http://www.phatcode.net/res/213/files/3dwire.bas
' and modified for my nefarious purposes

DECLARE SUB DrawModel2 (Model() AS ANY, Tri() AS ANY)
DECLARE SUB RotateAndProject (Model() AS ANY, AngleX%, AngleY%, AngleZ%)
DECLARE SUB LoadPoly (Model() AS ANY, Tri() AS ANY, Scale!)

TYPE Point3d
		  x       AS SINGLE                   'Normal 3d coords
		  y       AS SINGLE
		  z       AS SINGLE
		  xr      AS SINGLE                   'Rotated  3d coords
		  yr      AS SINGLE
		  zr      AS SINGLE
		  scrx    AS INTEGER                  'Translated and projected
		  scry    AS INTEGER                  '2d Coords
END TYPE

TYPE PolyType2
		  p1 AS INTEGER
		  p2 AS INTEGER
END TYPE

CONST FALSE = 0, TRUE = NOT FALSE

CONST LENS = 256                            'Z
CONST XCENTER = 160                         '??
CONST YCENTER = 80                          '??

CONST PI = 3.14151693#

REDIM SHARED Model(1) AS Point3d               '3d  Coords
REDIM SHARED DemoPoly(1) AS PolyType2
DIM SHARED Thetax, Thetay, Thetaz              'Angle of rotation
DIM SHARED camx%, camy%, camz%                 'camera

LoadPoly Model(), DemoPoly(), 2.6

camx% = 0
camy% = 0
camz% = 0

Thetax% = INT(RND * 360)
Thetay% = INT(RND * 360)
Thetaz% = INT(RND * 360)

'vertices of 771
DemoPoly:
DATA -20,  10, 0
DATA  -5,  10, 0
DATA  -5,   7, 0
DATA -18, -10, 0
DATA -21, -10, 0
DATA  -8,   7, 0
DATA -20,   7, 0
DATA  -1,  10, 0
DATA  14,  10, 0
DATA  14,   7, 0
DATA   1, -10, 0
DATA  -2, -10, 0
DATA  11,   7, 0
DATA  -1,   7, 0
DATA  21,  10, 0
DATA  21, -10, 0
DATA  18, -10, 0
DATA  18,   7, 0
DATA -22,  12, -10
DATA  23,  12, -10
DATA  23, -12, -10
DATA -22, -12, -10
DATA -22,  12, 10
DATA  23,  12, 10
DATA  23, -12, 10
DATA -22, -12, 10

' Lines for 771 Poly
DEMOPOLYCONNECT:
DATA 0,1
DATA 1,2
DATA 2,3
DATA 3,4
DATA 4,5
DATA 5,6
DATA 6,0
DATA 7,8
DATA 8,9
DATA 9,10
DATA 10,11
DATA 11,12
DATA 12,13
DATA 13,7
DATA 14,15
DATA 15,16
DATA 16,17
DATA 17,14
DATA 18,19
DATA 19,20
DATA 20,21
DATA 21,18
DATA 22,23
DATA 23,24
DATA 24,25
DATA 25,22
DATA 18,22
DATA 19,23
DATA 20,24
DATA 21,25

' BWSB type declarations
TYPE MSEConfigFile
  SoundCard AS INTEGER
  BaseIO AS INTEGER
  IRQ AS INTEGER
  DMA AS INTEGER
  SoundQuality AS INTEGER
END TYPE

' BWSB arrays
DIM ModHeader AS GDMHeader
DIM SndDevMSE(6) AS STRING
DIM MSEConfig AS MSEConfigFile

' Shared palette storage
DIM SHARED red(256) AS INTEGER
DIM SHARED grn(256) AS INTEGER
DIM SHARED blu(256) AS INTEGER
DIM SHARED targetgrey(256) AS INTEGER

' Font storage
DIM font%(8211)
DIM FontChars%(32 TO 90)

' Scroller Info
DIM SHARED sineWave%(320)
SineRoll& = 0
UpdateSine (SineRoll&)
DIM ScrollBlit%(5161)
DIM RowBlit%(32)

' Volume Speed Blocks
DIM LeftBlock%(3002)
DIM Rightblock%(3002)

' BWSB initialization
Freemem& = FRE(-1) - 80000      'Basic Heap - EXE Memory (80000)
a& = SETMEM(-Freemem&)          'This is the memory freed for module
										  'and MSE usage.

' BWSB supported devices
SndDevMSE(1) = "GUS"
SndDevMSE(2) = "SB1X"
SndDevMSE(3) = "SB2X"
SndDevMSE(4) = "SBPRO"
SndDevMSE(5) = "SB16"
SndDevMSE(6) = "PAS"

' Parse BWSB config
OPEN "MSE.CFG" FOR BINARY AS 1
  GET 1, , MSEConfig
CLOSE 1
IF MSEConfig.SoundCard = 0 THEN
  PRINT "No Soundcard selected in SETUP.  Please run SETUP."
  END
END IF

MSE$ = SndDevMSE(MSEConfig.SoundCard) + ".MSE"

' BWSB Playback Freq
DIM Ov AS INTEGER
SELECT CASE MSEConfig.SoundQuality
CASE 0: Ov = 16
CASE 1: Ov = 22
CASE 2: Ov = 45
CASE 3: Ov = 8
END SELECT

' Load the BWSB blob
ErrorFlag = LoadMSE(MSE$, 0, Ov, 4096, MSEConfig.BaseIO, MSEConfig.IRQ, MSEConfig.DMA)

SELECT CASE ErrorFlag
  CASE 0
  CASE 1: PRINT "Base I/O address autodetect failure": END
  CASE 2: PRINT "IRQ level autodetect failure": END
  CASE 3: PRINT "DMA channel autodetect failure": END
  CASE 4: PRINT "DMA channel not supported": END
  CASE 6: PRINT "Sound device does not respond": END
  CASE 7: PRINT "Memory control blocks destroyed": END
  CASE 8: PRINT "Insufficient memory for mixing buffers": END
  CASE 9: PRINT "Insufficient memory for MSE file": END
  CASE 10: PRINT "MSE has invalid identifications string (corrupt/non-existant)": END
  CASE 11: PRINT "MSE disk read failure": END
  CASE 12: PRINT "MVSOUND.SYS not loaded (required for PAS use)": END
  CASE ELSE: PRINT "Unknown error on MSE startup" + STR$(ErrorFlag): END
END SELECT

' If EMS is available, use it instead of low mem for module storage
DIM Flags AS INTEGER
IF EmsExist THEN Flags = 1 ELSE Flags = 0

' Stream in the MOD file
File = FREEFILE
OPEN "POD.GDM" FOR BINARY AS File
LoadGDM FILEATTR(File, 2), 0, Flags, VARSEG(ModHeader), VARPTR(ModHeader)
CLOSE File

' Prep BWSB by iterating through all the channels
DIM MusChans AS INTEGER
MusChans = 0
FOR j = 1 TO 32
  IF ASC(MID$(ModHeader.PanMap, j, 1)) <> &HFF THEN
	 MusChans = MusChans + 1
  END IF
NEXT

OverRate& = StartOutput(MusChans, 0)

' On with the show, start with a black screen so we can load fonts while
' noone is looking...
SCREEN 13
CLS
pal "blackout"

' Chop up this image for later bliting
gifload "METAL2.BSV"
TrueBlack

GET (3, 0)-(24, 21), font%: FontChars%(65) = 0
GET (39, 0)-(55, 21), font%(244): FontChars%(66) = 244
GET (70, 0)-(85, 21), font%(433): FontChars%(67) = 433
GET (101, 0)-(117, 21), font%(611): FontChars%(68) = 611
GET (128, 0)-(144, 21), font%(800): FontChars%(69) = 800
GET (150, 0)-(166, 31), font%(989): FontChars%(70) = 989

GET (3, 35)-(19, 56), font%(1263): FontChars%(71) = 1263
GET (38, 35)-(55, 66), font%(1452): FontChars%(72) = 1452
GET (74, 35)-(80, 66), font%(1742): FontChars%(73) = 1742
GET (98, 35)-(107, 56), font%(1856): FontChars%(74) = 1856
GET (123, 35)-(140, 66), font%(1968): FontChars%(75) = 1968
GET (150, 35)-(165, 56), font%(2258): FontChars%(76) = 2258

GET (3, 71)-(27, 102), font%(2436): FontChars%(77) = 2436
GET (41, 71)-(56, 102), font%(2838): FontChars%(78) = 2838
GET (71, 71)-(86, 92), font%(3096): FontChars%(79) = 3096
GET (101, 71)-(117, 102), font%(3274): FontChars%(80) = 3274
GET (127, 71)-(144, 92), font%(3548): FontChars%(81) = 3548
GET (149, 71)-(166, 102), font%(3748): FontChars%(82) = 3748

GET (3, 107)-(20, 128), font%(4038): FontChars%(83) = 4038
GET (32, 107)-(48, 138), font%(4238): FontChars%(84) = 4238
GET (61, 107)-(77, 128), font%(4512): FontChars%(85) = 4512
GET (91, 107)-(110, 128), font%(4701): FontChars%(86) = 4701
GET (122, 107)-(146, 128), font%(4923): FontChars%(87) = 4923
GET (150, 107)-(165, 128), font%(5200): FontChars%(88) = 5200

GET (4, 142)-(19, 173), font%(5378): FontChars%(89) = 5378
GET (37, 142)-(53, 163), font%(5636): FontChars%(90) = 5636

GET (71, 142)-(78, 163), font%(5825): FontChars%(49) = 5825
GET (96, 142)-(111, 163), font%(5915): FontChars%(50) = 5915
GET (125, 142)-(142, 163), font%(6093): FontChars%(51) = 6093
GET (149, 142)-(164, 163), font%(6293): FontChars%(52) = 6293
GET (4, 178)-(19, 199), font%(6471): FontChars%(53) = 6471
GET (35, 178)-(51, 199), font%(6649): FontChars%(54) = 6649
GET (67, 178)-(82, 199), font%(6838): FontChars%(55) = 6838
GET (98, 178)-(113, 199), font%(7016): FontChars%(56) = 7016
GET (127, 178)-(143, 199), font%(7194): FontChars%(57) = 7194
GET (150, 178)-(165, 199), font%(7383): FontChars%(48) = 7383

'Make our own punctuation
FontExcl:
DATA  1,17,45,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40, 1, 1, 1,45,40,45,42,40,40
DATA  1,28,31,16,20,20,27,31,35,38,42,48,53,57,57,60,57,52,52,44,35,38,35, 1, 1, 1,17,16,15,13,21,34
DATA  1,27,30,15,20,20,26,26,29,38,36,42,48,53,52,57,62,57,57,57,48,44,42, 1, 1, 1,24,20,21,17,40,15
DATA  1,28,30,14,16,17,20,24,25,29,35,42,42,44,53,53,57,62,62,55,55,53,48, 1, 1, 1,30,24,20,46,25, 1
DATA  1,27,28,12,13,13,14,16,19,19,21,28,31,35,38,44,49,52,52,57,53,52,53, 1, 1, 1,35,28,40,27, 2, 1
DATA  1,27,63,55,57,57,57,57,62,57,62,62,60,62,62,62,62,63,63,63,63,60,62, 1, 1, 1,62,62,46, 9, 1, 1
DATA  1, 6,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10, 1, 1, 1,10,10, 7, 1, 1, 1

FontPeriod:
DATA  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,45,40,45,42,40,40
DATA  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,17,16,15,13,21,34
DATA  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,24,20,21,17,40,15
DATA  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,30,24,20,46,25, 1
DATA  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,35,28,40,27, 2, 1
DATA  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,62,62,46, 9, 1, 1
DATA  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,10,10, 7, 1, 1, 1

FontComa:
DATA  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,10,10, 1, 1, 1, 1,33,40,33
DATA  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,62,62,46, 1, 1, 1,30,27,40
DATA  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,35,28,40,27, 1, 1,27,25,40
DATA  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,30,24,20,46,25, 1,25,25,40
DATA  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,24,20,21,17,40,15,30,25,40
DATA  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,17,16,15,13,21,34,30,25,40
DATA  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,45,40,45,42,40,40,40,40,17

RESTORE FontExcl
FOR x% = 220 TO 226
  FOR y% = 0 TO 31
	 READ colour%
	 PSET (x%, y%), colour%
  NEXT y%
NEXT x%

RESTORE FontPeriod
FOR x% = 230 TO 236
  FOR y% = 0 TO 31
	 READ colour%
	 PSET (x%, y%), colour%
  NEXT y%
NEXT x%

RESTORE FontComa
FOR x% = 240 TO 246
  FOR y% = 0 TO 31
	 READ colour%
	 PSET (x%, y%), colour%
  NEXT y%
NEXT x%

TrueBlack

GET (220, 0)-(226, 31), font%(7561): FontChars%(33) = 7561
GET (230, 0)-(236, 31), font%(7675): FontChars%(46) = 7675
GET (240, 0)-(246, 31), font%(7789): FontChars%(44) = 7789

' Yes, the apostrophe is a butchered comma which is a butchered period...
FOR x% = 240 TO 246
  FOR y% = 32 TO 70
	 PSET (x%, y%), 0
  NEXT y%
NEXT x%

FOR x% = 220 TO 239
  FOR y% = 0 TO 31
	 PSET (x%, y%), 0
  NEXT y%
NEXT x%
TrueBlack

GET (240, 23)-(246, 54), font%(7903): FontChars%(39) = 7903
GET (220, 0)-(231, 31), font%(8017): FontChars%(32) = 8017

'MetalPal

LINE (0, 0)-(40, 199), 0, BF
LINE (1, 0)-(1, 199), 71
LINE (3, 0)-(28, 199), 89, BF
LINE (30, 0)-(30, 199), 71
LINE (3, 158)-(28, 145), 0
LINE (3, 157)-(28, 144), 0
LINE (3, 156)-(28, 143), 0
PAINT (4, 154), 90, 0
LINE (3, 116)-(28, 103), 0
LINE (3, 115)-(28, 102), 0
PAINT (4, 112), 91, 0
LINE (3, 88)-(28, 75), 0
LINE (3, 87)-(28, 74), 0
PAINT (4, 86), 92, 0
LINE (3, 69)-(28, 56), 0
LINE (3, 68)-(28, 55), 0
PAINT (4, 66), 93, 0
LINE (3, 56)-(28, 43), 0
LINE (3, 55)-(28, 42), 0
PAINT (4, 53), 94, 0
LINE (3, 47)-(28, 34), 0
LINE (3, 46)-(28, 33), 0
PAINT (4, 44), 95, 0
LINE (3, 40)-(28, 27), 0
LINE (3, 39)-(28, 26), 0
PAINT (4, 37), 96, 0
LINE (3, 35)-(28, 22), 0
LINE (3, 34)-(28, 21), 0
PAINT (4, 32), 97, 0
PAINT (4, 1), 98, 0
GET (1, 0)-(30, 199), LeftBlock%
PUT (50, 0), LeftBlock%(0), PSET

PAINT (5, 170), 100, 0
PAINT (5, 150), 101, 0
PAINT (5, 112), 102, 0
PAINT (5, 84), 103, 0
PAINT (4, 66), 104, 0
PAINT (4, 53), 105, 0
PAINT (4, 44), 106, 0
PAINT (4, 37), 107, 0
PAINT (4, 32), 108, 0
PAINT (4, 1), 109, 0
GET (1, 0)-(30, 199), Rightblock%

'DO
'  G$ = INKEY$
'LOOP UNTIL LEN(G$)
'END

Scroller$ = "                                                              "
Scroller$ = Scroller$ + "WINTER IS OVER, IT'S TIME TO RACE!    771 CORDIALLY INVITES YOU TO"
Scroller$ = Scroller$ + " COME RACE IN 2014 THE ONLY WAY I KNOW HOW, WITH A"
Scroller$ = Scroller$ + " CIRCA 1992 STYLE INVITE WRITTEN IN QBASIC.    "
Scroller$ = Scroller$ + "YES, I'M A NERD.    ANYWAY, 771 IS BACK FOR 2014"
Scroller$ = Scroller$ + " AND LOOKING TO IMPROVE ON LAST YEAR'S PERF.    "
Scroller$ = Scroller$ + "DEMOSCENE TRADITION DICTATES SHOUTOUTS.    HELLO TO"
Scroller$ = Scroller$ + " RSP, ECK, SEACOAST AND THE REST OF THE CENTER"
Scroller$ = Scroller$ + " GARAGE NUTTERS.    GREETINGS TO DZIRCHER, TSORFAS,"
Scroller$ = Scroller$ + " CARSICK AND TROUBLE.    SALUTATIONS TO T1A AND ZIP"
Scroller$ = Scroller$ + " TIE ALLEY.    HOWDY TO GMD COMPUTRAK, STREET AND"
Scroller$ = Scroller$ + " COMP, PENGUIN AND THE SMOKESHACK.    THIS YEAR 2014"
Scroller$ = Scroller$ + " IS BROUGHT TO YOU BY HEROIC APPAREL, LEATT,"
Scroller$ = Scroller$ + " BRIDGESTONE AND VORTEX.    THEY'LL BE HELPING ME DO"
Scroller$ = Scroller$ + " BATTLE IN LRRS AT NHMS, CONTESTING AM ULSB ON MY"
Scroller$ = Scroller$ + " FZR400RR SP.    TO MIX THINGS UP I'LL"
Scroller$ = Scroller$ + " ALSO BE TRYING TO HOLD MY OWN IN NEMM AT BOXSHOP IN THE"
Scroller$ = Scroller$ + " AIR COOLED CLASS ON A TTR125.    IT'S TIME TO GEAR UP"
Scroller$ = Scroller$ + " AND HIT THE TRACK, LET'S BANG SOME BARS!                           "
Scroller$ = Scroller$ + "                                                                    "

'Scroller$ = "                                                              "
'Scroller$ = Scroller$ + "WINTER IS OVER, IT'S TIME TO RACE!   771 CORDIALLY INVITES YOU TO"
'Scroller$ = Scroller$ + " PUT YOUR SHOVELS AWAY, TRADE YOUR PARKA FOR"
'Scroller$ = Scroller$ + " LEATHERS AND DUST OFF YOUR BIKE FOR FUN TIME AT THE"
'Scroller$ = Scroller$ + " TRACK.   SPRING MEANS RACING RETURNS TO NEW ENGLAND"
'Scroller$ = Scroller$ + " FOR 2014.   THIS YEAR 771 IS BACKED BY TODD AND"
'Scroller$ = Scroller$ + " HEROIC RACING APPAREL, LEAT BRACES, BRIDGESTONE"
'Scroller$ = Scroller$ + " TIRES AND VORTEX RACING PARTS.   THE FZR400RR SP IS"
'Scroller$ = Scroller$ + " PREPPED AND READY TO RUMBLE AT NHMS, THE TTR 125 IS"
'Scroller$ = Scroller$ + " READY FOR BOXSHOP AND THE WR250Z IS READY FOR TRACK"
'Scroller$ = Scroller$ + " AND TRAIL.   ...   I'D LIKE TO GIVE A SHOUT OUT TO"
'Scroller$ = Scroller$ + " RSP, ECK, THE GANG FROM SEACOAST, DZIRCHER AND THE"
'Scroller$ = Scroller$ + " REST OF THE CENTER GARAGE NUTTERS WHO HELP MAKE THE"
'Scroller$ = Scroller$ + " TRACK A HOME.   ...   THANKS GO OUT TO PETER KATES OF"
'Scroller$ = Scroller$ + " GMD COMPUTRACK, STEVE AT SPEEDWERKS AND CHARLES"
'Scroller$ = Scroller$ + " SANDOZ AT SEACOAST FOR HELPING MAKE MY RETURN TO"
'Scroller$ = Scroller$ + " RACING LAST YEAR AWESOME AND MY PROSPECTS FOR 2014"
'Scroller$ = Scroller$ + " LOOKING BETTER AND BETTER!   ENOUGH CHIT CHAT, IT'S"
'Scroller$ = Scroller$ + " TIME TO RACE...                                                                                                                                                      "

' Ok, prep stuff prepped, start the show with splashy logos
StartMusic

gifload "771.BSV"
pal "slowfadein"

waitformusic 1, 1, 20
pal "fadetowhite"
gifload "HERO.BSV"

waitformusic 1, 1, 32
pal "fadefromwhite"

waitformusic 2, 4, 52
pal "fadetowhite"
gifload "LEATT.BSV"

waitformusic 3, 5, 0
pal "fadefromwhite"

waitformusic 4, 2, 20
pal "fadetowhite"
gifload "BSTONE.BSV"

waitformusic 4, 2, 32
pal "fadefromwhite"

waitformusic 5, 3, 52
pal "fadetowhite"
gifload "VORTEX.BSV"

waitformusic 6, 6, 0
pal "fadefromwhite"

waitformusic 7, 7, 32
pal "fadeout"

waitformusic 8, 8, 0
' Clear the screen, set the palette and prebuffer
' the scroller
CLS
PALETTE
MetalPal
ScrollerPos& = 800

' Scroller and 3D time
WAIT &H3DA, 8
PUT (1, 0), LeftBlock%, PSET
PUT (289, 0), Rightblock%, PSET
' We're done with the VU meters, free some memory
ERASE LeftBlock%
ERASE Rightblock%

' Prep blank buffers
GET (31, 0)-(288, 39), ScrollBlit%

' Primary loop

DO
'  WAIT &H3DA, 8
'  ClearScr

  ' Build the string and overall buffer length to cover the target
  WorkLen% = 0
  WorkPixel& = 0
  DO
	 WorkLen% = WorkLen% + 1
	 TargetOffset% = FontChars%(ASC(MID$(Scroller$, WorkLen%, 1)))
	 WorkPixel& = WorkPixel& + (font%(TargetOffset%) / 8) + 2
  LOOP UNTIL WorkPixel& > ScrollerPos&

  ScrollOffset% = 290 + (WorkPixel& MOD ScrollerPos&)
  FOR counter% = 2 TO 5161
	 ScrollBlit%(counter%) = 0
  NEXT counter%

  DO
	 TargetOffset% = FontChars%(ASC(MID$(Scroller$, WorkLen%, 1)))
	 'PUT ((ScrollOffset% - (font%(TargetOffset%) / 8)), 1), font%(TargetOffset%), PSET
	 glyphWidth% = font%(TargetOffset%) / 8
	 glyphHeight% = font%(TargetOffset% + 1)
	 FOR glyphCol% = 0 TO glyphWidth% - 1
		BlitOffset% = (ScrollOffset% + glyphCol%) - glyphWidth%
		BlitOffset2% = BlitOffset% - 31
		IF (BlitOffset% > 31) AND (BlitOffset% < 288) THEN
		  DEF SEG = VARSEG(font%(TargetOffset%))
		  FOR glyphRow% = 0 TO glyphHeight% - 1
			 RowBlit%(glyphRow%) = PEEK(VARPTR(font%(TargetOffset% + 2)) + glyphCol% + (glyphWidth% * glyphRow%))
		  NEXT glyphRow%
		  DEF SEG = VARSEG(ScrollBlit%(0))
		  FOR glyphRow% = 0 TO glyphHeight% - 1
			 POKE VARPTR(ScrollBlit%(2)) + BlitOffset2% + (258 * (glyphRow% + sineWave%(BlitOffset%))), RowBlit%(glyphRow%)
		  NEXT glyphRow%
		  DEF SEG
		END IF
	 NEXT glyphCol%
	 ScrollOffset% = ScrollOffset% - (glyphWidth% + 2)
	 WorkLen% = WorkLen% - 1
  LOOP UNTIL ScrollOffset% < 30
  'WAIT &H3DA, 8
  PUT (31, 159), ScrollBlit%, PSET
  
  ' VU Meters, muck with the palette based on volume
  GetMainScope LeftVU&, RightVU&
  LeftVUDetail% = (LeftVU& - 30000) / 100
  IF LeftVUDetail% < 0 THEN LeftVUDetail% = 0
  LeftVUScaled% = LeftVUDetail% / 10
  RightVUDetail% = (RightVU& - 30000) / 100
  RightVUScaled% = RightVUDetail% / 10
  FOR counter% = 1 TO 10
	 IF LeftVUScaled% > counter% THEN
		IF LeftVUSDetail% MOD (counter% * 10) THEN
		  OUT &H3C8, counter% + 88
		  OUT &H3C9, (LeftVUDetail% MOD (counter% * 10)) * 6
		  OUT &H3C9, 0: OUT &H3C9, 0
		ELSE
		  OUT &H3C8, counter% + 88
		  OUT &H3C9, 63: OUT &H3C9, 0: OUT &H3C9, 0
		END IF
	 ELSE
		OUT &H3C8, counter% + 88
		OUT &H3C9, 0: OUT &H3C9, 0: OUT &H3C9, 0
	 END IF
	 IF RightVUScaled% > counter% THEN
		IF RightVUDetail% MOD (counter% * 10) THEN
		  OUT &H3C8, counter% + 99
		  OUT &H3C9, (RightVUDetail% MOD (counter% * 10)) * 6
		  OUT &H3C9, 0: OUT &H3C9, 0
		ELSE
		  OUT &H3C8, counter% + 99
		  OUT &H3C9, 63: OUT &H3C9, 0: OUT &H3C9, 0
		END IF
	 ELSE
		OUT &H3C8, counter% + 99
		OUT &H3C9, 0: OUT &H3C9, 0: OUT &H3C9, 0
	 END IF
  NEXT counter%

  Thetax% = (Thetax% + 1) MOD 360
  Thetay% = (Thetay% + 1) MOD 360
  Thetaz% = (Thetaz% + 1) MOD 360
  RotateAndProject Model(), Thetax%, Thetay%, Thetaz%
  DrawModel2 Model(), DemoPoly()

  ' ScreenMod "TestDots"
  ScreenModMode% = MusicOrder(&HFF)
  IF ScreenModMode% MOD 2 THEN
	 ScreenMod "down"
  ELSE
	 ScreenMod "decay"
  END IF

  G$ = INKEY$
  ' Advance the scroller
  ScrollerPos& = ScrollerPos& + 3
  SineRoll& = SineRoll& + 2
  UpdateSine (SineRoll&)

LOOP UNTIL LEN(G$) OR MusicOrder(&HFF) = 41

pal "fadetowhite"
gifload "LRRS.BSV"
pal "fadefromwhite"

waitformusic 41, 29, 52
pal "fadetowhite"
gifload "NEMM.BSV"

waitformusic 42, 30, 0
pal "fadefromwhite"

waitformusic 42, 30, 52
pal "fadetowhite"
gifload "771PIC2.BSV"

waitformusic 43, 31, 0
pal "fadefromwhite"


waitformusic 43, 31, 62
StopMusic
pal "greyscale"
SLEEP 4
pal "fadeout"

SCREEN 0
WIDTH 80
CLS
PRINT
PRINT "                     --===[ 2014 771 RACING INVITE ]===--"
PRINT
PRINT " -=[ Music:        Point of Departure by Necros"
PRINT " -=[ Sound Module: BWSB"
PRINT " -=[ 3D Engine:    Modified from Richard Eric M. Lope's work"
PRINT " -=[ Prog Lang:    QuickBasic 7.1 PDS"
PRINT
PRINT " This has been run on a Dell Dimension 4500 dumping it's video out to a"
PRINT " Hauppauge WinTV USB via S-Video for capture on a second system.  Many"
PRINT " computers were harmed in the making of this project."
PRINT
PRINT " -=[ Heroic Racing Apparel - http://www.heroicracing.com"
PRINT " -=[ Leatt                 - http://www.leatt.com"
PRINT " -=[ Bridgestone           - http://www.bridgestone.com"
PRINT " -=[ Vortex                - http://www.vortexracing.com"
PRINT
PRINT " -=[ LRRS                  - http://www.nhms.com/events/lrrs"
PRINT " -=[ NEMM                  - http://nhf-racing.com/nemm.html"
PRINT
PRINT " -=[ 771 Racing            - http://www.facebook.com/771Racing"
PRINT " -=[                         josh.coombs@gmail.com"
SLEEP 5
StopOutput
UnloadModule
FreeMSE
END

SUB ClearScr
  ' ASM Screen Clear
  STATIC initalised%
  IF NOT initalised% THEN
	 initialised% = -1
	 ASM$ = CHR$(&HB8) + CHR$(&H0) + CHR$(&HA0) + CHR$(&H8E)
	 ASM$ = ASM$ + CHR$(&HC0) + CHR$(&H31) + CHR$(&HFF) + CHR$(&HB9)
	 ASM$ = ASM$ + CHR$(&H0) + CHR$(&HFA) + CHR$(&H30) + CHR$(&HC0)
	 ASM$ = ASM$ + CHR$(&HF3) + CHR$(&HAA) + CHR$(&HCB)
  END IF

  DEF SEG = VARSEG(ASM$)
	 CALL ABSOLUTE(SADD(ASM$))
  DEF SEG
  LOCATE 1, 1
END SUB

SUB DrawModel2 (Model() AS Point3d, Tri() AS PolyType2) STATIC
  FOR I = 0 TO 29
	 x1 = Model(Tri(I).p1).scrx
	 x2 = Model(Tri(I).p2).scrx
	 y1 = Model(Tri(I).p1).scry
	 y2 = Model(Tri(I).p2).scry
	 LINE (x1, y1)-(x2, y2), 192
  NEXT I
END SUB

SUB gifload (bsvfile$)
  DEF SEG = &HA000 ' Start of screen memory
  BLOAD bsvfile$
  FOR colour% = 0 TO 255 'End of the binary is the palette, put it into
			 'the shared array
	 red(colour%) = PEEK(64000 + (colour% * 3))
	 grn(colour%) = PEEK(64001 + (colour% * 3))
	 blu(colour%) = PEEK(64002 + (colour% * 3))
  NEXT
  DEF SEG
END SUB

SUB LoadPoly (Model() AS Point3d, Tri() AS PolyType2, Scale!)
 REDIM Model(25) AS Point3d
 RESTORE DemoPoly
 FOR I = 0 TO 25
	READ x, y, z
	Model(I).x = x * Scale!
	Model(I).y = y * Scale!
	Model(I).z = z * Scale!
 NEXT I

 REDIM Tri(29) AS PolyType2
 FOR I = 0 TO 29
	READ p1, p2
	Tri(I).p1 = p1
	Tri(I).p2 = p2
 NEXT I
END SUB

SUB MetalPal
' Setup palette to match font
  FOR x% = 0 TO 63
	 OUT &H3C8, x%
	 OUT &H3C9, x%
	 OUT &H3C9, x%
	 OUT &H3C9, x%
  NEXT x%

  FOR x% = 1 TO 8
	 OUT &H3C8, (x% + 63)
	 OUT &H3C9, (x% * 8) - 1
	 OUT &H3C9, 0
	 OUT &H3C9, 0

	 OUT &H3C8, (x% + 71)
	 OUT &H3C9, 0
	 OUT &H3C9, (x% * 8) - 1
	 OUT &H3C9, 0

	 OUT &H3C8, (x% + 79)
	 OUT &H3C9, 0
	 OUT &H3C9, 0
	 OUT &H3C9, (x% * 8) - 1
  NEXT x%

  FOR x% = 1 TO 10
	 OUT &H3C8, (x% + 88)
	 OUT &H3C9, (x% * 6)
	 OUT &H3C9, 0
	 OUT &H3C9, 0
  NEXT x%

  FOR x% = 1 TO 10
	 OUT &H3C8, (x% + 99)
	 OUT &H3C9, (x% * 6)
	 OUT &H3C9, 0
	 OUT &H3C9, 0
  NEXT x%

  ' Setup black buffers around ScreenMod's color zone
  FOR x% = 120 TO 203
	 OUT &H3C8, x%
	 OUT &H3C9, 0
	 OUT &H3C9, 0
	 OUT &H3C9, 0
  NEXT x%

  ' Setup grayscale color gradient for ScreenMod
  FOR x% = 0 TO 63
	 OUT &H3C8, x% + 128
	 OUT &H3C9, x%
	 OUT &H3C9, x%
	 OUT &H3C9, x%
  NEXT x%

  OUT &H3C8, 192
  OUT &H3C9, 55
  OUT &H3C9, 45
  OUT &H3C9, 0

END SUB

SUB pal (act$)
	SELECT CASE act$
	' "save","fadein","fadeout","restore","blackout"
		CASE "save"
	 FOR colour% = 0 TO 255
		 OUT &H3C7, colour%          ' Set color to read
		 red(colour%) = INP(&H3C9)   ' read red value
		 grn(colour%) = INP(&H3C9)   ' read green value
		 blu(colour%) = INP(&H3C9)   ' read blue value
	 NEXT
		CASE "fadein"
	 DO
		 done% = 0
		 FOR colour% = 0 TO 255
			 OUT &H3C7, colour%       ' Set color to read
			 red% = INP(&H3C9)        ' read red value
			 grn% = INP(&H3C9)        ' read green value
			 blu% = INP(&H3C9)        ' read blue value
			 ' Test the color values, decrementing if necessary.
			 ' Set loop variable if saved palette not in use.
			 IF red% < red(colour%) THEN red% = red% + 1: done% = 1
			 IF grn% < grn(colour%) THEN grn% = grn% + 1: done% = 1
			 IF blu% < blu(colour%) THEN blu% = blu% + 1: done% = 1
			 WAIT &H3DA, 8
			 OUT &H3C8, colour%       ' Set color to write
			 OUT &H3C9, red%          ' write red value
			 OUT &H3C9, grn%          ' write green value
			 OUT &H3C9, blu%          ' write blue value
		 NEXT
	 LOOP WHILE done% <> 0
		CASE "slowfadein"
		DO
		  done% = 0
		  FOR colour% = 0 TO 255
			 OUT &H3C7, colour%
			 red% = INP(&H3C9)
			 grn% = INP(&H3C9)
			 blu% = INP(&H3C9)
			 IF red% < red(colour%) THEN red% = red% + 1: done% = 1
			 IF grn% < grn(colour%) THEN grn% = grn% + 1: done% = 1
			 IF blu% < blu(colour%) THEN blu% = blu% + 1: done% = 1
			 WAIT &H3DA, 8
			 OUT &H3C8, colour%
			 OUT &H3C9, red%
			 OUT &H3C9, grn%
			 OUT &H3C9, blu%
			 FOR counter& = 1 TO 100
			 NEXT counter&
		  NEXT colour%
		LOOP WHILE done% <> 0
		CASE "fadefromwhite"
	 DO
		 done% = 0
		 FOR colour% = 0 TO 255
			 OUT &H3C7, colour%       ' Set color to read
			 red% = INP(&H3C9)        ' read red value
			 grn% = INP(&H3C9)        ' read green value
			 blu% = INP(&H3C9)        ' read blue value
			 ' Test the color values, decrementing if necessary.
			 ' Set loop variable if saved palette not in use.
			 IF red% > red(colour%) THEN red% = red% - 1: done% = 1
			 IF grn% > grn(colour%) THEN grn% = grn% - 1: done% = 1
			 IF blu% > blu(colour%) THEN blu% = blu% - 1: done% = 1
			 WAIT &H3DA, 8
			 OUT &H3C8, colour%       ' Set color to write
			 OUT &H3C9, red%          ' write red value
			 OUT &H3C9, grn%          ' write green value
			 OUT &H3C9, blu%          ' write blue value
		 NEXT
	 LOOP WHILE done% <> 0
		CASE "fadeout"
	 DO
		 visible% = 0
		 FOR colour% = 0 TO 255
			 OUT &H3C7, colour%       ' Set color to read
			 red% = INP(&H3C9)        ' read red value
			 grn% = INP(&H3C9)        ' read green value
			 blu% = INP(&H3C9)        ' read blue value
			 ' Test the color values, decrementing if necessary.
			 ' Set loop variable if colors are still visible.
			 IF red% > 0 THEN red% = red% - 1: visible% = 1
			 IF grn% > 0 THEN grn% = grn% - 1: visible% = 1
			 IF blu% > 0 THEN blu% = blu% - 1: visible% = 1
			 WAIT &H3DA, 8
			 OUT &H3C8, colour%       ' Set color to write
			 OUT &H3C9, red%          ' write red value
			 OUT &H3C9, grn%          ' write green value
			 OUT &H3C9, blu%          ' write blue value
		 NEXT
	 LOOP WHILE visible% <> 0
		CASE "fadetowhite"
	 DO
		 visible% = 0
		 FOR colour% = 0 TO 255
			 OUT &H3C7, colour%       ' Set color to read
			 red% = INP(&H3C9)        ' read red value
			 grn% = INP(&H3C9)        ' read green value
			 blu% = INP(&H3C9)        ' read blue value
			 ' Test the color values, incrementing if necessary.
			 ' Set loop variable if colors are still visible.
			 IF red% < 63 THEN red% = red% + 1: visible% = 1
			 IF grn% < 63 THEN grn% = grn% + 1: visible% = 1
			 IF blu% < 63 THEN blu% = blu% + 1: visible% = 1
			 WAIT &H3DA, 8
			 OUT &H3C8, colour%       ' Set color to write
			 OUT &H3C9, red%          ' write red value
			 OUT &H3C9, grn%          ' write green value
			 OUT &H3C9, blu%          ' write blue value
		 NEXT
	 LOOP WHILE visible% <> 0
		CASE "restore"
	 FOR colour% = 0 TO 255
		 OUT &H3C8, colour%          ' Set color to write
		 OUT &H3C9, red(colour%)     ' write red value
		 OUT &H3C9, grn(colour%)     ' write green value
		 OUT &H3C9, blu(colour%)     ' write blue value
	 NEXT
		CASE "blackout"
	 FOR colour% = 0 TO 255
		 OUT &H3C8, colour%          ' Set color to write
		 OUT &H3C9, 0                ' write red value
		 OUT &H3C9, 0                ' write green value
		 OUT &H3C9, 0                ' write blue value
	 NEXT
		CASE "greyscale"
		' Fade from color to 63 shades of grey...
		DO
		 done% = 0
		 FOR colour% = 0 TO 255
			 OUT &H3C7, colour%
			 red% = INP(&H3C9)
			 grn% = INP(&H3C9)
			 blu% = INP(&H3C9)
			 targetgrey%(colour%) = INT((red% + grn% + blu%) / 3)
			 'IF targetgrey%(colour%) > 63 THEN targetgrey%(colour%) = 63
			 'IF targetgrey%(colour%) < 0 THEN targetgrey%(colour%) = 0
		 NEXT colour%
		 FOR colour% = 0 TO 255
			 OUT &H3C7, colour%
			 red% = INP(&H3C9)
			 grn% = INP(&H3C9)
			 blu% = INP(&H3C9)
			 IF red% < targetgrey%(colour%) THEN red% = red% + 1: done% = 1
			 IF red% > targetgrey%(colour%) THEN red% = red% - 1: done% = 1
			 IF grn% < targetgrey%(colour%) THEN grn% = grn% + 1: done% = 1
			 IF grn% > targetgrey%(colour%) THEN grn% = grn% - 1: done% = 1
			 IF blu% < targetgrey%(colour%) THEN blu% = blu% + 1: done% = 1
			 IF blu% > targetgrey%(colour%) THEN blu% = blu% - 1: done% = 1
			 WAIT &H3DA, 8, 8
			 OUT &H3C8, colour%
			 OUT &H3C9, red%
			 OUT &H3C9, grn%
			 OUT &H3C9, blu%
			 FOR counter& = 1 TO 1000
			 NEXT
		  NEXT
		LOOP WHILE done% <> 0
	END SELECT
END SUB

SUB RotateAndProject (Model() AS Point3d, AngleX%, AngleY%, AngleZ%) STATIC
''Right handed system
''when camera components increase:
''x=goes left
''y=goes down
''z=goes into the screen

' so when increased:
'x =right
'y=up
'z=into you

'          y
'         |
'         |
'         |
'         0-- -- -- you
'        /        x
'      /
'    /  z
'  \/

'''rotation: counter-clockwise of each axis
''ei.  make yourself perpenicular to the axis
''wave your hand from the center of your body to the left.
''That's how it rotates. ;*)


'convert degrees to radians
ax! = AngleX% * PI / 180
ay! = AngleY% * PI / 180
az! = AngleZ% * PI / 180

'Precalculate the SIN and COS of each angle
cx! = COS(ax!)
sx! = SIN(ax!)
cy! = COS(ay!)
sy! = SIN(ay!)
cz! = COS(az!)
sz! = SIN(az!)

'''After2 hours of work, I was able to weed out the constants from
'''Rotate and project N to reduce my muls to 9 instead of 12. woot!!!!

xx! = cy! * cz!
xy! = sx! * sy! * cz! - cx! * sz!
xz! = cx! * sy! * cz! + sx! * sz!

yx! = cy! * sz!
yy! = cx! * cz! + sx! * sy! * sz!
yz! = -sx! * cz! + cx! * sy! * sz!

zx! = -sy!
zy! = sx! * cy!
zz! = cx! * cy!

FOR I = 0 TO UBOUND(Model)

		  x! = Model(I).x
		  y! = Model(I).y
		  z! = Model(I).z

		  RotX! = (x! * xx! + y! * xy! + z! * xz!) - camx%
		  RotY! = (x! * yx! + y! * yy! + z! * yz!) - camy%
		  RotZ! = (x! * zx! + y! * zy! + z! * zz!) - camz%

		  Model(I).xr = RotX!
		  Model(I).yr = RotY!
		  Model(I).zr = RotZ!

		  'Project
		  Distance% = (LENS - RotZ!)
		  IF Distance% > 0 THEN
				Model(I).scrx = (LENS * RotX! / Distance%) + XCENTER
				Model(I).scry = -(LENS * RotY! / Distance%) + YCENTER
		  ELSE
		  END IF
NEXT I

END SUB

SUB ScreenMod (act$)
' Various per-pixel effects to the primary display area.  Poor man's pixel
' shaders.  Not enough RAM to buffer this all in one step unfortunately.
'
' Colors 120 through 204 are used by this routine.  120 through 127 and 196
' through 203 are black to allow for sloppy math without time sucking bounds
' checking.

SELECT CASE act$
  ' Fades out any pixels over time
  CASE "decay"
  DEF SEG = &HA000
  FOR x% = 33 TO 287
	 FOR y% = 2 TO 157
		TargetOffset& = x% + (y% * 320)
		pixel% = PEEK(TargetOffset&)
		IF pixel% > 126 THEN
		  POKE (TargetOffset&), pixel% - 3
		END IF
	 NEXT y%
  NEXT x%
  DEF SEG

  ' Smear down
  CASE "down"
  DEF SEG = &HA000
  FOR x% = 33 TO 287
	 FOR y% = 156 TO 1 STEP -1
		TargetOffset& = x% + (y% * 320)
		pixel% = PEEK(TargetOffset&)
		IF pixel% > 126 THEN
		  POKE (TargetOffset& + 320), pixel% - 3
		  POKE (TargetOffset&), 129
		END IF
	 NEXT y%
  NEXT x%
  DEF SEG

  ' Only for testing, plots 10 random dots in the work area to test
  ' the shaders.
  CASE "TestDots"
  FOR counter% = 1 TO 10
	 x% = (RND * 254) + 33
	 y% = (RND * 155) + 2
	 PSET (x%, y%), 195
  NEXT counter%
END SELECT
END SUB

SUB TrueBlack
  FOR x% = 0 TO 320
	 FOR y% = 0 TO 200
		target% = POINT(x%, y%)
	IF target% < 4 THEN
	  PSET (x%, y%), 0
	END IF
	 NEXT y%
  NEXT x%
END SUB

SUB UpdateSine (SineRoll&)

FOR x% = 0 TO 320
  sineWave%(x%) = (4 * SIN((x% + SineRoll&) / 20)) + 4
NEXT x%

END SUB

SUB waitformusic (order%, pattern%, row%)
  DO
	 curorder% = MusicOrder(&HFF)
	 curpattern% = MusicPattern(&HFF)
	 currow% = MusicRow
  LOOP UNTIL (curorder% = order%) AND (curpattern% = pattern%) AND (currow% = row%)
END SUB

