
// ------------------------------------------------------------------------------------------------
//    JSphere.cpp - JellySphere code. 
//    Copyright  2001. Remage / Fresh!mindworkz.
// ------------------------------------------------------------------------------------------------

// " We are one brain. Grown(?) within. We are one brain. We are one. "
// " Human brain. Universe within. One-hundred-billion neuron. Each neuron ... electic meanings. "
// ( Etnica :: Trip Tonight Remix )

#include <Windows.h>
#include <D3D8.h>

#include "Main.h"
#include "Fmath.h"
#include "TxGen.h"
#include "D3DU8.h"

extern int ExportTGA;

// --- VertexBuffer.

#define D3DFVF_JSPHERE_VERTEX1 (D3DFVF_XYZB1|D3DFVF_NORMAL|D3DFVF_TEX1|D3DFVF_TEXTUREFORMAT2(0))
typedef struct _JSPHERE_VERTEX1
  {
    D3DVECTOR Vertex;
    FLOAT MatrixWeight1;
    D3DVECTOR Normal;
    FLOAT TexU, TexV;
   } JSPHERE_VERTEX1;

#define D3DFVF_JSPHERE_VERTEX2 (D3DFVF_XYZ|D3DFVF_NORMAL|D3DFVF_TEX1|D3DFVF_TEXTUREFORMAT2(0))
typedef struct _JSPHERE_VERTEX2
  {
    D3DVECTOR Vertex;
    D3DVECTOR Normal;
    FLOAT TexU, TexV;
   } JSPHERE_VERTEX2;

extern D3DMATRIX MetaBalls_TextureMatrix0;

static TXGEN_LAYER *TxLayer1, *TxLayer2;

// ------------------------------------------------------------------------------------------------

LPDIRECT3DVERTEXBUFFER8 JSphere_VertexBuffer1 = NULL, JSphere_VertexBuffer2 = NULL;
LPDIRECT3DINDEXBUFFER8 JSphere_IndexBuffer1 = NULL, JSphere_IndexBuffer2 = NULL, JSphere_IndexBuffer3 = NULL;

int JSphere_VertexIdx1 = 24, JSphere_IndexIdx1 = 24, JSphere_IndexIdx3 = 48;

WORD *JSphere_LockedIndexBuffer1, *JSphere_LockedIndexBuffer2, *JSphere_LockedIndexBuffer3;
JSPHERE_VERTEX1 *JSphere_LockedVertexBuffer1, JSphere_ConstVertex1[24] = {
  {{ 0.09f, 1.09f, 0.09f }, 1.0f, { 0.0f, 1.0f, 0.0f }, 0.0f, 1.0f },
  {{ 0.09f, 0.09f, 1.09f }, 1.0f, { 0.0f, 0.0f, 1.0f }, 0.0f, 0.0f },
  {{ 1.09f, 0.09f, 0.09f }, 1.0f, { 1.0f, 0.0f, 0.0f }, 1.0f, 0.0f },

  {{ 1.09f, 0.09f, -0.09f }, 1.0f, { 1.0f, 0.0f, 0.0f }, 1.0f, 0.0f },
  {{ 0.09f, 0.09f, -1.09f }, 1.0f, { 0.0f, 0.0f, -1.0f }, 0.0f, 0.0f },
  {{ 0.09f, 1.09f, -0.09f }, 1.0f, { 0.0f, 1.0f, 0.0f }, 0.0f, 1.0f },

  {{ 1.09f, -0.09f, 0.09f }, 1.0f, { 1.0f, 0.0f, 0.0f }, 1.0f, 0.0f },
  {{ 0.09f, -0.09f, 1.09f }, 1.0f, { 0.0f, 0.0f, 1.0f }, 0.0f, 0.0f },
  {{ 0.09f, -1.09f, 0.09f }, 1.0f, { 0.0f, -1.0f, 0.0f }, 0.0f, 1.0f },

  {{ 0.09f, -1.09f, -0.09f }, 1.0f, { 0.0f, -1.0f, 0.0f }, 0.0f, 1.0f },
  {{ 0.09f, -0.09f, -1.09f }, 1.0f, { 0.0f, 0.0f, -1.0f }, 0.0f, 0.0f },
  {{ 1.09f, -0.09f, -0.09f }, 1.0f, { 1.0f, 0.0f, 0.0f }, 1.0f, 0.0f },

  {{ -1.09f, 0.09f, 0.09f }, 1.0f, { -1.0f, 0.0f, 0.0f }, 1.0f, 0.0f },
  {{ -0.09f, 0.09f, 1.09f }, 1.0f, { 0.0f, 0.0f, 1.0f }, 0.0f, 0.0f },
  {{ -0.09f, 1.09f, 0.09f }, 1.0f, { 0.0f, 1.0f, 0.0f }, 0.0f, 1.0f }, 

  {{ -0.09f, 1.09f, -0.09f }, 1.0f, { 0.0f, 1.0f, 0.0f }, 0.0f, 1.0f },
  {{ -0.09f, 0.09f, -1.09f }, 1.0f, { 0.0f, 0.0f, -1.0f }, 0.0f, 0.0f },
  {{ -1.09f, 0.09f, -0.09f }, 1.0f, {- 1.0f, 0.0f, 0.0f }, 1.0f, 0.0f },

  {{ -0.09f, -1.09f, 0.09f }, 1.0f, { 0.0f, -1.0f, 0.0f }, 0.0f, 1.0f },
  {{ -0.09f, -0.09f, 1.09f }, 1.0f, { 0.0f, 0.0f, 1.0f }, 0.0f, 0.0f },
  {{ -1.09f, -0.09f, 0.09f }, 1.0f, { -1.0f, 0.0f, 0.0f }, 1.0f, 0.0f },

  {{ -0.09f, -0.09f, -1.09f }, 1.0f, { 0.0f, 0.0f, -1.0f }, 0.0f, 0.0f },
  {{ -0.09f, -1.09f, -0.09f }, 1.0f, { 0.0f, -1.0f, 0.0f }, 0.0f, 1.0f },
  {{ -1.09f, -0.09f, -0.09f }, 1.0f, { -1.0f, 0.0f, 0.0f }, 1.0f, 0.0f }};

int JSphere_VertexIdx2 = 24, JSphere_IndexIdx2;

JSPHERE_VERTEX2 *JSphere_LockedVertexBuffer2, JSphere_ConstVertex2[] = {
/*
  {{ 0.07f, 0.07f, 1.02f }, { 0.06665f, 0.06665f, 0.97124f }, 0.0f, 0.0f },
  {{ 0.07f, -0.07f, 1.02f }, { 0.06665f, -0.06665f, 0.97124f }, 0.0f, 0.1f },
  {{ -0.07f, 0.07f, 1.02f }, { -0.06665f, 0.06665f, 0.97124f }, 0.1f, 0.0f },
  {{ -0.07f, -0.07f, 1.02f }, { -0.06665f, -0.06665f, 0.97124f }, 0.1f, 0.1f },

  {{ 0.07f, 0.07f, -1.02f }, { 0.06665f, 0.06665f, -0.97124f }, 0.0f, 0.0f },
  {{ -0.07f, 0.07f, -1.02f }, { -0.06665f, 0.06665f, -0.97124f }, 0.1f, 0.0f },
  {{ 0.07f, -0.07f, -1.02f }, { 0.06665f, -0.06665f, -0.97124f }, 0.0f, 0.1f },
  {{ -0.07f, -0.07f, -1.02f }, { -0.06665f, -0.06665f, -0.97124f }, 0.1f, 0.1f },

  {{ 0.07f, 1.02f, 0.07f }, { 0.06665f, 0.97124f, 0.06665f }, 0.0f, 0.0f },
  {{ -0.07f, 1.02f, 0.07f }, { -0.06665f, 0.97124f, 0.06665f }, 0.1f, 0.0f },
  {{ 0.07f, 1.02f, -0.07f }, { 0.06665f, 0.97124f, -0.06665f }, 0.0f, 0.1f },
  {{ -0.07f, 1.02f, -0.07f }, { -0.06665f, 0.97124f, -0.06665f }, 0.1f, 0.1f },

  {{ 0.07f, -1.02f, 0.07f }, { 0.06665f, -0.97124f, 0.06665f }, 0.0f, 0.0f },
  {{ 0.07f, -1.02f, -0.07f }, { 0.06665f, -0.97124f, -0.06665f }, 0.0f, 0.1f },
  {{ -0.07f, -1.02f, 0.07f }, { -0.06665f, -0.97124f, 0.06665f }, 0.1f, 0.0f },
  {{ -0.07f, -1.02f, -0.07f }, { -0.06665f, -0.97124f, -0.06665f }, 0.1f, 0.1f },

  {{ 1.02f, 0.07f, 0.07f }, { 0.97124f, 0.06665f, 0.06665f }, 0.0f, 0.0f },
  {{ 1.02f, 0.07f, -0.07f }, { 0.97124f, 0.06665f, -0.06665f }, 0.0f, 0.1f },
  {{ 1.02f, -0.07f, 0.07f }, { 0.97124f, -0.06665f, 0.06665f }, 0.1f, 0.0f },
  {{ 1.02f, -0.07f, -0.07f }, { 0.97124f, -0.06665f, -0.06665f }, 0.1f, 0.1f },

  {{ -1.02f, 0.07f, 0.07f }, { -0.97124f, 0.06665f, 0.06665f }, 0.0f, 0.0f },
  {{ -1.02f, -0.07f, 0.07f }, { -0.97124f, -0.06665f, 0.06665f }, 0.1f, 0.0f },
  {{ -1.02f, 0.07f, -0.07f }, { -0.97124f, 0.06665f, -0.06665f }, 0.0f, 0.1f },
  {{ -1.02f, -0.07f, -0.07f }, { -0.97124f, -0.06665f, -0.06665f }, 0.1f, 0.1f }};
//*/
  {{ 0.09f, 0.09f, 1.09f }, { 0.06665f, 0.06665f, 0.97124f }, 0.0f, 0.0f },
  {{ 0.09f, -0.09f, 1.09f }, { 0.06665f, -0.06665f, 0.97124f }, 0.0f, 1.0f },
  {{ -0.09f, 0.09f, 1.09f }, { -0.06665f, 0.06665f, 0.97124f }, 1.0f, 0.0f },
  {{ -0.09f, -0.09f, 1.09f }, { -0.06665f, -0.06665f, 0.97124f }, 1.0f, 1.0f },

  {{ 0.09f, 0.09f, -1.09f }, { 0.06665f, 0.06665f, -0.97124f }, 0.0f, 0.0f },
  {{ -0.09f, 0.09f, -1.09f }, { -0.06665f, 0.06665f, -0.97124f }, 1.0f, 0.0f },
  {{ 0.09f, -0.09f, -1.09f }, { 0.06665f, -0.06665f, -0.97124f }, 0.0f, 1.0f },
  {{ -0.09f, -0.09f, -1.09f }, { -0.06665f, -0.06665f, -0.97124f }, 1.0f, 1.0f },

  {{ 0.09f, 1.09f, 0.09f }, { 0.06665f, 0.97124f, 0.06665f }, 0.0f, 0.0f },
  {{ -0.09f, 1.09f, 0.09f }, { -0.06665f, 0.97124f, 0.06665f }, 1.0f, 0.0f },
  {{ 0.09f, 1.09f, -0.09f }, { 0.06665f, 0.97124f, -0.06665f }, 0.0f, 1.0f },
  {{ -0.09f, 1.09f, -0.09f }, { -0.06665f, 0.97124f, -0.06665f }, 1.0f, 1.0f },

  {{ 0.09f, -1.09f, 0.09f }, { 0.06665f, -0.97124f, 0.06665f }, 0.0f, 0.0f },
  {{ 0.09f, -1.09f, -0.09f }, { 0.06665f, -0.97124f, -0.06665f }, 0.0f, 1.0f },
  {{ -0.09f, -1.09f, 0.09f }, { -0.06665f, -0.97124f, 0.06665f }, 1.0f, 0.0f },
  {{ -0.09f, -1.09f, -0.09f }, { -0.06665f, -0.97124f, -0.06665f }, 1.0f, 1.0f },

  {{ 1.09f, 0.09f, 0.09f }, { 0.97124f, 0.06665f, 0.06665f }, 0.0f, 0.0f },
  {{ 1.09f, 0.09f, -0.09f }, { 0.97124f, 0.06665f, -0.06665f }, 0.0f, 1.0f },
  {{ 1.09f, -0.09f, 0.09f }, { 0.97124f, -0.06665f, 0.06665f }, 1.0f, 0.0f },
  {{ 1.09f, -0.09f, -0.09f }, { 0.97124f, -0.06665f, -0.06665f }, 1.0f, 1.0f },

  {{ -1.09f, 0.09f, 0.09f }, { -0.97124f, 0.06665f, 0.06665f }, 0.0f, 0.0f },
  {{ -1.09f, -0.09f, 0.09f }, { -0.97124f, -0.06665f, 0.06665f }, 1.0f, 0.0f },
  {{ -1.09f, 0.09f, -0.09f }, { -0.97124f, 0.06665f, -0.06665f }, 0.0f, 1.0f },
  {{ -1.09f, -0.09f, -0.09f }, { -0.97124f, -0.06665f, -0.06665f }, 1.0f, 1.0f }};

// ---

D3DMATERIAL8 JSphere_Material1 = 
  {{ 1.0f, 1.0f, 1.0f, 0.0f }, { 1.0f, 1.0f, 1.0f, 0.0f }, { 0.0f, 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f, 0.0f }, 0.0f };

D3DLIGHT8 JSphere_Light1 =
  { D3DLIGHT_DIRECTIONAL, { 1.0f, 1.0f, 1.0f, 0.0f }, { 0.0f, 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f, 0.0f }, 
    { 0.0f, 0.0f, 0.0f }, { -2.8f, 1.2f, 3.8f }, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f }; 

LPDIRECT3DTEXTURE8 JSphere_Texture1 = NULL, JSphere_Texture2 = NULL, JSphere_Texture3 = NULL;

// ------------------------------------------------------------------------------------------------

float Max3( float F1, float F2, float F3 )
  {
    float Res = (F1>F2) ? F1 : F2;
    if ( F3>Res ) return F3;
    return Res;
   }

// ------------------------------------------------------------------------------------------------

D3DVECTOR *ModVec( D3DVECTOR *Vec, FLOAT Value )
  {
    if ( Vec->x != 0.0f ) Vec->x += ( Vec->x > 0.0f ) ? Value : -Value;
    if ( Vec->y != 0.0f ) Vec->y += ( Vec->y > 0.0f ) ? Value : -Value;
    if ( Vec->z != 0.0f ) Vec->z += ( Vec->z > 0.0f ) ? Value : -Value;
    return Vec;
   }

// ------------------------------------------------------------------------------------------------
//    JSphere_Tesselate1();
// ------------------------------------------------------------------------------------------------

void JSphere_Tesselate1( int Idx, int Level )
  {
    JSPHERE_VERTEX1 TempVertex;
    int Vertex0_Idx, Vertex1_Idx, Vertex2_Idx, TempIdx;
    float Len, Fl;

    if ( Level )
      {
        Vertex0_Idx = JSphere_LockedIndexBuffer1[ Idx+0 ];
        Vertex1_Idx = JSphere_LockedIndexBuffer1[ Idx+1 ];
        Vertex2_Idx = JSphere_LockedIndexBuffer1[ Idx+2 ];

        // --- Update IndexBuffer1.

        TempIdx = JSphere_IndexIdx1;

        JSphere_LockedIndexBuffer1[ JSphere_IndexIdx1++ ] = JSphere_VertexIdx1+1;
        JSphere_LockedIndexBuffer1[ JSphere_IndexIdx1++ ] = Vertex0_Idx;
        JSphere_LockedIndexBuffer1[ JSphere_IndexIdx1++ ] = JSphere_VertexIdx1+0;

        JSphere_LockedIndexBuffer1[ JSphere_IndexIdx1++ ] = JSphere_VertexIdx1+0;
        JSphere_LockedIndexBuffer1[ JSphere_IndexIdx1++ ] = Vertex1_Idx;
        JSphere_LockedIndexBuffer1[ JSphere_IndexIdx1++ ] = JSphere_VertexIdx1+2;

        JSphere_LockedIndexBuffer1[ JSphere_IndexIdx1++ ] = JSphere_VertexIdx1+2;
        JSphere_LockedIndexBuffer1[ JSphere_IndexIdx1++ ] = Vertex2_Idx;
        JSphere_LockedIndexBuffer1[ JSphere_IndexIdx1++ ] = JSphere_VertexIdx1+1;

        JSphere_LockedIndexBuffer1[ Idx+0 ] = JSphere_VertexIdx1+0;
        JSphere_LockedIndexBuffer1[ Idx+1 ] = JSphere_VertexIdx1+2;
        JSphere_LockedIndexBuffer1[ Idx+2 ] = JSphere_VertexIdx1+1;

        // --- Update IndexBuffer3.

        JSphere_LockedIndexBuffer3[ JSphere_IndexIdx3++ ] = JSphere_VertexIdx1+1;
        JSphere_LockedIndexBuffer3[ JSphere_IndexIdx3++ ] = Vertex0_Idx;
        JSphere_LockedIndexBuffer3[ JSphere_IndexIdx3++ ] = Vertex0_Idx;
        JSphere_LockedIndexBuffer3[ JSphere_IndexIdx3++ ] = JSphere_VertexIdx1+0;
        JSphere_LockedIndexBuffer3[ JSphere_IndexIdx3++ ] = JSphere_VertexIdx1+0;
        JSphere_LockedIndexBuffer3[ JSphere_IndexIdx3++ ] = JSphere_VertexIdx1+1;

        JSphere_LockedIndexBuffer3[ JSphere_IndexIdx3++ ] = JSphere_VertexIdx1+0;
        JSphere_LockedIndexBuffer3[ JSphere_IndexIdx3++ ] = Vertex1_Idx;
        JSphere_LockedIndexBuffer3[ JSphere_IndexIdx3++ ] = Vertex1_Idx;
        JSphere_LockedIndexBuffer3[ JSphere_IndexIdx3++ ] = JSphere_VertexIdx1+2;
        JSphere_LockedIndexBuffer3[ JSphere_IndexIdx3++ ] = JSphere_VertexIdx1+2;
        JSphere_LockedIndexBuffer3[ JSphere_IndexIdx3++ ] = JSphere_VertexIdx1+0;

        JSphere_LockedIndexBuffer3[ JSphere_IndexIdx3++ ] = JSphere_VertexIdx1+2;
        JSphere_LockedIndexBuffer3[ JSphere_IndexIdx3++ ] = Vertex2_Idx;
        JSphere_LockedIndexBuffer3[ JSphere_IndexIdx3++ ] = Vertex2_Idx;
        JSphere_LockedIndexBuffer3[ JSphere_IndexIdx3++ ] = JSphere_VertexIdx1+1;
        JSphere_LockedIndexBuffer3[ JSphere_IndexIdx3++ ] = JSphere_VertexIdx1+1;
        JSphere_LockedIndexBuffer3[ JSphere_IndexIdx3++ ] = JSphere_VertexIdx1+2;

        JSphere_LockedIndexBuffer3[ Idx*2+0 ] = JSphere_VertexIdx1+0;
        JSphere_LockedIndexBuffer3[ Idx*2+1 ] = JSphere_VertexIdx1+1;
        JSphere_LockedIndexBuffer3[ Idx*2+2 ] = JSphere_VertexIdx1+1;
        JSphere_LockedIndexBuffer3[ Idx*2+3 ] = JSphere_VertexIdx1+2;
        JSphere_LockedIndexBuffer3[ Idx*2+4 ] = JSphere_VertexIdx1+2;
        JSphere_LockedIndexBuffer3[ Idx*2+5 ] = JSphere_VertexIdx1+0;

        // --- Update VertexBuffer1.

        ModVec( &JSphere_LockedVertexBuffer1[ Vertex0_Idx ].Vertex, -0.089f );
        ModVec( &JSphere_LockedVertexBuffer1[ Vertex1_Idx ].Vertex, -0.089f );
        ModVec( &JSphere_LockedVertexBuffer1[ Vertex2_Idx ].Vertex, -0.089f );

        Len = D3DUVec3Length( &( JSphere_LockedVertexBuffer1[ Vertex0_Idx ].Vertex ));

        // --- New Vertex #0.

        D3DUVec3Add( &TempVertex.Vertex, &JSphere_LockedVertexBuffer1[ Vertex0_Idx ].Vertex, &JSphere_LockedVertexBuffer1[ Vertex1_Idx ].Vertex );
        D3DUVec3Normalize( &TempVertex.Vertex, &TempVertex.Vertex );
        D3DUVec3Scale( &TempVertex.Vertex, &TempVertex.Vertex, Len );
        Fl = 1.6f * (( Fabs( TempVertex.Vertex.x ) - 0.02f ) * ( Fabs( TempVertex.Vertex.y ) - 0.02f ) * ( Fabs( TempVertex.Vertex.z ) - 0.02f ));
        if ( Fl < 0.0f ) Fl = 0.0f;
        TempVertex.MatrixWeight1 = 1.0f - Fl;

        D3DUVec3Add( &TempVertex.Normal, &JSphere_LockedVertexBuffer1[ Vertex0_Idx ].Normal, &JSphere_LockedVertexBuffer1[ Vertex1_Idx ].Normal );
        D3DUVec3Normalize( &TempVertex.Normal, &TempVertex.Normal );
        TempVertex.TexU = ( JSphere_LockedVertexBuffer1[ Vertex0_Idx ].TexU + JSphere_LockedVertexBuffer1[ Vertex1_Idx ].TexU ) * 0.5f;
        TempVertex.TexV = ( JSphere_LockedVertexBuffer1[ Vertex0_Idx ].TexV + JSphere_LockedVertexBuffer1[ Vertex1_Idx ].TexV ) * 0.5f;

        ModVec( &TempVertex.Vertex, 0.089f );
        JSphere_LockedVertexBuffer1[ JSphere_VertexIdx1++ ] = TempVertex;

        // --- New Vertex #1.

        D3DUVec3Add( &TempVertex.Vertex, &JSphere_LockedVertexBuffer1[ Vertex0_Idx ].Vertex, &JSphere_LockedVertexBuffer1[ Vertex2_Idx ].Vertex );
        D3DUVec3Normalize( &TempVertex.Vertex, &TempVertex.Vertex );
        D3DUVec3Scale( &TempVertex.Vertex, &TempVertex.Vertex, Len );
        Fl = 1.6f * (( Fabs( TempVertex.Vertex.x ) - 0.02f ) * ( Fabs( TempVertex.Vertex.y ) - 0.02f ) * ( Fabs( TempVertex.Vertex.z ) - 0.02f ));
        if ( Fl < 0.0f ) Fl = 0.0f;
        TempVertex.MatrixWeight1 = 1.0f - Fl;

        D3DUVec3Add( &TempVertex.Normal, &JSphere_LockedVertexBuffer1[ Vertex0_Idx ].Normal, &JSphere_LockedVertexBuffer1[ Vertex2_Idx ].Normal );
        D3DUVec3Normalize( &TempVertex.Normal, &TempVertex.Normal );
        TempVertex.TexU = ( JSphere_LockedVertexBuffer1[ Vertex0_Idx ].TexU + JSphere_LockedVertexBuffer1[ Vertex2_Idx ].TexU ) * 0.5f;
        TempVertex.TexV = ( JSphere_LockedVertexBuffer1[ Vertex0_Idx ].TexV + JSphere_LockedVertexBuffer1[ Vertex2_Idx ].TexV ) * 0.5f;

        ModVec( &TempVertex.Vertex, 0.089f );
        JSphere_LockedVertexBuffer1[ JSphere_VertexIdx1++ ] = TempVertex;

        // --- New Vertex #2.

        D3DUVec3Add( &TempVertex.Vertex, &JSphere_LockedVertexBuffer1[ Vertex1_Idx ].Vertex, &JSphere_LockedVertexBuffer1[ Vertex2_Idx ].Vertex );
        D3DUVec3Normalize( &TempVertex.Vertex, &TempVertex.Vertex );
        D3DUVec3Scale( &TempVertex.Vertex, &TempVertex.Vertex, Len );
        Fl = 1.6f * (( Fabs( TempVertex.Vertex.x ) - 0.02f ) * ( Fabs( TempVertex.Vertex.y ) - 0.02f ) * ( Fabs( TempVertex.Vertex.z ) - 0.02f ));
        if ( Fl < 0.0f ) Fl = 0.0f;
        TempVertex.MatrixWeight1 = 1.0f - Fl;

        D3DUVec3Add( &TempVertex.Normal, &JSphere_LockedVertexBuffer1[ Vertex1_Idx ].Normal, &JSphere_LockedVertexBuffer1[ Vertex2_Idx ].Normal );
        D3DUVec3Normalize( &TempVertex.Normal, &TempVertex.Normal );
        TempVertex.TexU = ( JSphere_LockedVertexBuffer1[ Vertex1_Idx ].TexU + JSphere_LockedVertexBuffer1[ Vertex2_Idx ].TexU ) * 0.5f;
        TempVertex.TexV = ( JSphere_LockedVertexBuffer1[ Vertex1_Idx ].TexV + JSphere_LockedVertexBuffer1[ Vertex2_Idx ].TexV ) * 0.5f;

        ModVec( &TempVertex.Vertex, 0.089f );
        JSphere_LockedVertexBuffer1[ JSphere_VertexIdx1++ ] = TempVertex;

        ModVec( &JSphere_LockedVertexBuffer1[ Vertex0_Idx ].Vertex, 0.089f );
        ModVec( &JSphere_LockedVertexBuffer1[ Vertex1_Idx ].Vertex, 0.089f );
        ModVec( &JSphere_LockedVertexBuffer1[ Vertex2_Idx ].Vertex, 0.089f );

        // --- Recursive Tesselation.

        JSphere_Tesselate1( TempIdx+0, Level-1 );
        JSphere_Tesselate1( TempIdx+3, Level-1 );
        JSphere_Tesselate1( TempIdx+6, Level-1 );
        JSphere_Tesselate1( Idx, Level-1 );
       }
   } 

// ------------------------------------------------------------------------------------------------
//    JSphere_Tesselate2();
// ------------------------------------------------------------------------------------------------

void JSphere_Tesselate2( int Idx, int Level )
  {
    JSPHERE_VERTEX2 TempVertex;
    int Vertex0_Idx, Vertex1_Idx, Vertex2_Idx, Vertex3_Idx, TempIdx;
    float Len;

    if ( Level )
      {
        Vertex0_Idx = JSphere_LockedIndexBuffer2[ Idx+0 ];
        Vertex1_Idx = JSphere_LockedIndexBuffer2[ Idx+1 ];
        Vertex2_Idx = JSphere_LockedIndexBuffer2[ Idx+2 ];
        Vertex3_Idx = JSphere_LockedIndexBuffer2[ Idx+3 ];

        // --- Update IndexBuffer2.

        TempIdx = JSphere_IndexIdx2;

        JSphere_LockedIndexBuffer2[ JSphere_IndexIdx2++ ] = JSphere_VertexIdx2+0;
        JSphere_LockedIndexBuffer2[ JSphere_IndexIdx2++ ] = JSphere_VertexIdx2+1;
        JSphere_LockedIndexBuffer2[ JSphere_IndexIdx2++ ] = Vertex2_Idx;
        JSphere_LockedIndexBuffer2[ JSphere_IndexIdx2++ ] = Vertex3_Idx;
        JSphere_LockedIndexBuffer2[ JSphere_IndexIdx2++ ] = Vertex2_Idx;
        JSphere_LockedIndexBuffer2[ JSphere_IndexIdx2++ ] = JSphere_VertexIdx2+1;

        JSphere_LockedIndexBuffer2[ Idx+0 ] = Vertex0_Idx;  // Removable.
        JSphere_LockedIndexBuffer2[ Idx+1 ] = Vertex1_Idx;  // Removable.
        JSphere_LockedIndexBuffer2[ Idx+2 ] = JSphere_VertexIdx2+0;
        JSphere_LockedIndexBuffer2[ Idx+3 ] = JSphere_VertexIdx2+1;
        JSphere_LockedIndexBuffer2[ Idx+4 ] = JSphere_VertexIdx2+0;
        JSphere_LockedIndexBuffer2[ Idx+5 ] = Vertex1_Idx;  // Removable.

        // --- Update VertexBuffer2.
  
        ModVec( &JSphere_LockedVertexBuffer2[ Vertex0_Idx ].Vertex, -0.089f );
        ModVec( &JSphere_LockedVertexBuffer2[ Vertex1_Idx ].Vertex, -0.089f );
        ModVec( &JSphere_LockedVertexBuffer2[ Vertex2_Idx ].Vertex, -0.089f );
        ModVec( &JSphere_LockedVertexBuffer2[ Vertex3_Idx ].Vertex, -0.089f );

        Len = D3DUVec3Length( &( JSphere_LockedVertexBuffer2[ Vertex0_Idx ].Vertex ));

        // --- New Vertex #0.

        D3DUVec3Add( &TempVertex.Vertex, &JSphere_LockedVertexBuffer2[ Vertex0_Idx ].Vertex, &JSphere_LockedVertexBuffer2[ Vertex2_Idx ].Vertex );
        D3DUVec3Normalize( &TempVertex.Vertex, &TempVertex.Vertex );
        D3DUVec3Scale( &TempVertex.Vertex, &TempVertex.Vertex, Len );

        D3DUVec3Add( &TempVertex.Normal, &JSphere_LockedVertexBuffer2[ Vertex0_Idx ].Normal, &JSphere_LockedVertexBuffer2[ Vertex2_Idx ].Normal );
        D3DUVec3Normalize( &TempVertex.Normal, &TempVertex.Normal );
        TempVertex.TexU = ( JSphere_LockedVertexBuffer2[ Vertex0_Idx ].TexU + JSphere_LockedVertexBuffer2[ Vertex2_Idx ].TexU ) * 0.5f;
        TempVertex.TexV = ( JSphere_LockedVertexBuffer2[ Vertex0_Idx ].TexV + JSphere_LockedVertexBuffer2[ Vertex2_Idx ].TexV ) * 0.5f;

        ModVec( &TempVertex.Vertex, 0.089f );
        JSphere_LockedVertexBuffer2[ JSphere_VertexIdx2++ ] = TempVertex;

        // --- New Vertex #1.

        D3DUVec3Add( &TempVertex.Vertex, &JSphere_LockedVertexBuffer2[ Vertex1_Idx ].Vertex, &JSphere_LockedVertexBuffer2[ Vertex3_Idx ].Vertex );
        D3DUVec3Normalize( &TempVertex.Vertex, &TempVertex.Vertex );
        D3DUVec3Scale( &TempVertex.Vertex, &TempVertex.Vertex, Len );

        D3DUVec3Add( &TempVertex.Normal, &JSphere_LockedVertexBuffer2[ Vertex1_Idx ].Normal, &JSphere_LockedVertexBuffer2[ Vertex3_Idx ].Normal );
        D3DUVec3Normalize( &TempVertex.Normal, &TempVertex.Normal );
        TempVertex.TexU = ( JSphere_LockedVertexBuffer2[ Vertex1_Idx ].TexU + JSphere_LockedVertexBuffer2[ Vertex3_Idx ].TexU ) * 0.5f;
        TempVertex.TexV = ( JSphere_LockedVertexBuffer2[ Vertex1_Idx ].TexV + JSphere_LockedVertexBuffer2[ Vertex3_Idx ].TexV ) * 0.5f;

        ModVec( &TempVertex.Vertex, 0.089f );
        JSphere_LockedVertexBuffer2[ JSphere_VertexIdx2++ ] = TempVertex;

        ModVec( &JSphere_LockedVertexBuffer2[ Vertex0_Idx ].Vertex, 0.089f );
        ModVec( &JSphere_LockedVertexBuffer2[ Vertex1_Idx ].Vertex, 0.089f );
        ModVec( &JSphere_LockedVertexBuffer2[ Vertex2_Idx ].Vertex, 0.089f );
        ModVec( &JSphere_LockedVertexBuffer2[ Vertex3_Idx ].Vertex, 0.089f );

        // --- Recursive Tesselation.

        JSphere_Tesselate2( TempIdx, Level-1 );
        JSphere_Tesselate2( Idx, Level-1 );
       }
   }

// ------------------------------------------------------------------------------------------------
//    JSphere_Initialize();
// ------------------------------------------------------------------------------------------------

int JSphere_Initialize( void )
  {
    int I;

    // --- Create VertexBuffer1.
    if ( Direct3DDevice->CreateVertexBuffer( 2064 * sizeof( JSPHERE_VERTEX1 ), 0, D3DFVF_JSPHERE_VERTEX1, 
           D3DPOOL_DEFAULT, &JSphere_VertexBuffer1 ) != D3D_OK ) return 0;
    if ( JSphere_VertexBuffer1->Lock( 0, 2064 * sizeof( JSPHERE_VERTEX1 ), (BYTE**) &JSphere_LockedVertexBuffer1, 0 ) != D3D_OK ) return 0;

    // --- Create IndexBuffer1.
    if ( Direct3DDevice->CreateIndexBuffer( 6144 * sizeof( WORD ), 0, D3DFMT_INDEX16, 
      D3DPOOL_DEFAULT, &JSphere_IndexBuffer1 ) != D3D_OK ) return 0;
    if ( JSphere_IndexBuffer1->Lock( 0, 6144 * sizeof( WORD ), (BYTE**) &JSphere_LockedIndexBuffer1, 0 ) != D3D_OK ) return 0;

    // --- Create IndexBuffer3.
    if ( Direct3DDevice->CreateIndexBuffer( 12288 * sizeof( WORD ), 0, D3DFMT_INDEX16, 
      D3DPOOL_DEFAULT, &JSphere_IndexBuffer3 ) != D3D_OK ) return 0;
    if ( JSphere_IndexBuffer3->Lock( 0, 12288 * sizeof( WORD ), (BYTE**) &JSphere_LockedIndexBuffer3, 0 ) != D3D_OK ) return 0;

    for ( I=0; I<24; I++ )
      {
        JSphere_LockedVertexBuffer1[ I ] = JSphere_ConstVertex1[ I ];
        JSphere_LockedIndexBuffer1[ I ] = I;
       }

    for ( I=0; I<8; I++ )
      {
        JSphere_LockedIndexBuffer3[ I*6+0 ] = I*3+0;
        JSphere_LockedIndexBuffer3[ I*6+1 ] = I*3+1;
        JSphere_LockedIndexBuffer3[ I*6+2 ] = I*3+1;
        JSphere_LockedIndexBuffer3[ I*6+3 ] = I*3+2;
        JSphere_LockedIndexBuffer3[ I*6+4 ] = I*3+2;
        JSphere_LockedIndexBuffer3[ I*6+5 ] = I*3+0;
        JSphere_Tesselate1( I*3, 4 );
       }

    JSphere_IndexBuffer3->Unlock();
    JSphere_IndexBuffer1->Unlock();
    JSphere_VertexBuffer1->Unlock();

    // --- Create VertexBuffer2.
    if ( Direct3DDevice->CreateVertexBuffer( 384 * sizeof( JSPHERE_VERTEX2 ), 0, D3DFVF_JSPHERE_VERTEX2, 
      D3DPOOL_DEFAULT, &JSphere_VertexBuffer2 ) != D3D_OK ) return 0;
    if ( JSphere_VertexBuffer2->Lock( 0, 384 * sizeof( JSPHERE_VERTEX2 ), (BYTE**) &JSphere_LockedVertexBuffer2, 0 ) != D3D_OK ) return 0;
  
    // --- Create IndexBuffer2.
    if ( Direct3DDevice->CreateIndexBuffer( 1188 * sizeof( WORD ), 0, D3DFMT_INDEX16, 
      D3DPOOL_DEFAULT, &JSphere_IndexBuffer2 ) != D3D_OK ) return 0;
    if ( JSphere_IndexBuffer2->Lock( 0, 1188 * sizeof( WORD ), (BYTE**) &JSphere_LockedIndexBuffer2, 0 ) != D3D_OK ) return 0;

    for ( I=0; I<24; I++ )
      JSphere_LockedVertexBuffer2[ I ] = JSphere_ConstVertex2[ I ];

    for ( I=0; I<6; I++ )
      {
        JSphere_LockedIndexBuffer2[ I*6+0 ] = I*4+0;
        JSphere_LockedIndexBuffer2[ I*6+1 ] = I*4+2;
        JSphere_LockedIndexBuffer2[ I*6+2 ] = I*4+1;
        JSphere_LockedIndexBuffer2[ I*6+3 ] = I*4+1;
        JSphere_LockedIndexBuffer2[ I*6+4 ] = I*4+2;
        JSphere_LockedIndexBuffer2[ I*6+5 ] = I*4+3;
       }

    JSphere_LockedIndexBuffer2[ 36 ] = 2;
    JSphere_LockedIndexBuffer2[ 37 ] = 0;
    JSphere_LockedIndexBuffer2[ 38 ] = 9;
    JSphere_LockedIndexBuffer2[ 39 ] = 8;
    JSphere_LockedIndexBuffer2[ 40 ] = 9;
    JSphere_LockedIndexBuffer2[ 41 ] = 0;

    JSphere_LockedIndexBuffer2[ 42 ] = 3;
    JSphere_LockedIndexBuffer2[ 43 ] = 2;
    JSphere_LockedIndexBuffer2[ 44 ] = 21;
    JSphere_LockedIndexBuffer2[ 45 ] = 20;
    JSphere_LockedIndexBuffer2[ 46 ] = 21;
    JSphere_LockedIndexBuffer2[ 47 ] = 2;

    JSphere_LockedIndexBuffer2[ 48 ] = 0;
    JSphere_LockedIndexBuffer2[ 49 ] = 1;
    JSphere_LockedIndexBuffer2[ 50 ] = 16;
    JSphere_LockedIndexBuffer2[ 51 ] = 18;
    JSphere_LockedIndexBuffer2[ 52 ] = 16;
    JSphere_LockedIndexBuffer2[ 53 ] = 1;

    JSphere_LockedIndexBuffer2[ 54 ] = 1;
    JSphere_LockedIndexBuffer2[ 55 ] = 3;
    JSphere_LockedIndexBuffer2[ 56 ] = 12;
    JSphere_LockedIndexBuffer2[ 57 ] = 14;
    JSphere_LockedIndexBuffer2[ 58 ] = 12;
    JSphere_LockedIndexBuffer2[ 59 ] = 3;

    JSphere_LockedIndexBuffer2[ 60 ] = 6;
    JSphere_LockedIndexBuffer2[ 61 ] = 4;
    JSphere_LockedIndexBuffer2[ 62 ] = 19;
    JSphere_LockedIndexBuffer2[ 63 ] = 17;
    JSphere_LockedIndexBuffer2[ 64 ] = 19;
    JSphere_LockedIndexBuffer2[ 65 ] = 4;

    JSphere_LockedIndexBuffer2[ 66 ] = 4;
    JSphere_LockedIndexBuffer2[ 67 ] = 5;
    JSphere_LockedIndexBuffer2[ 68 ] = 10;
    JSphere_LockedIndexBuffer2[ 69 ] = 11;
    JSphere_LockedIndexBuffer2[ 70 ] = 10;
    JSphere_LockedIndexBuffer2[ 71 ] = 5;

    JSphere_LockedIndexBuffer2[ 72 ] = 5;
    JSphere_LockedIndexBuffer2[ 73 ] = 7;
    JSphere_LockedIndexBuffer2[ 74 ] = 22;
    JSphere_LockedIndexBuffer2[ 75 ] = 23;
    JSphere_LockedIndexBuffer2[ 76 ] = 22;
    JSphere_LockedIndexBuffer2[ 77 ] = 7;

    JSphere_LockedIndexBuffer2[ 78 ] = 7;
    JSphere_LockedIndexBuffer2[ 79 ] = 6;
    JSphere_LockedIndexBuffer2[ 80 ] = 15;
    JSphere_LockedIndexBuffer2[ 81 ] = 13;
    JSphere_LockedIndexBuffer2[ 82 ] = 15;
    JSphere_LockedIndexBuffer2[ 83 ] = 6;

    JSphere_LockedIndexBuffer2[ 84 ] = 10;
    JSphere_LockedIndexBuffer2[ 85 ] = 8;
    JSphere_LockedIndexBuffer2[ 86 ] = 17;
    JSphere_LockedIndexBuffer2[ 87 ] = 16;
    JSphere_LockedIndexBuffer2[ 88 ] = 17;
    JSphere_LockedIndexBuffer2[ 89 ] = 8;

    JSphere_LockedIndexBuffer2[ 90 ] = 9;
    JSphere_LockedIndexBuffer2[ 91 ] = 11;
    JSphere_LockedIndexBuffer2[ 92 ] = 20;
    JSphere_LockedIndexBuffer2[ 93 ] = 22;
    JSphere_LockedIndexBuffer2[ 94 ] = 20;
    JSphere_LockedIndexBuffer2[ 95 ] = 11;

    JSphere_LockedIndexBuffer2[ 96 ] = 15;
    JSphere_LockedIndexBuffer2[ 97 ] = 14;
    JSphere_LockedIndexBuffer2[ 98 ] = 23;
    JSphere_LockedIndexBuffer2[ 99 ] = 21;
    JSphere_LockedIndexBuffer2[ 100 ] = 23;
    JSphere_LockedIndexBuffer2[ 101 ] = 14;

    JSphere_LockedIndexBuffer2[ 102 ] = 12;
    JSphere_LockedIndexBuffer2[ 103 ] = 13;
    JSphere_LockedIndexBuffer2[ 104 ] = 18;
    JSphere_LockedIndexBuffer2[ 105 ] = 19;
    JSphere_LockedIndexBuffer2[ 106 ] = 18;
    JSphere_LockedIndexBuffer2[ 107 ] = 13;

    JSphere_IndexIdx2 = 108;

    JSphere_Tesselate2( 36, 4 );
    JSphere_Tesselate2( 42, 4 );
    JSphere_Tesselate2( 48, 4 );
    JSphere_Tesselate2( 54, 4 );
    JSphere_Tesselate2( 60, 4 );
    JSphere_Tesselate2( 66, 4 );
    JSphere_Tesselate2( 72, 4 );
    JSphere_Tesselate2( 78, 4 );
    JSphere_Tesselate2( 84, 4 );
    JSphere_Tesselate2( 90, 4 );
    JSphere_Tesselate2( 96, 4 );
    JSphere_Tesselate2( 102, 4 );

    JSphere_VertexBuffer2->Unlock();
    JSphere_IndexBuffer2->Unlock();

    TxLayer1 = TxGen_LayerInitialize( 512, 512 );
    TxLayer2 = TxGen_LayerInitialize( 512, 512 );

    Direct3DDevice->CreateTexture( 512, 512, 1, 0, D3DFMT_X8R8G8B8, D3DPOOL_DEFAULT, &JSphere_Texture1 );
    if ( !TxGen_LoadTGA( JSphere_Texture1, "Dreams10.tga" ))
      {
        TxGen_SubPlasma( TxLayer1, 0x232927, 0x41534D, 65, 19 );
        TxGen_SubPlasma( TxLayer2, 0x232927, 0x41534D, 66, 29 );
        TxGen_LayerBlend( TxLayer1, TxLayer1, TxLayer2, 40, TXGEN_BLEND_NORMAL );
        TxGen_SubPlasma( TxLayer2, 0x232927, 0x41534D, 67, 53 );
        TxGen_LayerBlend( TxLayer1, TxLayer1, TxLayer2, 20, TXGEN_BLEND_NORMAL );
        TxGen_SetTexture( JSphere_Texture1, TxLayer1 );
        if ( ExportTGA ) TxGen_SaveLayerTGA( TxLayer1, "Dreams10.tga" );
       }

    Direct3DDevice->CreateTexture( 512, 512, 1, 0, D3DFMT_X8R8G8B8, D3DPOOL_DEFAULT, &JSphere_Texture2 );
    if ( !TxGen_LoadTGA( JSphere_Texture2, "Dreams11.tga" ))
      {
        TxGen_SubPlasma( TxLayer1, 0x7F7F7F, 0xFFFFFF, 0, 4 );
        TxGen_EnvMap( TxLayer2, 0x5F5F5F, 0xFFFFFF, 255 );
        TxGen_LayerBlend( TxLayer2, TxLayer2, TxLayer1, 100, TXGEN_BLEND_MULTIPLY );
        TxGen_SetTexture( JSphere_Texture2, TxLayer2 );
        if ( ExportTGA ) TxGen_SaveLayerTGA( TxLayer2, "Dreams11.tga" );
       }

    Direct3DDevice->CreateTexture( 512, 512, 1, 0, D3DFMT_X8R8G8B8, D3DPOOL_DEFAULT, &JSphere_Texture3 );
    if ( !TxGen_LoadTGA( JSphere_Texture3, "Dreams12.tga" ))
      {
        TxGen_Cells( TxLayer1, 0xFFFFFF, 0x4F4F4F, 55, 30, 20 );
        TxGen_SubPlasma( TxLayer2, 0x585F62, 0x737B7E, 54, 8 );
        TxGen_LayerBlend( TxLayer2, TxLayer2, TxLayer1, 100, TXGEN_BLEND_MULTIPLY );
//      TxGen_SubPlasma( TxLayer1, 0x3F3F4F, 0x9F9FAF, 55, 7 );
//      TxGen_LayerBlend( TxLayer2, TxLayer2, TxLayer1, 40, TXGEN_BLEND_ADD );
//      TxGen_SubPlasma( TxLayer1, 0x3F3F3F, 0x7F7F7F, 56, 11 );
//      TxGen_LayerBlend( TxLayer2, TxLayer2, TxLayer1, 10, TXGEN_BLEND_ADD );
        TxGen_SetTexture( JSphere_Texture3, TxLayer2 );
        if ( ExportTGA ) TxGen_SaveLayerTGA( TxLayer2, "Dreams12.tga" );
       }

    TxGen_LayerCleanup( TxLayer1 );
    TxGen_LayerCleanup( TxLayer2 );

    return 1;
   }

// ------------------------------------------------------------------------------------------------
//    JSphere_Render();
// ------------------------------------------------------------------------------------------------

void JSphere_Render( float Time )
  {
    float Position;

    // --- Setup Material.
    Direct3DDevice->SetMaterial( &JSphere_Material1 );

    // --- Setup Lights.
    Direct3DDevice->SetRenderState( D3DRS_AMBIENT, 0xFFFFFF );
    Direct3DDevice->SetRenderState( D3DRS_LIGHTING, TRUE );

    JSphere_Light1.Diffuse.r = JSphere_Light1.Diffuse.g = JSphere_Light1.Diffuse.b = 1.0f;
    Direct3DDevice->SetLight( 0, &JSphere_Light1 );
    Direct3DDevice->LightEnable( 0, TRUE );


    if (( Time > 11.5f * 64.0f ) && ( Time <= 12.5f * 64.0f ))
      Position = 1.0f - Fsin(( Time - 11.5f * 64.0f ) / 128.0f * Fmath_Pi );
    if (( Time > 12.5f * 64.0f ) && ( Time <= 14.0f * 64.0f ))
      Position = 0.0f;
    if (( Time > 14.0f * 64.0f ) && ( Time <= 15.0f * 64.0f ))
      Position = 1.4f * ( 1.0f - Fsin(( 15.0f * 64.0f - Time ) / 128.0f * Fmath_Pi ));

    // --- Setup World Matrix0.
    D3DUMatrixTranslation( &D3DMatrix_World0, -3.0f * Position, 0.5f * Position, 0.5f * Position );
    D3DUMatrixRotationX( &D3DMatrix_Temp, Fsin( Time / 34.09f ));
    D3DUMatrixMultiply( &D3DMatrix_World0, &D3DMatrix_World0, &D3DMatrix_Temp );
    D3DUMatrixRotationY( &D3DMatrix_Temp, Fcos( Time / 31.02f ));
    D3DUMatrixMultiply( &D3DMatrix_World0, &D3DMatrix_World0, &D3DMatrix_Temp );
    D3DUMatrixRotationZ( &D3DMatrix_Temp, Fsin( Time / 19.98f ));
    D3DUMatrixMultiply( &D3DMatrix_World0, &D3DMatrix_World0, &D3DMatrix_Temp );
    Direct3DDevice->SetTransform( D3DTS_WORLD, &D3DMatrix_World0 );

    // --- Setup View Matrix.
    float Cam = 1.0f + 0.2f * Fsin( Time / 30.0f );
    D3DUVec3Create( &D3DVector_CameraPosition, 0.12f*Cam, 1.3f*Cam, -1.7f*Cam );
    D3DUVec3Create( &D3DVector_CameraTarget, 0.6f, -0.2f, 0.3f );
    D3DUVec3Create( &D3DVector_Up, 0.0f, -1.0f, 0.0f );
    D3DUMatrixLookAtLH( &D3DMatrix_View, &D3DVector_CameraPosition, &D3DVector_CameraTarget, &D3DVector_Up );
    Direct3DDevice->SetTransform( D3DTS_VIEW, &D3DMatrix_View );

    // --- Setup Projection Matrix.
    D3DUMatrixPerspectiveFovLH( &D3DMatrix_Projection, D3DU_PI * 0.4f, 1.778f, 0.1f, 10.0f );
    Direct3DDevice->SetTransform( D3DTS_PROJECTION, &D3DMatrix_Projection );

    Direct3DDevice->SetRenderState( D3DRS_CULLMODE, D3DCULL_NONE ); // CCW

    // --- Setup World Matrix1.
    D3DUMatrixTranslation( &D3DMatrix_World1, -3.0f * Position, 0.5f * Position, 0.5f * Position );
    D3DUMatrixRotationX( &D3DMatrix_Temp, Fsin(( Time-37.03f ) / 34.09f ));
    D3DUMatrixMultiply( &D3DMatrix_World1, &D3DMatrix_World1, &D3DMatrix_Temp );
    D3DUMatrixRotationY( &D3DMatrix_Temp, Fcos(( Time-37.03f ) / 31.02f ));
    D3DUMatrixMultiply( &D3DMatrix_World1, &D3DMatrix_World1, &D3DMatrix_Temp );
    D3DUMatrixRotationZ( &D3DMatrix_Temp, Fsin(( Time-37.03f ) / 19.98f ));
    D3DUMatrixMultiply( &D3DMatrix_World1, &D3DMatrix_World1, &D3DMatrix_Temp );
    Direct3DDevice->SetTransform( D3DTS_WORLD1, &D3DMatrix_World1 );

    // --- Setup Geometry Blending.
    Direct3DDevice->SetRenderState( D3DRS_VERTEXBLEND, D3DVBF_1WEIGHTS );
    
    Direct3DDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );

    // --- Setup Texture.
    Direct3DDevice->SetTexture( 0, JSphere_Texture1 );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_DISABLE );

    Direct3DDevice->SetTextureStageState( 0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_MINFILTER, D3DTEXF_LINEAR );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_MIPFILTER, D3DTEXF_NONE );

    Direct3DDevice->SetTextureStageState( 0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_COUNT2 );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_TEXCOORDINDEX, D3DTSS_TCI_PASSTHRU );

    Direct3DDevice->SetTexture( 1, JSphere_Texture2 );
    Direct3DDevice->SetTextureStageState( 1, D3DTSS_COLOROP, D3DTOP_MODULATE2X );
    Direct3DDevice->SetTextureStageState( 1, D3DTSS_COLORARG1, D3DTA_TEXTURE );
    Direct3DDevice->SetTextureStageState( 1, D3DTSS_COLORARG2, D3DTA_CURRENT );
    Direct3DDevice->SetTextureStageState( 1, D3DTSS_ALPHAOP, D3DTOP_DISABLE );

    Direct3DDevice->SetTextureStageState( 1, D3DTSS_MAGFILTER, D3DTEXF_LINEAR );
    Direct3DDevice->SetTextureStageState( 1, D3DTSS_MINFILTER, D3DTEXF_LINEAR );
    Direct3DDevice->SetTextureStageState( 1, D3DTSS_MIPFILTER, D3DTEXF_NONE );

    Direct3DDevice->SetTextureStageState( 1, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_COUNT2 );
    Direct3DDevice->SetTextureStageState( 1, D3DTSS_TEXCOORDINDEX, D3DTSS_TCI_CAMERASPACENORMAL );

    Direct3DDevice->SetTextureStageState( 2, D3DTSS_COLOROP, D3DTOP_DISABLE );

    Direct3DDevice->SetTransform( D3DTS_TEXTURE1, &MetaBalls_TextureMatrix0 );

    // --- Render.
    Direct3DDevice->SetVertexShader( D3DFVF_JSPHERE_VERTEX1 );
    Direct3DDevice->SetStreamSource( 0, JSphere_VertexBuffer1, sizeof( JSPHERE_VERTEX1 ));
    Direct3DDevice->SetIndices( JSphere_IndexBuffer1, 0 );
    Direct3DDevice->DrawIndexedPrimitive( D3DPT_TRIANGLELIST, 0, JSphere_VertexIdx1, 0, JSphere_IndexIdx1/3 );

    // === GLASS.

    Direct3DDevice->SetRenderState( D3DRS_VERTEXBLEND, D3DVBF_DISABLE );

    // --- Setup Texture.
    Direct3DDevice->SetTexture( 0, JSphere_Texture3 );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_CURRENT );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_DISABLE );

    Direct3DDevice->SetTextureStageState( 0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_MINFILTER, D3DTEXF_LINEAR );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_MIPFILTER, D3DTEXF_NONE );

    Direct3DDevice->SetTextureStageState( 0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_COUNT2 );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_TEXCOORDINDEX, D3DTSS_TCI_CAMERASPACEREFLECTIONVECTOR );

    Direct3DDevice->SetTexture( 1, JSphere_Texture2 );
    Direct3DDevice->SetTextureStageState( 1, D3DTSS_COLOROP, D3DTOP_MODULATE );
    Direct3DDevice->SetTextureStageState( 1, D3DTSS_COLORARG1, D3DTA_TEXTURE );
    Direct3DDevice->SetTextureStageState( 1, D3DTSS_COLORARG2, D3DTA_CURRENT );
    Direct3DDevice->SetTextureStageState( 1, D3DTSS_ALPHAOP, D3DTOP_DISABLE );

    Direct3DDevice->SetTextureStageState( 1, D3DTSS_MAGFILTER, D3DTEXF_LINEAR );
    Direct3DDevice->SetTextureStageState( 1, D3DTSS_MINFILTER, D3DTEXF_LINEAR );
    Direct3DDevice->SetTextureStageState( 1, D3DTSS_MIPFILTER, D3DTEXF_NONE );

    Direct3DDevice->SetTextureStageState( 1, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_COUNT2 );
    Direct3DDevice->SetTextureStageState( 1, D3DTSS_TEXCOORDINDEX, D3DTSS_TCI_CAMERASPACENORMAL );

    Direct3DDevice->SetTextureStageState( 2, D3DTSS_COLOROP, D3DTOP_DISABLE );

    Direct3DDevice->SetRenderState( D3DRS_ZWRITEENABLE, FALSE );

    Direct3DDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
    Direct3DDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_ONE );
    Direct3DDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );

    // --- Render.
    Direct3DDevice->SetVertexShader( D3DFVF_JSPHERE_VERTEX2 );
    Direct3DDevice->SetStreamSource( 0, JSphere_VertexBuffer2, sizeof( JSPHERE_VERTEX2 ));
    Direct3DDevice->SetIndices( JSphere_IndexBuffer2, 0 );
    Direct3DDevice->DrawIndexedPrimitive( D3DPT_TRIANGLELIST, 0, 384, 0, JSphere_IndexIdx2/3 );  // [!]

    Direct3DDevice->SetTextureStageState( 0, D3DTSS_TEXCOORDINDEX, D3DTSS_TCI_PASSTHRU );
    Direct3DDevice->SetTextureStageState( 1, D3DTSS_TEXCOORDINDEX, D3DTSS_TCI_PASSTHRU );

    Direct3DDevice->SetRenderState( D3DRS_ZWRITEENABLE, TRUE );
    Direct3DDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );

    // === WIREFRAME.

    Direct3DDevice->SetRenderState( D3DRS_VERTEXBLEND, D3DVBF_1WEIGHTS );

    // --- Setup Lights.
    Direct3DDevice->SetRenderState( D3DRS_AMBIENT, 0x00000000 );

    JSphere_Light1.Diffuse.r = JSphere_Light1.Diffuse.g = JSphere_Light1.Diffuse.b = 0.10f - 0.10f * Fcos( Fsqrt( Frac( Time / 32.0f )) * Fmath_2Pi );
    Direct3DDevice->SetLight( 0, &JSphere_Light1 );

    // --- Disable Texturing.
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_SELECTARG1 );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_DIFFUSE );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_DISABLE );

    // --- Setup World Matrix0.
    FLOAT Scale = 1.01f + Fsqr( Frac( Time / 32.0f ));
    D3DUMatrixScaling( &D3DMatrix_Temp, Scale, Scale, Scale );
    D3DUMatrixMultiply( &D3DMatrix_World0, &D3DMatrix_World0, &D3DMatrix_Temp );
    Direct3DDevice->SetTransform( D3DTS_WORLD, &D3DMatrix_World0 );
    // --- Setup World Matrix1.
    D3DUMatrixMultiply( &D3DMatrix_World1, &D3DMatrix_World1, &D3DMatrix_Temp );
    Direct3DDevice->SetTransform( D3DTS_WORLD1, &D3DMatrix_World1 );

    Direct3DDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_ONE );
    Direct3DDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );
    Direct3DDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );

    // --- Render Wireframe.
    Direct3DDevice->SetVertexShader( D3DFVF_JSPHERE_VERTEX1 );
    Direct3DDevice->SetStreamSource( 0, JSphere_VertexBuffer1, sizeof( JSPHERE_VERTEX1 ));
    Direct3DDevice->SetIndices( JSphere_IndexBuffer3, 0 );
    Direct3DDevice->DrawIndexedPrimitive( D3DPT_LINELIST, 0, JSphere_VertexIdx1, 0, JSphere_IndexIdx3/2 );

    Direct3DDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );
    Direct3DDevice->SetRenderState( D3DRS_VERTEXBLEND, D3DVBF_DISABLE );

//  Direct3DDevice->SetRenderState( D3DRS_LIGHTING, FALSE );
    Direct3DDevice->LightEnable( 0, FALSE );

    Direct3DDevice->SetRenderState( D3DRS_AMBIENT, 0xFFFFFF );

    Direct3DDevice->SetTextureStageState( 1, D3DTSS_TEXCOORDINDEX, D3DTSS_TCI_PASSTHRU );
    Direct3DDevice->SetTransform( D3DTS_TEXTURE0, &D3DUMatrixIdentity );
   }

// ------------------------------------------------------------------------------------------------
//    JSphere_Cleanup();
// ------------------------------------------------------------------------------------------------

void JSphere_Cleanup( void )
  {
    if ( JSphere_VertexBuffer1 != NULL ) JSphere_VertexBuffer1->Release();
    if ( JSphere_VertexBuffer2 != NULL ) JSphere_VertexBuffer2->Release();
    if ( JSphere_IndexBuffer1 != NULL ) JSphere_IndexBuffer1->Release();
    if ( JSphere_IndexBuffer2 != NULL ) JSphere_IndexBuffer2->Release();
    if ( JSphere_IndexBuffer3 != NULL ) JSphere_IndexBuffer3->Release();
    if ( JSphere_Texture1 != NULL ) JSphere_Texture1->Release();
    if ( JSphere_Texture2 != NULL ) JSphere_Texture2->Release();
    if ( JSphere_Texture3 != NULL ) JSphere_Texture3->Release();
   }