#pragma once
#include "physics.h"
#include "audio.h"

#if _DEBUG
#include <iostream>
#endif


#define kBarDur 1.88f

const int kMaxObjectCount = 1000;

static unsigned sObjects[kMaxObjectCount];
static char sObjectBegin[kMaxObjectCount];
static char sObjectEnd[kMaxObjectCount];
static int sObjectCount;

// time range expressed in bars
static void TimelineAdd(unsigned pointStartAndCount, char barBegin, char barEnd)
{
	sObjects[sObjectCount] = pointStartAndCount;
	sObjectBegin[sObjectCount] = barBegin;
	sObjectEnd[sObjectCount] = barEnd;
	++sObjectCount;
}

static void TimelineEnableObjects(float t)
{
#if _DEBUG
	////static int lastBar = -1;
	////int bar = t / kBarDur;
	//if (audioState.onBar)
	//{
	//	std::cout << "Timeline entered bar " << audioState.bar << std::endl;
	//}
#endif
	for (int i = 0; i < sObjectCount; ++i)
		PhysicsObjectEnable(sObjects[i], audioState.bar-1 >= sObjectBegin[i] && audioState.bar-1 < sObjectEnd[i]);
}
