ASM  = asmpsx
CC   = ccpsx
LINK = psylink

CCOPTIONS  = -c -O3 -mgpopt -G32 -comments-c++ #-DDEBUG
ASMOPTIONS = /l /o c+ /o an+ /zd
LINKOPTS   = /c /m -Xo$80010000 -llibspu music/hitmod.obj
TEST_OBJS  = main.obj o3d.obj regtex.obj ship.obj cube.obj incbin.obj ribbon.obj sincos.obj axe.obj hammer.obj glaive.obj

all  : main.cpe
       cpe2x main.cpe
       echo Done.

clean:
	del $(TEST_OBJS)
	
main.cpe : $(TEST_OBJS)
	ccpsx $(LINKOPTS) $(TEST_OBJS) -omain.cpe

main.obj: main.c o3d.h msg.h
	$(CC) $(CCOPTIONS) main.c -omain.obj

regtex.obj: regtex.c
	$(CC) $(CCOPTIONS) regtex.c -oregtex.obj

o3d.obj: o3d.c o3d.h
	$(CC) $(CCOPTIONS) o3d.c -oo3d.obj

ship.obj: ship.c
	$(CC) $(CCOPTIONS) ship.c -oship.obj

axe.obj: axe.c
	$(CC) $(CCOPTIONS) axe.c -oaxe.obj

glaive.obj: glaive.c
	$(CC) $(CCOPTIONS) glaive.c -oglaive.obj

hammer.obj: hammer.c
	$(CC) $(CCOPTIONS) hammer.c -ohammer.obj

cube.obj: cube.c
	$(CC) $(CCOPTIONS) cube.c -ocube.obj

incbin.obj: incbin.asm
	$(ASM) $(ASMOPTIONS) incbin.asm,incbin.obj

ribbon.obj: ribbon.c
	$(CC) $(CCOPTIONS) ribbon.c -oribbon.obj

sincos.obj: sincos.c
	$(CC) $(CCOPTIONS) sincos.c -osincos.obj
