import java.awt.*;
import java.awt.image.*;

/**
 * @author Unai Landa{@link unai_landa@eresmas.com}
 * @since 23/05/2000
 * @version .99a
 */
public class FrameGrafico extends Frame {
  int iSizeX;

  int iSizeY;

  int iSurfaceType;

  BufferedImage imgBackBuffer;

  Graphics2D    grfBackBuffer;

  boolean bOk;

  boolean bLocked;

  /**  Constructor de FrameGrafico
   */
  public FrameGrafico() {
    bOk = false;
  }

  /**  Mtodo de inicializacin.
   *  @param _iSizeX Tamao del bufer en X
   *  @param _iSizeX Tamao del bufer en X
   *  @param _iSurfaceType tipo de superficie que va a contener,
   *                        definida en BufferedImage.
   */
  public void init(int _iSizeX,int _iSizeY,int _iSurfaceType) {
    end();
    //  variables
    iSurfaceType = _iSurfaceType;
    iSizeX       = _iSizeX;
    iSizeY       = _iSizeY;
    // ventana
    setSize(iSizeX, iSizeY);
    show();
    toFront();
    //  memoria
    imgBackBuffer = new BufferedImage(iSizeX, iSizeY, iSurfaceType);
    grfBackBuffer = imgBackBuffer.createGraphics();
    bOk           = true;
  }

  /**  Destruccion del objeto
   */
  public void end() {
    if(isOk())
    {
      bOk = false;
      dispose();
      grfBackBuffer.dispose();
      grfBackBuffer = null;
      imgBackBuffer = null;
    }
  }

  /**  Destruccion del objeto
   */
  public void finalize() throws Throwable {
    end();
    super.finalize();
  }

  /**  Test de inicializacin.
   */
  public boolean isOk() {
    return(bOk);
  }

  /**  Test de bloqueo de accesoa buffer.
   */
  public boolean isLocked() {
    return(bLocked);
  }

  /**  Bloqueo de accesoa buffer.
   */
  public boolean lock() {
    if(!bLocked)
    {
      bLocked = true;
      return(true);
    }
    else
    return(false);
  }

  /**  Desbloqueo de accesoa buffer.
   */
  public boolean unLock() {
    if(bLocked)
    {
      bLocked = false;
      return(true);
    }
    else
    return(false);
  }

  /**  Hay que volcar a pantalla.
   */
  public void update(Graphics _g) {
    //  Comienzo del volcado
    if(isOk() && _g!=null && lock())
    {
      //  Copia del BackBuffer
      Graphics2D grfFrontBuffer = (Graphics2D)_g;
      grfFrontBuffer.drawImage(imgBackBuffer, null, 0, 0);
      grfFrontBuffer.dispose();
      //  Desbloquea el aceso al back Buffer.
      unLock();
    }
  }

  /**  Peticin de redibujado.
   */
  public void paint(Graphics _g) {
    update(_g);
  }
}

