#ifndef gamesurvival_h
#define gamesurvival_h

//############################################################################
// Include ###################################################################
//############################################################################

#include "game.h"

#include <sstream>

//############################################################################
// Class #####################################################################
//############################################################################

class GameSurvival :
  public Game
{
  private:
    /** String to display around. */
    std::stringstream *stringbox;

    /** The current phase. */
    int phase;

    /** Determines what is displayed. */
    int info_display;

  public:
    GameSurvival(const char*);
    ~GameSurvival();

    // Virtual inherited methods (from EventHandler).
  public:
    virtual void draw(libfhi::Surface*);
    virtual void tick();

    // Virtual inherited methods (from Game).
  public:
    virtual void entity_delete(std::list<Entity*>::iterator, bool = false);

    // Other methods.
  public:
    void phase_new();
};

//############################################################################
// End #######################################################################
//############################################################################

#endif

