#include "ingamemenu.h"

#include "commands.h"
#include "options.h"

#include "SDL.h"

//############################################################################
// Construction ##############################################################
//############################################################################

InGameMenu::InGameMenu()
: Menu("Game")
{
  this->menu.add_item(new MenuItem("Return", command_return_to_game));
  this->menu.add_item(new MenuItem("End game", command_end_game));
}

InGameMenu::~InGameMenu()
{
  /* Do nothing. */
}

//############################################################################
// Methods ###################################################################
//############################################################################

/** Implementation of draw.
 */
void InGameMenu::draw(libfhi::Surface *screen)
{
  // Fallback to draw menu.
  Menu::draw(screen);
}

/** Implementation of keydown.
 * @param key Key pressed.
 */
void InGameMenu::keydown(int key)
{
  if((key == SDLK_ESCAPE) || (key == Options::key_absorb))
  {
    command_return_to_game();
    return;
  }

  Menu::keydown(key);
}

/** Implementation of tick.
 */
void InGameMenu::tick()
{
  // Fallback to menu.
  Menu::tick();
}

//############################################################################
// End #######################################################################
//############################################################################


