#ifndef menuitem_h
#define menuitem_h

//############################################################################
// Include ###################################################################
//############################################################################

#include <string>
#include <vector>

//############################################################################
// Class #####################################################################
//############################################################################

/** Menuitem is a singular menu item that contains either a command or a
 * list of other menu items.
 */
class MenuItem
{
  private:
    /** Name of the menu item. */
    std::string name;

    /** The command of this menu item. */
    void (*command)();

    /** List of further menu items. */
    std::vector<MenuItem*> items;

    /** Parent menu item. */
    MenuItem *parent;

    /** Index of this menu item. */
    int index;

  public:
    MenuItem(std::string, void (*func)() = NULL);
    ~MenuItem();

    // Methods.
    void add_item(MenuItem*);
    MenuItem* execute();
    int get_index() const;
    MenuItem* get_item(int);
    const std::string& get_name() const;
    MenuItem* get_parent();
    int num_items();
};

//############################################################################
// End #######################################################################
//############################################################################

#endif

