#include "thurster.h"

#include "data.h"
#include "effect.h"

//############################################################################
// Construction ##############################################################
//############################################################################

/** Default constructor.
 * @param p Position relative to host.
 * @param spd Speed
 * @param d Direction.
 * @param filename Effect filename.
 */
Thurster::Thurster(const libfhi::Vector2 &p, float spd, int d,
    const char *filename)
  : pos(p)
{
  float pi = libfhi::uint2pi(static_cast<uint16_t>(d));
  this->thurstvector.set(cosf(pi), sinf(pi));
  this->thurstvector *= spd;

  this->effect = Data::load_eff(filename);
}

/** Default destructor.
 */
Thurster::~Thurster()
{
  // Do nothing.
}

//############################################################################
// Methods ###################################################################
//############################################################################

/** Fire this thurster.
 * @param hpos Host position.
 * @param hmov Host movement.
 * @param hdir Host direction.
 */
void Thurster::fire(const libfhi::Vector2 &hpos, const libfhi::Vector2 &hmov,
    uint16_t hdir)
{
  float pi = libfhi::uint2pi(hdir),
	cr = cosf(pi),
	sr = sinf(pi);

  libfhi::Vector2 tpos;
  tpos.rotate_translate(this->pos, cr, sr, hpos);

  libfhi::Vector2 tthurst;
  tthurst.rotate_translate(this->thurstvector, cr, sr, hmov);

  // Note that this heavily excepts that dir and scatter are successive in the
  // class. If there would be an architecture where they are not laid in 4
  // byte boundary, results would be interesting.
  this->effect->execute(&tpos, &tthurst);
}

//############################################################################
// End #######################################################################
//############################################################################

