#ifndef libfhi_texture_include
#define libfhi_texture_include

//############################################################################
// Include ###################################################################
//############################################################################

#include "libfhi_canonicaldb.h"

#ifdef LIBFHI_OPENGL
#include LIBFHI_GLEW_H
#endif

namespace libfhi {

//############################################################################
// Luokka ####################################################################
//############################################################################

/** Texture represents one texture available in-game. They are saved in a
 * canonical db and automatically generated and compiled to OpenGL texture
 * names.
 *
 * As of now, there is no software texture support, textured polygons will be
 * drawn as just gouraud-shaded if in software mode.
 *
 * What this means, is that when compiling without OpenGL support, the texture
 * class will be essentially empty.
 */
class Texture :
  public CanonicalDB<Texture>
{
#ifdef LIBFHI_OPENGL
  private:
    /** Texture index. */
    GLuint texture_name;
#endif

  public:      
    Texture();
    Texture(const char*);
    ~Texture();

    bool load(const char*);

    // Inline.
#ifdef LIBFHI_OPENGL
  public:
    inline GLuint get_texture_name() const;
#endif
};

//############################################################################
// Functions #################################################################
//############################################################################

extern Texture* texture_new(const char*);

//############################################################################
// Inline ####################################################################
//############################################################################

#ifdef LIBFHI_OPENGL

/** Return the color array.
 * @return Pointer to the beginning of the color array.
 */
size_t Texture::get_texture_name() const
{
  return this->texture_name;
}

#endif

//############################################################################
// Loppu #####################################################################
//############################################################################

}
#endif

