#include "libfhi_png.h"

#include "png.h"

namespace libfhi {

//############################################################################
// Functions #################################################################
//############################################################################

/** Save a block of linear data as a png file. Used internally by other
 * methods here for convenience.
 * @param x Width of data.
 * @param y Heigth of data.
 * @param b Bits per pixel in the data (only supports 32 for now).
 * @param data Image data.
 * @param filename Name of the file to create.
 * @return True on success, false on failure.
 */
bool write_png(int x, int y, int b, void *data, const char *filename)
{
  // Stack variable heigth.
  png_byte **row_pointers;

  // Do not save nonexistent bitmaps.
  if((x <= 0) || (y <= 0) || (b != 32))
  {
    return false;
  }

  row_pointers = new png_byte*[y];

  // Open a file, test for failure.
  FILE *filu = fopen(filename, "wb");

  if(!filu)
  {
    delete[] row_pointers;
    return false;
  }

  // Create write struct.
  png_structp png_ptr = png_create_write_struct(PNG_LIBPNG_VER_STRING,
      NULL, NULL, NULL);

  if(!png_ptr)
  {
    fclose(filu);
    delete[] row_pointers;
    return false;
  }

  // Create info struct.
  png_infop info_ptr = png_create_info_struct(png_ptr);
  
  if (!info_ptr)
  {
    png_destroy_write_struct(&png_ptr, static_cast<png_infopp>(NULL));
    fclose(filu);
    delete[] row_pointers;
    return false;
  }

  // Set libpng longjump back here on error.
  if (setjmp(png_jmpbuf(png_ptr)))
  {
    png_destroy_write_struct(&png_ptr, &info_ptr);
    fclose(filu);
    delete[] row_pointers;
    return false;
  }
  
  // Set libpng write target file.
  png_init_io(png_ptr, filu);

  // Set the image data.
  png_set_IHDR(png_ptr, info_ptr,
      x, y, 8, PNG_COLOR_TYPE_RGB_ALPHA,
      PNG_INTERLACE_NONE,
      PNG_COMPRESSION_TYPE_DEFAULT,
      PNG_FILTER_TYPE_DEFAULT);

  // Initialize row pointers.
  /*png_byte **row_pointers = static_cast<png_byte**>(
      png_malloc(png_ptr, y * sizeof(png_byte*)));*/
  for(int i = 0; (i < y); ++i)
  {
    row_pointers[i] = reinterpret_cast<png_byte*>(
   	  static_cast<uint32_t*>(data) + i * x);
  }

  // Set row pointers and write.
  png_set_rows(png_ptr, info_ptr, row_pointers);
  png_write_png(png_ptr, info_ptr, PNG_TRANSFORM_IDENTITY, NULL);

  // Success.
  png_write_end(png_ptr, info_ptr);
  png_destroy_write_struct(&png_ptr, &info_ptr);
  fclose(filu);
  delete[] row_pointers;
  return true;
}

//############################################################################
// End #######################################################################
//############################################################################

}

