#include "challenge.h"

#include "gamechallenge.h"
#include "globals.h"
#include "levelitem.h"
#include "options.h"
#include "weapon.h"

#include "SDL.h"

//############################################################################
// Construction ##############################################################
//############################################################################

/** Default constructor for Challenge selection.
 */
Challenge::Challenge() :
  LevelSelector("level/challenge.lst")
{
  this->read_scores("challenge.scores");
}

/** Default destructor.
 */
Challenge::~Challenge()
{
  // Will only save if they have been read.
  this->save_scores();
}

//############################################################################
// Virtual methods ###########################################################
//############################################################################

/** Keydown.
 * @param op Key pressed.
 */
void Challenge::keydown(int key)
{
  // Descend.
  if((key == SDLK_RETURN) || (key == Options::key_fire))
  {
    LevelItem *it = this->items[this->current_item];

    Weapon::set_slowdown(GAME_SURVIVAL_BULLET_SLOWDOWN);

    g_handler = Game::instance_new(new GameChallenge(it->get_file()));
  }
  else
  {
    this->LevelSelector::keydown(key);
  }
}

//############################################################################
// End #######################################################################
//############################################################################

