#include "commands.h"

#include "challenge.h"
#include "encyclopedia.h"
#include "gamestorymode.h"
#include "gamesurvival.h"
#include "globals.h"
#include "ingamemenu.h"
#include "mainmenu.h"

//############################################################################
// Command list ##############################################################
//############################################################################

/** This command displays the about page.
 */
void command_about()
{
}

/** Invokes the challenge menu.
 */
void command_challenge()
{
  g_handler = Challenge::instance_get();
}

/** Run the encyclopedia.
 */
void command_encyclopedia()
{
  g_handler = Encyclopedia::instance_get();
  g_handler->return_to();
}

/** This command ends (aborts) the current game and installs main menu as the
 * event handler.
 */
void command_end_game()
{
  g_handler = MainMenu::instance_get();
  g_handler->return_to();
}

/** Enter the highscore mode.
 */
void command_high_scores()
{
}

/** Ingame menu command.
 */
void command_ingame_menu()
{
  g_handler = InGameMenu::instance_get();
  g_handler->return_to();
}

/** Enter the instruction (help) mode.
 */
void command_instructions()
{
  static const char* lorem = "Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Cras feugiat porttitor purus. Donec massa nibh, ullamcorper at, volutpat id, pharetra eu, nisi. Proin tincidunt nisl ac libero. Aenean dolor augue, ornare vitae, pulvinar ut, tincidunt auctor, ipsum. Nam mollis tincidunt odio. Aliquam purus ante, nonummy at, imperdiet et, dictum nec, lacus. Maecenas eget pede. Pellentesque pulvinar. Etiam lobortis nisl vel lorem. In venenatis purus id urna. Suspendisse sit amet libero. Suspendisse placerat, dolor quis nonummy blandit, augue arcu egestas mi, sed mattis nibh erat non velit. Nam faucibus leo gravida quam porttitor commodo. Nunc enim odio, dignissim ac, bibendum ac, cursus at, ante. Cras fringilla dui non nulla. Sed faucibus nunc et pede. Vestibulum blandit nulla vel enim.";
  Menu::draw_text_box(10, 10, 400, 400, lorem);
}

/** This command starts a new game and installs it as the current event
 * handler.
 */
void command_new_game_story_mode()
{
  g_handler = Game::instance_new(new GameStoryMode("level/race.lev"));
}

/** This command starts a new game and installs it as the current event
 * handler.
 */
void command_new_game_survival()
{
  g_handler = Game::instance_new(new GameSurvival("level/survival.lev"));
}

/** Return to game command.
 */
void command_return_to_game()
{
  g_handler = Game::instance_get();
  g_handler->return_to();
}

/** Exit the program.
 */
void command_quit()
{
  g_handler = NULL;
}

//############################################################################
// End #######################################################################
//############################################################################

