#include "effectdb.h"

//############################################################################
// Construction ##############################################################
//############################################################################

/** Default constructor.
 */
EffectDB::EffectDB()
{
  // Do nothing.
}

/** Default destructor.
 */
EffectDB::~EffectDB()
{
  this->clear_effects();
}

//############################################################################
// Methods ###################################################################
//############################################################################

/** Clears all effects currently active.
 */
void EffectDB::clear_effects()
{
  for(std::list<EffectInstance*>::iterator i = this->effects.begin(),
      e = this->effects.end(); (i != e); ++i)
  {
    delete *i;
  }

  this->effects.clear();
}

/** Ticks all effects. There should be no need for a distinct draw function,
 * as effects mostly rely on particles that are drawn each frame if they are.
 */
void EffectDB::tick()
{
  for(std::list<EffectInstance*>::iterator iter = this->effects.begin();
      (iter != this->effects.end());)
  {
    std::list<EffectInstance*>::iterator curr = iter;
    ++iter;

    if(!(*curr)->tick())
    {
      delete (*curr);
      this->effects.erase(curr);
    }
  }
}

//############################################################################
// End #######################################################################
//############################################################################

