#ifndef levelitem_h
#define levelitem_h

//############################################################################
// Include ###################################################################
//############################################################################

#include "libfhi.h"

#include <string>

//############################################################################
// Class #####################################################################
//############################################################################

/** ChallengeItem stores data of one challenge, basically it's pretty much a
 * simple storage class.
 */
class LevelItem
{
  private:
    /** The filename to load. */
    std::string filename;

    /** The name to be displayed in the menu. */
    std::string name;

    /** The description to be displayed in the menu. */
    std::string description;

    /** The image file to be displayed on the right. */
    libfhi::Texture *tex;

    /** Best complete time. */
    int best_time;

    /** Time author. */
    std::string author_time;

    /** Best complete score. */
    int best_score;

    /** Score author. */
    std::string author_score;

  public:
    LevelItem(const char*, const char*, const char*, const char*);
    ~LevelItem();

  public:
    bool need_update_score(int) const;
    bool need_update_time(int) const;
    void set_best_score(int, const std::string&);
    void set_best_time(int, const std::string&);

  public:
    inline const std::string& get_author_score() const;
    inline const std::string& get_author_time() const;
    inline int get_best_score() const;
    inline int get_best_time() const;
    inline const char* get_description() const;
    inline const char* get_file() const;
    inline const char* get_name() const;
    inline libfhi::Texture* get_texture();
};

//############################################################################
// Inline ####################################################################
//############################################################################

/** Get the name of the person who did the best score.
 * @return String reference.
 */
const std::string& LevelItem::get_author_score() const
{
  return this->author_score;
}

/** Get the name of the person who did the best time.
 * @return String reference.
 */
const std::string& LevelItem::get_author_time() const
{
  return this->author_time;
}

/** Get the top score on this level.
 * @return Integer.
 */
int LevelItem::get_best_score() const
{
  return this->best_score;
}

/** Get the lowest time on this level.
 */
int LevelItem::get_best_time() const
{
  return this->best_time;
}

/** Get the description of this.
 * @return The description as C string.
 */
const char* LevelItem::get_description() const
{
  return this->description.c_str();
}

/** Get the filename of this level selection item.
 * @return The file as C string.
 */
const char* LevelItem::get_file() const
{
  return this->filename.c_str();
}

/** Get the name of this level selection item.
 * @return The name as C string.
 */
const char* LevelItem::get_name() const
{
  return this->name.c_str();
}

/** Get the displayed texture of this.
 * @return Texture pointer.
 */
libfhi::Texture* LevelItem::get_texture()
{
  return this->tex;
}

//############################################################################
// End #######################################################################
//############################################################################

#endif

