#ifndef mainmenu_h
#define mainmenu_h

//############################################################################
// Include ###################################################################
//############################################################################

#include "menu.h"

#include "libfhi.h"

//############################################################################
// Class #####################################################################
//############################################################################

/** Main menu class takes care of displaying the main menu with some fancy
 * crap beside it.
 */
class MainMenu :
  public Menu,
  public libfhi::Singleton<MainMenu>
{
  private:
    /** x position of displayed text. */
    float disp_text_x;

    /** y position of displayed text. */
    float disp_text_y;

    /** Logo texture. */
    libfhi::Texture *logo_tex;

  public:
    MainMenu();
    ~MainMenu();

    // Virtual methods.
    virtual void draw(libfhi::Surface*);
    virtual void keydown(int);
    virtual void return_to();
    virtual void tick();
};

//############################################################################
// End #######################################################################
//############################################################################

#endif

