#ifndef ABSORB_SOUND_INCLUDED
#define ABSORB_SOUND_INCLUDED

//############################################################################
// Includes ##################################################################
//############################################################################

#include "libfhi.h"

#include "SDL_mixer.h"

//############################################################################
// Class #####################################################################
//############################################################################

/** One sound channel.
 */
class Channel
{
  public:
    Channel(int ch);
    ~Channel();

  public:
    void FadeOut(int t) const;
    bool IsPlaying() const;
    bool IsPaused() const;
    void Pause() const;
    void Resume() const;
    void Stop() const;
	
  protected:
    int channel;
};

/** One sample. Saves itself to the canonical database.
 */
class Sample :
  public libfhi::CanonicalDB<Sample>
{
  public:
    Sample(const char* filename);
    ~Sample();

    int Play(const libfhi::Vector2&);
    int Play(int vol = MIX_MAX_VOLUME, int loops = 0);
    int FadeIn(int t, int loops=0) const;

  protected:
    /** Sample data. */
    Mix_Chunk *sample;

    /** Last play frame. The game prevents continuous playing of samples. */
    int last_play_frame;
};

//############################################################################
// Class #####################################################################
//############################################################################

#endif

