#include "stringinput.h"

#include "menu.h"

#include "SDL.h"

//############################################################################
// Statics ###################################################################
//############################################################################

std::string StringInput::last_string("Anonymous");
bool shift_down = false;

//############################################################################
// Construction ##############################################################
//############################################################################

/** Default constructor.
 * @param h Header text.
 */
StringInput::StringInput(const std::string &h) :
  input(last_string), header(h)
{
  // Do nothing.
}

/** Destructor.
 */
StringInput::~StringInput()
{
  // Do nothing.
}

//############################################################################
// Methods ###################################################################
//############################################################################

/** Draw this string with the box.
 * @param usage How many percent of the screen area to use.
 */
void StringInput::draw(float usage, libfhi::Surface *screen)
{
  int x1 = 0,
      x2 = screen->get_h() - 1,
      h = lrintf(usage * static_cast<float>(screen->get_h())),
      y1 = (screen->get_h() - h) / 2,
      y2 = (screen->get_h() + h) / 2,
      rectcol = libfhi::Surface::makecol4(0, 0, 0, 92),
      fontsize = Menu::get_fontsize();

  // Select screen for drawing.
  screen->set_boundary(x1, y1, x2, y2);
  screen->select_2d();

  // Borders plz.
  libfhi::Surface::nc_rect(x1, y1, x2, y1 + 1, Menu::get_color_border());
  libfhi::Surface::nc_rect(x1, y2 - 1, x2, y2, Menu::get_color_border());
  libfhi::Surface::nc_rect(x1, y1 + 2, x1 + 1, y2 - 2,
      Menu::get_color_border());

  // Blackening box.
  libfhi::Surface::nc_rect(x1 + 2, y1 + 2, x2, y2 - 2, rectcol);

  // Draw the text.
  Menu::draw_text_box(x1 + 6, y1 + 6, x2 - 4, y2 - 6, this->header.c_str());

  // Draw blacken box again.
  libfhi::Surface::nc_rect(x1 + 2,
      y2 - 2 - fontsize * 2,
      x2,
      y2 - 2,
      rectcol);

  // Draw the string.
  libfhi::Surface::draw_text(x1 + 2 + 4,
      y2 - 2 - fontsize / 2,
      Menu::get_color_title(),
      Menu::get_font(),
      this->input.c_str());
}

/** Input one key.
 * @param key Key pressed.
 * @return True of the string is ready, false otherwise.
 */
bool StringInput::keydown(int key)
{
  // Return if applicable.
  if(key == SDLK_RETURN)
  {
    if(!this->input.empty())
    {
      StringInput::last_string = this->input;
      return true;
    }
  }
  // Input something.
  else if((key >= SDLK_a) && (key <= SDLK_z))
  {
    this->input = this->input + static_cast<char>(key - SDLK_a + 'a');

    if(shift_down)
    {
      this->input[this->input.length() - 1] -= ('a' - 'A');
    }
  }
  else if((key >= SDLK_0) && (key <= SDLK_9))
  {
    this->input = this->input + static_cast<char>(key - SDLK_0 + '0');
  }
  else if(key == SDLK_BACKSPACE)
  {
    if(this->input.length() > 0)
    {
      this->input = this->input.substr(0, this->input.length() - 1);
    }
  }
  else if((key == SDLK_RSHIFT) || (key == SDLK_LSHIFT))
  {
    shift_down = true;
  }

  return false;
}

/** Release one key.
 * @param Key released.
 */
void StringInput::keyup(int key)
{
  if((key == SDLK_RSHIFT) || (key == SDLK_LSHIFT))
  {
    shift_down = false;
  }
}

//############################################################################
// End #######################################################################
//############################################################################

