/*
 * Decompiled with CFR 0.152.
 */
package cellrace;

import cellrace.Line;
import cellrace.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import utils.Draw;
import utils.MathExtension;

public class BSplineCurve {
    private static Hashtable cache = new Hashtable();
    private static final int MAX = 20;

    private static int iX(double x) {
        return MathExtension.round(x);
    }

    private static int iY(double y) {
        return MathExtension.round(y);
    }

    static void bspline(String name, Graphics g, int[] Px, int[] Py, int color1, int color2, int color3, int color4, int color5, int color6, Rectangle rectangle) {
        Vector<Line> lines;
        if (!cache.containsKey(name)) {
            System.err.println("slow bspline Operation");
            lines = new Vector<Line>();
            cache.put(name, lines);
            int m = 4;
            int n = Px.length;
            double counter = 0.0;
            boolean flip = true;
            double x = 0.0;
            double y = 0.0;
            boolean first = true;
            int i = 1;
            while (i < n + 1) {
                double xA = Px[(i - 1) % n];
                double xB = Px[i % n];
                double xC = Px[(i + 1) % n];
                double xD = Px[(i + 2) % n];
                double yA = Py[(i - 1) % n];
                double yB = Py[i % n];
                double yC = Py[(i + 1) % n];
                double yD = Py[(i + 2) % n];
                double a3 = (-xA + 3.0 * (xB - xC) + xD) / 6.0;
                double b3 = (-yA + 3.0 * (yB - yC) + yD) / 6.0;
                double a2 = (xA - 2.0 * xB + xC) / 2.0;
                double b2 = (yA - 2.0 * yB + yC) / 2.0;
                double a1 = (xC - xA) / 2.0;
                double b1 = (yC - yA) / 2.0;
                double a0 = (xA + 4.0 * xB + xC) / 6.0;
                double b0 = (yA + 4.0 * yB + yC) / 6.0;
                int j = 0;
                while (j <= 4) {
                    double x0 = x;
                    double y0 = y;
                    float t = (float)j / 4.0f;
                    x = ((a3 * (double)t + a2) * (double)t + a1) * (double)t + a0;
                    y = ((b3 * (double)t + b2) * (double)t + b1) * (double)t + b0;
                    if (first) {
                        first = false;
                    } else {
                        double h1 = x0 - x;
                        double h2 = y0 - y;
                        Line line = new Line(BSplineCurve.iX(x0), BSplineCurve.iY(y0), BSplineCurve.iX(x), BSplineCurve.iY(y), flip);
                        lines.addElement(line);
                        counter += Math.sqrt(h1 * h1 + h2 * h2);
                        if (counter > 20.0) {
                            counter = 0.0;
                            flip = !flip;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        lines = (Vector<Line>)cache.get(name);
        Enumeration e = lines.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            Line line = (Line)e.nextElement();
            if (!line.inside(rectangle)) continue;
            g.setColor(line.isFlip() ? color1 : color2);
            Draw.drawLine(g, line.getX1(), line.getY1(), line.getX2(), line.getY2(), 3);
            g.setColor(line.isFlip() ? color3 : color4);
            Draw.drawLine(g, line.getX1(), line.getY1(), line.getX2(), line.getY2(), 2);
            g.setColor(line.isFlip() ? color5 : color6);
            Draw.drawLine(g, line.getX1(), line.getY1(), line.getX2(), line.getY2(), 1);
            ++i;
        }
    }
}

