/*
 * Decompiled with CFR 0.152.
 */
package cellrace;

import cellrace.Car;
import cellrace.CellRace;
import cellrace.Course;
import cellrace.GameFinishListener;
import cellrace.Loader;
import cellrace.Player;
import cellrace.Setup;
import cellrace.StraightLine;
import cellrace.Utils;
import cellrace.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import utils.PropertyChangeEvent;
import utils.PropertyChangeListener;
import utils.Sort;
import utils.Sound;
import utils.Timer;

public class Game
extends Canvas
implements PropertyChangeListener,
Loader {
    private Course course;
    private int x = Integer.MIN_VALUE;
    private int y = Integer.MIN_VALUE;
    private int oldX = -1;
    private int oldY = -1;
    private double ratio = 0.3;
    public static final double SCALE = 2.0;
    private Player[] players;
    private int current = -1;
    private boolean gameOver = false;
    private int rank = 1;
    private int negativeRank = Integer.MAX_VALUE;
    private Setup setup;
    private boolean loaded = false;
    private final Image offscreen;
    private GameFinishListener listener;

    public void clear() {
        this.course.clear();
        this.course = null;
        this.loaded = false;
        this.negativeRank = Integer.MAX_VALUE;
        this.rank = 1;
        this.gameOver = false;
        this.current = -1;
        this.players = null;
        this.oldX = -1;
        this.oldY = -1;
        this.x = Integer.MIN_VALUE;
        this.y = Integer.MIN_VALUE;
        System.gc();
    }

    public Game(GameFinishListener listener) {
        this.listener = listener;
        this.setFullScreenMode(true);
        this.offscreen = Image.createImage((int)this.getWidth(), (int)this.getHeight());
    }

    private Vector getMiddleOfAction() {
        Player p = this.course.getCurrentPlayer();
        Vector v1 = p.getPosition().getStart();
        Vector v2 = null;
        int i = p.getChoices().length;
        while (i > 0) {
            if (p.getChoices()[i - 1] != null) {
                v2 = p.getChoices()[i - 1].getStart();
                break;
            }
            --i;
        }
        Vector v3 = new Vector((v1.getX() + v2.getX()) / 2.0, (v1.getY() + v2.getY()) / 2.0);
        return v3;
    }

    protected void paint(Graphics g) {
        Graphics go = this.offscreen.getGraphics();
        Timer.start("game");
        if (this.isLoaded()) {
            if (this.x != this.oldX || this.y != this.oldY) {
                go.drawImage(this.course.drawCourse(this.x, this.y, this.getWidth(), this.getHeight()), 0, 0, 20);
                this.course.drawMiniCourse(go);
                this.course.drawHistory(go, this.x, this.y);
                this.course.drawRound(go, this.x, this.y);
                this.course.drawScore(go, 0, this.getHeight());
                this.oldX = this.x;
                this.oldY = this.y;
            }
            g.drawImage(this.offscreen, 0, 0, 20);
            this.course.drawChoices(g, this.x, this.y);
        }
        Timer.stop("game");
        if (this.gameOver) {
            this.course.drawGameOver(g, this.getWidth(), this.getHeight());
        }
    }

    private boolean isLoaded() {
        return this.loaded && this.x != Integer.MIN_VALUE && this.y != Integer.MIN_VALUE;
    }

    protected void keyPressed(int keyCode) {
        if (keyCode == this.getKeyCode(6)) {
            this.y += 15;
            this.repaint();
        } else if (keyCode == this.getKeyCode(1)) {
            this.y -= 15;
            this.repaint();
        } else if (keyCode == this.getKeyCode(2)) {
            this.x -= 15;
            this.repaint();
        } else if (keyCode == this.getKeyCode(5)) {
            this.x += 15;
            this.repaint();
        } else if (keyCode == 57) {
            this.handleKey(0);
        } else if (keyCode == 56) {
            this.handleKey(1);
        } else if (keyCode == 55) {
            this.handleKey(2);
        } else if (keyCode == 54) {
            this.handleKey(3);
        } else if (keyCode == 53) {
            this.handleKey(4);
        } else if (keyCode == 52) {
            this.handleKey(5);
        } else if (keyCode == 51) {
            this.handleKey(6);
        } else if (keyCode == 50) {
            this.handleKey(7);
        } else if (keyCode == 49) {
            this.handleKey(8);
        } else if (keyCode == 35 || keyCode == 42) {
            this.gameOver = true;
            this.handleKey(-1);
        }
    }

    private void handleKey(int key) {
        if (this.gameOver) {
            this.listener.gameOver();
        } else if (!this.course.isHighlight(key)) {
            this.course.highlight(key, this.x, this.y);
        } else if (this.course.isHighlight(key)) {
            Player player = this.course.getCurrentPlayer();
            player.setPosition(this.course.getChosenPoint());
            if (this.course.getChosenGear() == -1) {
                player.shiftDown();
            } else if (this.course.getChosenGear() == 1) {
                player.shiftUp();
            } else if (this.course.getChosenGear() == 0) {
                player.holdShift();
            }
            this.course.checkSlipStream(player);
            player.getScore().incStep();
            this.repaint();
            this.course.resetHighlight();
        }
        this.repaint();
    }

    public void play() {
        this.current = (this.current + 1) % this.players.length;
        if (!this.canOnePlayerMove()) {
            this.resetMoved();
        }
        if (!this.players[this.current].isCrashed() && !this.players[this.current].isFinished() && this.players[this.current].isCanMove()) {
            this.course.setCurrentPlayer(this.players[this.current]);
            this.players[this.current].setCanMove(false);
            if (this.isOneCarLeft() && this.players.length > 1 || this.isEveryoneFinished()) {
                this.course.end();
            }
            this.x = (int)this.getMiddleOfAction().getX() - this.getWidth() / 2;
            this.y = (int)this.getMiddleOfAction().getY() - this.getHeight() / 2;
            this.repaint();
        } else {
            if (this.isOneCarLeft() && this.players.length > 1 || this.isEveryoneFinished()) {
                this.course.end();
            }
            if (!this.gameOver) {
                this.play();
            }
        }
    }

    private void resetMoved() {
        int i = 0;
        while (i < this.players.length) {
            this.players[i].setCanMove(true);
            ++i;
        }
    }

    private boolean canOnePlayerMove() {
        int i = 0;
        while (i < this.players.length) {
            if (this.players[i].isCanMove() && !this.players[i].isFinished() && !this.players[i].isCrashed()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isOneCarLeft() {
        int cars = 0;
        int i = 0;
        while (i < this.players.length) {
            if (!this.players[i].isCrashed()) {
                ++cars;
            }
            ++i;
        }
        return cars == 1;
    }

    private boolean isEveryoneFinished() {
        int cars = 0;
        int i = 0;
        while (i < this.players.length) {
            if (!this.players[i].isFinished()) {
                ++cars;
            }
            ++i;
        }
        return cars == 0;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Player player;
        if (evt.getPropertyName().equals("CRASH") || evt.getPropertyName().equals("SHIFT_DOWN") || evt.getPropertyName().equals("SHIFT_UP") || evt.getPropertyName().equals("SHIFT_HOLD")) {
            player = (Player)evt.getSource();
            if (evt.getPropertyName().equals("CRASH")) {
                player.getScore().setRank(this.negativeRank);
                --this.negativeRank;
            }
            if (evt.getPropertyName().equals("SHIFT_DOWN")) {
                Sound.playWAV("GearDown");
            }
            if (evt.getPropertyName().equals("SHIFT_UP")) {
                if (player.getScore().getStep() == 0) {
                    Sound.playWAV("CarStart");
                } else {
                    Sound.playWAV("GearUp");
                }
            }
            if (evt.getPropertyName().equals("SHIFT_HOLD")) {
                if (player.getScore().getStep() == 0) {
                    Sound.playWAV("CarStart");
                }
                Sound.playWAV("gear");
            }
            this.play();
        }
        if (evt.getPropertyName().equals("SET_POSITON")) {
            this.repaint();
        } else if (evt.getPropertyName().equals("CURRENT_PLAYER")) {
            this.repaint();
        } else if (evt.getPropertyName().equals("TRANSITION")) {
            this.repaint();
        } else if (evt.getPropertyName().equals("UPDATE_SCORE")) {
            Sort.sort(this.players);
            this.repaint();
        } else if (evt.getPropertyName().equals("FINISH")) {
            Sound.playWAV("CarGoal");
            player = (Player)evt.getNewValue();
            player.getScore().setRank(this.rank);
            ++this.rank;
        } else if (evt.getPropertyName().equals("GAME_OVER")) {
            Sort.sort(this.players);
            this.gameOver = true;
            this.repaint();
        }
    }

    public int carColorMap(int player) {
        switch (player) {
            case 0: {
                return -16776838;
            }
            case 1: {
                return -8388608;
            }
            case 2: {
                return -16482559;
            }
            case 3: {
                return -76544;
            }
            case 4: {
                return -16776960;
            }
            case 5: {
                return -8322943;
            }
        }
        return -1;
    }

    private void initCourse() {
        try {
            this.course = new Course("/course2.svg");
            double r1 = this.ratio / (double)(this.course.getBounds().getWidth() / this.getWidth());
            double r2 = this.ratio / (double)(this.course.getBounds().getHeight() / this.getHeight());
            this.course.setRatio(r1 < r2 ? r1 : r2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initCharacters() {
        Utils.loadCharacters("score", -1, (int)((double)this.getHeight() * (1.0 - this.course.getRatio()) - (double)(2 * CellRace.MAX_PLAYERS * 2)) / CellRace.MAX_PLAYERS / 2, 0xFFFFFF);
    }

    public void initPlayers() {
        this.players = new Player[this.setup.getPlayerNr()];
    }

    public void initPlayer(int player) {
        Image car = Utils.createThumbnail("car", "car" + player, -1, this.course.getGrids()[0].getHeigth(), false);
        Image carCrashed = Utils.createThumbnail("car", "car_crashed", -1, this.course.getGrids()[0].getHeigth(), false);
        this.players[player] = new Player(this.setup.getPlayerNames()[player]);
        this.players[player].setCar(new Car(car, carCrashed, this.carColorMap(player)));
        this.players[player].getCar().addGear(0.8267349088394192, 27.0);
        this.players[player].getCar().addGear(0.39269908169872414, 52.0);
        this.players[player].getCar().addGear(0.241660973353061, 70.0);
        this.players[player].getCar().addGear(0.18479956785822313, 90.0);
        this.players[player].getCar().addGear(0.13659098493868665, 120.0);
        this.players[player].setPosition(new StraightLine(this.course.getStartGrid(player), this.course.getStartGridDirection(player)));
        this.players[player].addPropertyChangeListener(this);
        this.players[player].addPropertyChangeListener(this.course);
        this.players[player].getScore().addPropertyChangeListener(this);
    }

    public void initDone() {
        this.course.setPlayers(this.players);
        this.course.addPropertyChangeListener(this);
        this.loaded = true;
        this.repaint();
    }

    public int getSteps() {
        if (this.setup == null) {
            return -1;
        }
        return 4 + this.setup.getPlayerNr();
    }

    public void loadStep(int step) {
        if (step == 0) {
            this.initCourse();
        } else if (step == 1) {
            this.initCharacters();
        } else if (step == 2) {
            this.initPlayers();
        } else if (step > 2 && step <= 2 + this.setup.getPlayerNr()) {
            this.initPlayer(step - 3);
        } else if (step == 3 + this.setup.getPlayerNr()) {
            this.initDone();
            Sound.stopMIDI();
            Sound.playWAV("GameStart", false);
        } else {
            throw new RuntimeException("should never happen");
        }
    }

    public void setSetup(Setup setup) {
        this.setup = setup;
    }
}

