/*
 * Decompiled with CFR 0.152.
 */
package cellrace;

import cellrace.CellRace;
import cellrace.CellRaceListener;
import cellrace.Credits;
import cellrace.FinishLoadingListener;
import cellrace.Loader;
import cellrace.Setup;
import cellrace.Utils;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import utils.Cache;
import utils.Progres;
import utils.Sound;

public class Menu {
    public static final int SCREEN_PLAY = 0;
    public static final int SCREEN_SETUP = 1;
    public static final int SCREEN_CREDITS = 2;
    public static final int SCREEN_NETWORK = 3;
    public static final int SCREEN_EXIT = 4;
    public static final int SCREEN_MENU = 4;
    private static final int MENU_PLAY = 0;
    private static final int MENU_SETUP = 1;
    private static final int MENU_CREDITS = 2;
    private static final int MENU_NETWORK = 3;
    private static final int MENU_EXIT = 4;
    private int currentScreenStatus = 4;
    private int currentMenuStatus = 0;
    private ChoiceMenu startMenu;
    private Setup setup;
    private Credits credits;
    private Image title;
    private int barHeight;
    private final CellRaceListener listener;
    private final FinishLoadingListener listener2;
    private final Loader loader;
    private int progres = 0;

    public Menu(CellRaceListener listener, FinishLoadingListener listener2, Loader loader) {
        this.listener = listener;
        this.listener2 = listener2;
        this.loader = loader;
        try {
            this.startMenu = new ChoiceMenu();
            this.setup = new Setup(listener);
            listener.setup(this.getSetup());
            this.credits = new Credits(listener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Canvas currentCanvas() {
        switch (this.getCurrentScrennStatus()) {
            case 4: {
                return this.startMenu;
            }
            case 1: {
                return this.backToStartMenu(this.getSetup().currentCanvas());
            }
            case 2: {
                return this.backToStartMenu(this.credits.currentCanvas());
            }
        }
        return this.startMenu;
    }

    private Canvas backToStartMenu(Canvas c) {
        if (c == null) {
            this.setCurrentScreenStatus(4);
            return this.currentCanvas();
        }
        return c;
    }

    private void load() {
        this.listener.refreshCanvas();
        this.progres = 0;
        while (this.progres < this.loader.getSteps()) {
            this.loader.loadStep(this.progres);
            this.listener.refreshCanvas();
            ++this.progres;
        }
    }

    ChoiceMenu getStartMenu() {
        return this.startMenu;
    }

    public void setCurrentScreenStatus(int currentScreenStatus) {
        this.currentScreenStatus = currentScreenStatus;
    }

    public int getCurrentScrennStatus() {
        return this.currentScreenStatus;
    }

    public void setCurrentMenuStatus(int currentMenuStatus) {
        this.currentMenuStatus = currentMenuStatus;
    }

    public int getCurrentMenuStatus() {
        return this.currentMenuStatus;
    }

    public void incCurrentMenuStatus() {
        ++this.currentMenuStatus;
    }

    public void decCurrentMenuStatus() {
        --this.currentMenuStatus;
    }

    public Setup getSetup() {
        return this.setup;
    }

    public class ChoiceMenu
    extends Canvas {
        private final Progres drawProgres;

        public ChoiceMenu() {
            Menu.this.barHeight = this.getHeight() / 20;
            Menu.this.title = Utils.createThumbnail("", "title", this.getWidth(), this.getHeight());
            int nr = 5;
            Utils.loadCharacters("menu", -1, (this.getHeight() - Menu.this.barHeight - Menu.this.title.getHeight() - nr * 2 * 2) / nr, -1);
            this.setFullScreenMode(true);
            this.drawProgres = new Progres(0, this.getHeight() - Menu.this.barHeight, this.getWidth(), Menu.this.barHeight);
        }

        protected void paint(Graphics g) {
            g.drawImage(Utils.creteBackground(this.getWidth(), this.getHeight(), Utils.createImage("", "grass"), Utils.createImage("", "road")), 0, 0, 20);
            int height = Menu.this.title.getHeight() + 10;
            g.drawImage(Menu.this.title, 0, 0, 20);
            Image play = Utils.writeLine("menu", String.valueOf(Menu.this.getSetup().getPlayerNr()) + " player" + (Menu.this.getSetup().getPlayerNr() > 1 ? "s" : ""), Menu.this.getCurrentMenuStatus() == 0 ? 0x50000000 : 0);
            g.drawImage(play, 5, height, 20);
            Image setup = Utils.writeLine("menu", "setup", Menu.this.getCurrentMenuStatus() == 1 ? 0x50000000 : 0);
            g.drawImage(setup, 5, height += play.getHeight(), 20);
            Image network = Utils.writeLine("menu", "credits", Menu.this.getCurrentMenuStatus() == 2 ? 0x50000000 : 0);
            g.drawImage(network, 5, height += setup.getHeight(), 20);
            Image credits = Utils.writeLine("menu", "network", Menu.this.getCurrentMenuStatus() == 3 ? 0x50000000 : 0);
            g.drawImage(credits, 5, height += network.getHeight(), 20);
            Image quit = Utils.writeLine("menu", "exit", Menu.this.getCurrentMenuStatus() == 4 ? 0x50000000 : 0);
            g.drawImage(quit, 5, height += credits.getHeight(), 20);
            this.drawProgres.drawProgres(g, Menu.this.progres);
        }

        protected void keyPressed(int keyCode) {
            if (keyCode == this.getKeyCode(6)) {
                Menu.this.incCurrentMenuStatus();
                if (Menu.this.getCurrentMenuStatus() > 4) {
                    Menu.this.setCurrentMenuStatus(0);
                }
                this.repaint();
                Sound.playWAV("menu");
            } else if (keyCode == this.getKeyCode(1)) {
                Menu.this.decCurrentMenuStatus();
                if (Menu.this.getCurrentMenuStatus() < 0) {
                    Menu.this.setCurrentMenuStatus(4);
                }
                this.repaint();
                Sound.playWAV("menu");
            } else if ((keyCode == this.getKeyCode(5) || keyCode == this.getKeyCode(8)) && Menu.this.getCurrentMenuStatus() == 4) {
                Menu.this.listener.exitGame();
            } else if ((keyCode == this.getKeyCode(5) || keyCode == this.getKeyCode(8)) && Menu.this.getCurrentMenuStatus() == 2) {
                Runtime.getRuntime().gc();
                Menu.this.setCurrentScreenStatus(2);
                Menu.this.credits.enable();
                Menu.this.listener.refreshCanvas();
            } else if ((keyCode == this.getKeyCode(5) || keyCode == this.getKeyCode(8)) && Menu.this.getCurrentMenuStatus() == 1) {
                Runtime.getRuntime().gc();
                Menu.this.setCurrentScreenStatus(1);
                Menu.this.setup.enable();
                Menu.this.listener.refreshCanvas();
            } else if ((keyCode == this.getKeyCode(5) || keyCode == this.getKeyCode(8)) && Menu.this.getCurrentMenuStatus() == 0) {
                Cache.printList();
                Runtime.getRuntime().gc();
                System.err.println("Nr of players: " + Menu.this.getSetup().getPlayerNr());
                int i = 0;
                while (i < Menu.this.getSetup().getPlayerNr()) {
                    System.err.println("Name " + (i + 1) + ": " + Menu.this.getSetup().getPlayerNames()[i]);
                    ++i;
                }
                Menu.this.setCurrentScreenStatus(0);
                if (Menu.this.loader.getSteps() != -1) {
                    this.drawProgres.setMax(Menu.this.loader.getSteps());
                }
                new LoadThread().start();
            } else if (keyCode == 35 || keyCode == 42) {
                if (Menu.this.getCurrentMenuStatus() != 4) {
                    Menu.this.setCurrentMenuStatus(4);
                } else {
                    CellRace.CELLRACE.exit();
                }
                Menu.this.listener.refreshCanvas();
            }
        }
    }

    private final class LoadThread
    extends Thread
    implements Runnable {
        private LoadThread() {
        }

        public void run() {
            Menu.this.load();
            Menu.this.listener2.finishedLoading();
        }
    }
}

