/*
 * Decompiled with CFR 0.152.
 */
package cellrace;

import cellrace.GeomUtils;
import javax.microedition.lcdui.Graphics;

public class PolygonGraphics {
    public static void drawPolygon(Graphics g, int[] xPoints, int[] yPoints) {
        int max = xPoints.length - 1;
        int i = 0;
        while (i < max) {
            g.drawLine(xPoints[i], yPoints[i], xPoints[i + 1], yPoints[i + 1]);
            ++i;
        }
        g.drawLine(xPoints[max], yPoints[max], xPoints[0], yPoints[0]);
    }

    public static void fillPolygon(Graphics g, int[] xPoints, int[] yPoints) {
        while (xPoints.length > 2) {
            int a = GeomUtils.indexOfLeast(xPoints);
            int b = (a + 1) % xPoints.length;
            int c = a <= 0 ? xPoints.length - 1 : a - 1;
            int leastInternalIndex = -1;
            boolean leastInternalSet = false;
            if (xPoints.length > 3) {
                int i = 0;
                while (i < xPoints.length) {
                    if (i != a && i != b && i != c && GeomUtils.withinBounds(xPoints[i], yPoints[i], xPoints[a], yPoints[a], xPoints[b], yPoints[b], xPoints[c], yPoints[c]) && (!leastInternalSet || xPoints[i] < xPoints[leastInternalIndex])) {
                        leastInternalIndex = i;
                        leastInternalSet = true;
                    }
                    ++i;
                }
            }
            if (!leastInternalSet) {
                g.fillTriangle(xPoints[a], yPoints[a], xPoints[b], yPoints[b], xPoints[c], yPoints[c]);
                int[][] trimmed = GeomUtils.trimEar(xPoints, yPoints, a);
                xPoints = trimmed[0];
                yPoints = trimmed[1];
                continue;
            }
            int[][][] split = GeomUtils.split(xPoints, yPoints, a, leastInternalIndex);
            int[][] poly1 = split[0];
            int[][] poly2 = split[1];
            PolygonGraphics.fillPolygon(g, poly1[0], poly1[1]);
            PolygonGraphics.fillPolygon(g, poly2[0], poly2[1]);
            break;
        }
    }
}

