/*
 * Decompiled with CFR 0.152.
 */
package cellrace;

import cellrace.CellRaceCanvas;
import cellrace.FinishLoadingListener;
import cellrace.Loader;
import cellrace.Utils;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.TiledLayer;
import utils.Progres;

public class SplashScreen
extends CellRaceCanvas {
    private final FinishLoadingListener finishLoadingListener;
    private final Loader loader;
    private final Image logo;
    private final Image title;
    private int heghtScreen = -1;
    private int widthScreen = -1;
    private final TiledLayer tiledLayer;
    private boolean logoDisplayed = false;
    private int progres = 0;
    private final Progres drawProgres;
    private final int barHeight;

    public SplashScreen(FinishLoadingListener finishLoadingListener, Loader loader) throws IOException {
        this.finishLoadingListener = finishLoadingListener;
        this.loader = loader;
        this.barHeight = this.getHeight() / 20;
        this.title = Utils.createThumbnail("", "title", this.getWidth(), this.getHeight(), true);
        System.err.println("wow" + this.title.getHeight());
        System.err.println("wow" + this.title.getWidth());
        this.logo = Utils.createThumbnail("splash", "logo", this.getWidth(), this.getHeight() - this.title.getHeight() - this.barHeight, false);
        Image grass = Utils.createImage("", "grass");
        int heightGrass = grass.getHeight();
        int widthGrass = grass.getWidth();
        this.heghtScreen = this.getHeight();
        this.widthScreen = this.getWidth();
        int tilesx = this.widthScreen / widthGrass + 1;
        int tilesy = this.heghtScreen / heightGrass + 1;
        this.tiledLayer = new TiledLayer(tilesx, tilesy, grass, widthGrass, heightGrass);
        this.tiledLayer.fillCells(0, 0, tilesx, tilesy, 1);
        this.drawProgres = new Progres(0, this.getHeight() - this.barHeight, this.getWidth(), this.barHeight, loader.getSteps());
        this.repaint();
    }

    protected void showNotify() {
        new LoadThread().start();
    }

    private void load() {
        this.progres = 0;
        while (this.progres < this.loader.getSteps()) {
            this.loader.loadStep(this.progres);
            this.repaint();
            ++this.progres;
        }
    }

    protected void paint(Graphics g) {
        if (this.tiledLayer != null && this.logo != null && !this.logoDisplayed) {
            this.tiledLayer.paint(g);
            g.drawImage(this.title, (this.widthScreen - this.title.getWidth()) / 2, 0, 20);
            g.drawImage(this.logo, (this.widthScreen - this.logo.getWidth()) / 2, (this.heghtScreen - this.barHeight - this.title.getHeight() - this.logo.getHeight()) / 2 + this.title.getHeight(), 20);
            System.err.println(this.heghtScreen);
            System.err.println(this.barHeight);
            System.err.println(this.title.getHeight());
            System.err.println(this.logo.getHeight());
            this.logoDisplayed = true;
        }
        this.drawProgres.drawProgres(g, this.progres);
    }

    private final class LoadThread
    extends Thread
    implements Runnable {
        private LoadThread() {
        }

        public void run() {
            SplashScreen.this.load();
            SplashScreen.this.finishLoadingListener.finishedLoading();
        }
    }
}

