/*
 * Decompiled with CFR 0.152.
 */
package cellrace;

import cellrace.ChoiceLine;
import cellrace.Line;
import cellrace.Point;
import cellrace.Vector;

public class StraightLine {
    private Vector start = new Vector(0.0, 0.0);
    private Vector direction = new Vector(0.0, 0.0);

    public StraightLine(Vector start, Vector direction) {
        this(start, direction, true);
    }

    public StraightLine(Vector start, Vector direction, boolean setDirection) {
        this.setStart(start);
        if (!setDirection) {
            direction.sub(start);
        }
        this.setDirection(direction);
    }

    public void setDirection(Vector direction) {
        this.direction = direction;
    }

    public Vector getDirection() {
        return this.direction;
    }

    public Vector getStop() {
        Vector tmp = (Vector)this.direction.clone();
        tmp.add(this.getStart());
        return tmp;
    }

    public void setStart(Vector start) {
        this.start = start;
    }

    public Vector getStart() {
        return this.start;
    }

    public double getLength() {
        return this.getDirection().abs();
    }

    public double getX1() {
        return this.start.getX();
    }

    public double getX2() {
        return this.start.getX() + this.direction.getX();
    }

    public double getY1() {
        return this.start.getY();
    }

    public double getY2() {
        return this.start.getY() + this.direction.getY();
    }

    public String toString() {
        Vector tmp = (Vector)this.direction.clone();
        tmp.add(this.start);
        StringBuffer sb = new StringBuffer("Line [");
        sb.append(this.start.toString());
        sb.append(',');
        sb.append(tmp.toString());
        sb.append(']');
        return sb.toString();
    }

    public boolean equals(Object obj) {
        ChoiceLine straightLine = (ChoiceLine)obj;
        return straightLine.getStart().equals(this.getStart()) && straightLine.getDirection().equals(this.getDirection());
    }

    public Vector[] split(int nr) {
        Vector[] v = new Vector[nr];
        int i = 1;
        while (i < nr + 1) {
            Vector ret = (Vector)this.getStart().clone();
            Vector tmp = (Vector)this.getDirection().clone();
            tmp.setLength(tmp.abs() - (double)i * tmp.abs() / (double)(nr + 1));
            ret.add(tmp);
            v[i - 1] = ret;
            ++i;
        }
        return v;
    }

    Point intersect(Line line) {
        Vector tmp = this.getStop();
        double Ax = this.getX1();
        double Ay = this.getY1();
        double Bx = tmp.getX();
        double By = tmp.getY();
        double Cx = line.getX1();
        double Cy = line.getY1();
        double Dx = line.getX2();
        double Dy = line.getY2();
        Point p = new Point();
        if (Ax == Bx && Ay == By || Cx == Dx && Cy == Dy) {
            return null;
        }
        Cx -= Ax;
        Cy -= Ay;
        Dx -= Ax;
        Dy -= Ay;
        double distAB = Math.sqrt((Bx -= Ax) * Bx + (By -= Ay) * By);
        double theCos = Bx / distAB;
        double theSin = By / distAB;
        double newX = Cx * theCos + Cy * theSin;
        Cy = Cy * theCos - Cx * theSin;
        Cx = newX;
        newX = Dx * theCos + Dy * theSin;
        Dy = Dy * theCos - Dx * theSin;
        Dx = newX;
        if (Cy == Dy) {
            return null;
        }
        double ABpos = Dx + (Cx - Dx) * Dy / (Dy - Cy);
        p.setX((int)(Ax + ABpos * theCos));
        p.setY((int)(Ay + ABpos * theSin));
        if (this.inside(p) && line.inside(p)) {
            return p;
        }
        return null;
    }

    public boolean inside(Point p) {
        double maxX = Math.max(this.getX1(), this.getX2());
        double minX = Math.min(this.getX1(), this.getX2());
        double maxY = Math.max(this.getY1(), this.getY2());
        double minY = Math.min(this.getY1(), this.getY2());
        return (double)p.getX() < maxX && (double)p.getX() > minX && (double)p.getY() < maxY && (double)p.getY() > minY;
    }

    public Line toLine() {
        return new Line((int)this.getStart().getX(), (int)this.getStart().getY(), (int)this.getStop().getX(), (int)this.getStop().getY());
    }
}

