/*
 * Decompiled with CFR 0.152.
 */
package cellrace;

import cellrace.Point;
import utils.MathExtension;

public class Vector {
    private double x;
    private double y;

    public Vector(double x, double y) {
        this.setX(x);
        this.setY(y);
    }

    public Vector(Point point) {
        this.setX(point.getX());
        this.setY(point.getY());
    }

    public double dot(Vector v1) {
        double ret = this.getX() * v1.getX() + this.getY() * v1.getY();
        return ret;
    }

    public void add(Vector v1) {
        this.setX(this.getX() + v1.getX());
        this.setY(this.getY() + v1.getY());
    }

    public void mul(double m) {
        this.setX(this.getX() * m);
        this.setY(this.getY() * m);
    }

    public void sub(Vector v1) {
        this.setX(this.getX() - v1.getX());
        this.setY(this.getY() - v1.getY());
    }

    public void scale(double scale) {
        this.setX(this.getX() * scale);
        this.setY(this.getY() * scale);
    }

    public void setLength(double length) {
        this.scale(1.0 / this.abs() * length);
    }

    public double abs() {
        return Math.sqrt(this.getX() * this.getX() + this.getY() * this.getY());
    }

    public void cross() {
        double tmp = this.getX();
        this.setX(this.getY());
        this.setY(-tmp);
    }

    public double angel(Vector v1) {
        double me = this.dot(v1) / (this.abs() * v1.abs());
        return MathExtension.acos(me);
    }

    public boolean leftOf(Vector v1) {
        Vector tmp = (Vector)this.clone();
        tmp.cross();
        double ang2 = tmp.angel(v1);
        return ang2 >= 1.5707963267948966;
    }

    public void rotate(double a) {
        if (a > Math.PI) {
            double n = a - Math.PI;
            double n2 = 1.5707963267948966;
            a = Math.abs(n2 - n);
            double tmpx = this.getX() * Math.cos(a) - this.getY() * Math.sin(a);
            double tmpy = this.getX() * Math.sin(a) + this.getY() * Math.cos(a);
            this.setX(tmpx);
            this.setY(tmpy);
            this.cross();
        } else {
            double tmpx = this.getX() * Math.cos(a) - this.getY() * Math.sin(a);
            double tmpy = this.getX() * Math.sin(a) + this.getY() * Math.cos(a);
            this.setX(tmpx);
            this.setY(tmpy);
        }
    }

    public Object clone() {
        return new Vector(this.getX(), this.getY());
    }

    public boolean rigthOf(Vector v1) {
        Vector tmp = (Vector)this.clone();
        tmp.cross();
        double ang2 = tmp.angel(v1);
        return ang2 <= 1.5707963267948966;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getX() {
        return this.x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getY() {
        return this.y;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(91);
        sb.append(this.getX());
        sb.append(',');
        sb.append(this.getY());
        sb.append(']');
        return sb.toString();
    }

    public Point toPoint() {
        return new Point((int)this.getX(), (int)this.getY());
    }

    public double distance(Vector v1) {
        return 0.0;
    }

    public boolean equals(Object obj) {
        Vector vector = (Vector)obj;
        return vector.getX() == this.getX() && vector.getY() == this.getY();
    }
}

