/*
 * Decompiled with CFR 0.152.
 */
package StarifficEditorGame;

import StarifficEditorGame.FP;
import StarifficEditorGame.Vec2;
import javax.microedition.lcdui.Graphics;

public class ParticleSystem {
    private static final int PARTICLE_SIZE = FP.toFP(0.3f);
    private Particle m_active = new Particle();
    private Particle m_free;

    public ParticleSystem(int max_particles) {
        Particle last = this.m_free = new Particle();
        int i = 0;
        while (i < max_particles) {
            Particle p;
            last.next = p = new Particle();
            last = p;
            ++i;
        }
    }

    public void addParticle(int[] pos, int[] vel, int col, int time) {
        Particle p = this.allocate();
        if (p == null) {
            return;
        }
        p.time_left = time;
        Vec2.set(p.pos, pos);
        if (vel != null) {
            Vec2.set(p.vel, vel);
        } else {
            Vec2.set(p.vel, 0, 0);
        }
        p.col = col;
    }

    public void update(int fp_secs, int[] gravity) {
        Particle last = this.m_active;
        Particle p = this.m_active.next;
        while (p != null) {
            boolean delete = false;
            p.time_left -= fp_secs;
            if (p.time_left <= 0) {
                delete = true;
            }
            Vec2.addScaled(p.pos, p.pos, p.vel, fp_secs);
            Vec2.addScaled(p.vel, p.vel, gravity, fp_secs);
            if (delete) {
                last.next = p.next;
                p.next = this.m_free.next;
                this.m_free.next = p;
                p = last.next;
                continue;
            }
            last = p;
            p = p.next;
        }
    }

    public void render(Graphics g, int top_x, int top_y, int scale_x, int scale_y) {
        int size = FP.toInt(FP.mul(PARTICLE_SIZE, scale_x));
        int size2 = size / 2;
        Particle p = this.m_active.next;
        while (p != null) {
            int x = FP.toInt(FP.mul(p.pos[0] - top_x, scale_x));
            int y = FP.toInt(FP.mul(p.pos[1] - top_y, scale_y));
            g.setColor(p.col);
            g.fillRect(x - size2, y - size2, size, size);
            p = p.next;
        }
    }

    private Particle allocate() {
        if (this.m_free.next == null) {
            return null;
        }
        Particle p = this.m_free.next;
        this.m_free.next = p.next;
        p.next = this.m_active.next;
        this.m_active.next = p;
        return p;
    }

    private static class Particle {
        public Particle next;
        public int time_left;
        public int[] pos = new int[2];
        public int[] vel = new int[2];
        public int col;

        Particle() {
        }
    }
}

