/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public abstract class MenuBackgroundScreen
extends Screen {
    private Mesh m_mesh = Res.meshes.find("menu01");
    private int[] m_mesh_cache;
    private int m_aspect = 65536;
    private int m_width = 65536;
    private int m_height = 65536;
    private int m_center_x;
    private int m_center_y;

    public MenuBackgroundScreen() {
        if (this.m_mesh == null) {
            return;
        }
        BoundingBox bbox = this.m_mesh.getBounds();
        this.m_width = bbox.x2 - bbox.x1;
        this.m_height = bbox.y2 - bbox.y1;
        this.m_aspect = FP.div(this.m_width, this.m_height);
        this.m_center_x = (bbox.x1 + bbox.x2) / 2;
        this.m_center_y = (bbox.y1 + bbox.y1) / 2;
    }

    public void render(Graphics g, int w, int h) {
        g.setColor(-12366508);
        g.fillRect(0, 0, w, h);
        if (this.m_mesh == null) {
            return;
        }
        int aspect = FP.toFP(w) / h;
        int scale_x = 0;
        int scale_y = 0;
        int vis_w = this.m_width;
        int vis_h = this.m_height;
        if (aspect <= this.m_aspect) {
            scale_x = scale_y = FP.div(FP.toFP(w), this.m_width);
            vis_h = FP.mul(vis_h, FP.div(this.m_aspect, aspect));
        } else {
            scale_x = scale_y = FP.div(FP.toFP(h), this.m_height);
            vis_w = FP.mul(vis_w, FP.div(aspect, this.m_aspect));
        }
        int top_x = this.m_center_x - (vis_w >> 1);
        int top_y = this.m_center_y - (vis_h >> 1);
        this.m_mesh_cache = this.m_mesh.render(g, 65536, 0, -top_x, -top_y, scale_x, scale_y, this.m_mesh_cache);
        g.setColor(-12366508);
        g.setFont(Font.getFont((int)64, (int)1, (int)16));
        MiscUtils.writeCentered(g, "S T A R I F F I C", h / 8, w);
        g.setColor(-12366508);
        Font f = Font.getFont((int)64, (int)1, (int)8);
        g.setFont(f);
        MiscUtils.writeShadowed(g, "1.0", 2, h - 2 - f.getHeight());
    }
}

