using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Text;
using System.Windows.Forms;

namespace StarifficEditor
{
    public partial class ExportForm : Form
    {
        private String m_level_path;
        private String m_export_path;
        private Meshes m_meshes;

        private ExportOptions m_options;

        public ExportForm()
        {
            InitializeComponent();
        }

        public ExportForm(String level_path, String export_path, Meshes meshes) : this()
        {
            m_level_path = level_path;
            m_export_path = export_path;
            m_meshes = meshes;

            // Get the export options
            m_options = new ExportOptions(m_level_path);
            m_options.Load();

            foreach (String level in m_options.levels)
            {
                listBoxExportLevels.Items.Add(level);
            }

            // Get the list of levels
            String[] levels = Directory.GetFiles(level_path, "*.lev");
            Array.Sort(levels);
            foreach (String level in levels)
            {
                listBoxDiskLevels.Items.Add(Path.GetFileName(level).ToLower());
            }

            // Read the meshes
            meshes.Refresh();
        }

        private void listBoxDiskLevels_SelectedIndexChanged(object sender, EventArgs e)
        {
            bool ok = (listBoxDiskLevels.SelectedIndex != -1);

            buttonAdd.Enabled = ok;
        }

        private void listBoxExportLevels_SelectedIndexChanged(object sender, EventArgs e)
        {
            bool ok = (listBoxExportLevels.SelectedIndex != -1);

            buttonRemove.Enabled = ok;
            buttonUp.Enabled = ok;
            buttonDown.Enabled = ok;
        }

        private void buttonAdd_Click(object sender, EventArgs e)
        {
            String item = listBoxDiskLevels.SelectedItem as String;
            if (item == null)
                return;

            // Already added?
            int idx = listBoxExportLevels.Items.IndexOf(item);
            if (idx < 0)
            {
                idx = listBoxExportLevels.Items.Count;
                listBoxExportLevels.Items.Add(item);
            }

            listBoxExportLevels.SelectedIndex = idx;
        }

        private void buttonRemove_Click(object sender, EventArgs e)
        {
            int idx = listBoxExportLevels.SelectedIndex;
            if (idx < 0)
                return;

            listBoxExportLevels.SelectedIndex = -1;
            listBoxExportLevels.Items.RemoveAt(idx);
        }

        private void buttonUp_Click(object sender, EventArgs e)
        {
            int idx = listBoxExportLevels.SelectedIndex;
            if (idx <= 0)
                return;
            Object item = listBoxExportLevels.SelectedItem;

            listBoxExportLevels.Items.RemoveAt(idx);
            listBoxExportLevels.Items.Insert(idx - 1, item);
            listBoxExportLevels.SelectedIndex = idx - 1;
        }

        private void buttonDown_Click(object sender, EventArgs e)
        {
            int idx = listBoxExportLevels.SelectedIndex;
            if (idx < 0 || idx >= (listBoxExportLevels.Items.Count-1))
                return;
            Object item = listBoxExportLevels.SelectedItem;

            listBoxExportLevels.Items.RemoveAt(idx);
            listBoxExportLevels.Items.Insert(idx + 1, item);
            listBoxExportLevels.SelectedIndex = idx + 1;
        }

        private void buttonSaveClose_Click(object sender, EventArgs e)
        {
            SaveOptions();
            Close();
        }

        private void buttonSaveExport_Click(object sender, EventArgs e)
        {
            SaveOptions();

            // Export
            DoExportForm form = new DoExportForm(m_options, m_export_path, m_meshes);
            form.ShowDialog(this);

            Close();
        }

        private void SaveOptions()
        {
            // Update from the form
            m_options.levels.Clear();
            foreach (String level in listBoxExportLevels.Items)
                m_options.levels.Add(level);

            // Save
            m_options.Save();
        }
    }
}