using System;
using System.Collections.Generic;
using System.IO;
using System.Text;

namespace StarifficEditor
{
    public class JavaBinaryWriter : BinaryWriter
    {
        public double FixedNumberScale = 1.0;

        public JavaBinaryWriter(Stream stm) : base(stm)
        {
        }

        public override void Write(char ch)
        {
            WriteJava(BitConverter.GetBytes(ch));
        }

        public override void Write(char[] chars, int index, int count)
        {
            while (count-- > 0)
                Write(chars[index++]);
        }

        public override void Write(char[] chars)
        {
            Write(chars, 0, chars.Length);
        }

        public override void Write(float value)
        {
            WriteJava(BitConverter.GetBytes(value));
        }

        public override void Write(double value)
        {
            WriteJava(BitConverter.GetBytes(value));
        }

        public override void Write(int value)
        {
            WriteJava(BitConverter.GetBytes(value));
        }

        public override void Write(long value)
        {
            WriteJava(BitConverter.GetBytes(value));
        }

        public override void Write(short value)
        {
            WriteJava(BitConverter.GetBytes(value));
        }

        public override void Write(uint value)
        {
            WriteJava(BitConverter.GetBytes(value));
        }

        public override void Write(ulong value)
        {
            WriteJava(BitConverter.GetBytes(value));
        }

        public override void Write(ushort value)
        {
            WriteJava(BitConverter.GetBytes(value));
        }

        public override void Write(string value)
        {
            byte[] data = Encoding.UTF8.GetBytes(value);
            Write((short)data.Length);
            Write(data);
        }

        public void WriteFixed(float value)
        {
            WriteFixedScaled(value, 1.0);
        }

        public void WriteFixedScaled(float value)
        {
            WriteFixedScaled(value, FixedNumberScale);
        }

        public void WriteFixedScaled(float value, double scale)
        {
            Write((int)(value * scale * 65536.0));
        }

        private void WriteJava(byte[] data)
        {
            if (BitConverter.IsLittleEndian)
            {
                int p1 = 0;
                int p2 = data.Length - 1;
                while (p1 < p2)
                {
                    byte tmp = data[p1];
                    data[p1] = data[p2];
                    data[p2] = tmp;

                    ++p1;
                    --p2;
                }
            }

            Write(data);
        }
    }
}
